/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.relict;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INestingMob;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ProjectileSpit;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartHurtByTargetGoal;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.entity.ai.unique.SpitterAttackGoal;
import untamedwilds.entity.ai.unique.SpitterTerritorialityGoal;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class EntitySpitter
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INestingMob,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> CAN_GROW = SynchedEntityData.m_135353_(EntitySpitter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(EntitySpitter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation ATTACK_MAUL_RIGHT;
    public static Animation ATTACK_MAUL_LEFT;
    public static Animation ATTACK_SPIT;
    public static Animation ANIMATION_EAT;
    public static Animation IDLE_WATCH;
    public static Animation IDLE_TALK;
    public int aggroProgress;

    public EntitySpitter(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        ATTACK_MAUL_RIGHT = Animation.create((int)22);
        ATTACK_MAUL_LEFT = Animation.create((int)22);
        ATTACK_SPIT = Animation.create((int)20);
        IDLE_TALK = Animation.create((int)40);
        IDLE_WATCH = Animation.create((int)80);
        ANIMATION_EAT = Animation.create((int)80);
        this.turn_speed = 0.3f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAN_GROW, (Object)false);
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new FindItemsGoal(this, 12, true));
        this.f_21345_.m_25352_(2, (Goal)new SpitterAttackGoal(this, 2.0, false, 1.0f));
        this.f_21345_.m_25352_(3, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntitySpitter.getEcoLevel(input) > EntitySpitter.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(4, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new GrazeGoal(this, 300){

            @Override
            public boolean isGrazeable() {
                return this.entityWorld.m_8055_(this.testpos).m_60713_(Blocks.f_152547_) || this.entityWorld.m_8055_(this.testpos.m_7495_()).m_60734_() == Blocks.f_50129_;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new SmartHurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{EntitySpitter.class}));
        this.f_21346_.m_25352_(3, new ProtectChildrenTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntitySpitter)));
        this.f_21346_.m_25352_(4, new SpitterTerritorialityGoal<EntitySpitter>(this, EntitySpitter.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 0.8).m_22268_(Attributes.f_22279_, 0.16).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22284_, 0.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntitySpitter.class, this.m_142469_().m_82377_(32.0, 12.0, 32.0));
            return list.size() < 6;
        }
        return false;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public void m_146762_(int age) {
        int i = this.f_146733_;
        if (this.m_6162_() && i < 100 && !this.getWantsToGrow()) {
            super.m_146762_(Math.max(-12000, (Integer)ConfigGamerules.cycleLength.get() / -2));
        } else {
            super.m_146762_(age);
        }
    }

    public boolean wantsToGrow() {
        if (this.m_6162_()) {
            List list = this.f_19853_.m_45976_(EntitySpitter.class, this.m_142469_().m_82377_(32.0, 16.0, 32.0));
            for (EntitySpitter spitter : list) {
                if (spitter.getGender() != this.getGender() || spitter.m_6162_() && !spitter.getWantsToGrow()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public EntitySpitter getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntitySpitter((EntityType<? extends ComplexMob>)((EntityType)ModEntity.SPITTER.get()), this.f_19853_));
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public Animation getAnimationEat() {
        return ANIMATION_EAT;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 600 == 0) {
                if (!this.getWantsToGrow()) {
                    this.setWantsToGrow(this.wantsToGrow());
                }
                if (this.wantsToLayEggs() && !this.isMale()) {
                    for (int k = 0; k < 3; ++k) {
                        BlockState state = ((Block)ModBlock.EGG_SPITTER.get()).m_49966_();
                        BlockPos blockpos = this.m_142538_().m_142082_(this.f_19796_.nextInt(3) - 1, 1 - this.f_19796_.nextInt(3), this.f_19796_.nextInt(3) - 1);
                        if (!this.m_183503_().m_46739_(blockpos) || !this.m_183503_().m_8055_(blockpos).m_60713_(Blocks.f_49990_) || !state.m_60710_((LevelReader)this.m_183503_(), blockpos)) continue;
                        this.m_183503_().m_7731_(blockpos, state, 2);
                        this.setEggStatus(false);
                    }
                }
            }
            if (this.f_19853_.m_46467_() % 500L == 0L) {
                this.addHunger(-3);
                if (!this.isStarving()) {
                    this.m_5634_(2.0f);
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_() && this.getCommandInt() == 0) {
                int i = this.f_19796_.nextInt(3000);
                if (i == 0 && !this.m_20069_() && this.isNotMoving() && this.canMove() && this.isActive()) {
                    this.m_21573_().m_26573_();
                    this.setSitting(true);
                } else if ((i == 1 || this.m_20069_()) && this.isSitting() && this.getCommandInt() < 2) {
                    this.setSitting(false);
                } else if (i < 25 && !this.m_20069_() && !this.m_6162_()) {
                    this.setAnimation(IDLE_TALK);
                } else if (i > 2980 && !this.m_20069_() && !this.m_6162_() && this.canMove() && this.isNotMoving()) {
                    this.setAnimation(IDLE_WATCH);
                }
            }
            if (this.m_5448_() != null && (this.getAnimation() == ATTACK_SPIT || this.m_6162_())) {
                this.m_20256_(this.m_20184_().m_82490_((double)0.6f));
                if (this.getAnimationTick() == 14) {
                    this.performRangedAttack(this.m_5448_(), 0.5f);
                }
            }
            this.setAngry(this.m_5448_() != null);
        }
        if (this.getAnimation() == ANIMATION_EAT && (this.getAnimationTick() == 10 || this.getAnimationTick() == 20 || this.getAnimationTick() == 30)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
        }
        if (this.getAnimation() == ATTACK_MAUL_RIGHT && this.getAnimationTick() == 10) {
            this.m_5496_(SoundEvents.f_12317_, 1.5f, 0.8f);
        }
        if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1 && this.m_7515_() != null) {
            this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
        }
        if (this.f_19853_.f_46443_ && this.isAngry() && this.aggroProgress < 40) {
            ++this.aggroProgress;
        } else if (this.f_19853_.f_46443_ && !this.isAngry() && this.aggroProgress > 0) {
            --this.aggroProgress;
        }
        super.m_8107_();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_11963_, 0.15f, 1.0f);
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SmartFollowOwnerGoal(this, 2.3, 12.0f, 3.0f));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_() && !this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
            if (this.m_21187_().nextInt(3) == 0) {
                this.m_21828_(player);
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
            this.setAnimationTick(0);
        }
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        TamableAnimal tamable;
        Entity entity;
        float f = this.m_21223_();
        if (!this.f_19853_.f_46443_ && !this.m_21525_() && this.m_5448_() == damageSource.m_7639_() && amount < f && (damageSource.m_7639_() != null || damageSource.m_7640_() != null) && damageSource.m_7639_() instanceof LivingEntity && (entity = damageSource.m_7639_()) instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_142480_() != null && this.m_142582_(damageSource.m_7639_()) && !damageSource.m_7639_().m_20147_() && this.getAnimation() == NO_ANIMATION) {
            this.m_7327_(damageSource.m_7639_());
        }
        return super.m_6469_(damageSource, amount);
    }

    private Animation chooseAttackAnimation() {
        return switch (this.f_19796_.nextInt(2)) {
            case 0 -> ATTACK_MAUL_LEFT;
            case 1 -> ATTACK_MAUL_RIGHT;
            default -> ATTACK_MAUL_RIGHT;
        };
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_MAUL_RIGHT, ATTACK_MAUL_LEFT, ATTACK_SPIT, IDLE_WATCH, IDLE_TALK, ANIMATION_EAT};
    }

    public boolean m_7301_(MobEffectInstance potionEffectIn) {
        return potionEffectIn.m_19544_() != MobEffects.f_19614_ && super.m_7301_(potionEffectIn);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.9f;
    }

    public boolean getWantsToGrow() {
        return (Boolean)this.f_19804_.m_135370_(CAN_GROW);
    }

    private void setWantsToGrow(boolean can_grow) {
        this.f_19804_.m_135381_(CAN_GROW, (Object)can_grow);
    }

    @Override
    public boolean wantsToLayEggs() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setEggStatus(boolean status) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)status);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("canGrow", this.getWantsToGrow());
        compound.m_128379_("has_egg", this.wantsToLayEggs());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setWantsToGrow(compound.m_128471_("canGrow"));
        this.setEggStatus(compound.m_128471_("has_egg"));
    }

    public void performRangedAttack(LivingEntity entityIn, float p_33318_) {
        ProjectileSpit camel_spit = new ProjectileSpit(this.f_19853_, this, new MobEffectInstance(MobEffects.f_19614_, 100, 0));
        double d0 = entityIn.m_20185_() - this.m_20185_();
        double d1 = entityIn.m_20227_(0.3333333333333333) - camel_spit.m_20186_();
        double d2 = entityIn.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        camel_spit.m_6686_(d0, d1 + d3, d2, 1.5f, 6.0f);
        this.m_21563_().m_148051_((Entity)entityIn);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        }
        this.f_19853_.m_7967_((Entity)camel_spit);
    }

    @Override
    public Block getNestType() {
        return (Block)ModBlock.EGG_SPITTER.get();
    }

    @Override
    public boolean isValidNestBlock(BlockPos pos) {
        return this.f_19853_.m_46859_(pos) && this.f_19853_.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.VALID_REPTILE_NEST) && this.getNestType().m_49966_().m_60710_((LevelReader)this.f_19853_, pos);
    }

    @Override
    public void updateAttributes() {
        int rand = this.m_21187_().nextInt(5);
        if (rand > 3 && !this.isMale()) {
            this.breed();
        }
    }
}

