/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.control.look.SmartSwimmerLookControl;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModSounds;
import untamedwilds.util.EntityUtils;

public class EntityOpossum
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins {
    private static final EntityDataAccessor<Boolean> PLAYING_DEAD = SynchedEntityData.m_135353_(EntityOpossum.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> JOEYS = SynchedEntityData.m_135353_(EntityOpossum.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static Animation IDLE_SCRATCH;
    public static Animation THREAT_BACK_OFF;

    public EntityOpossum(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new SmartSwimmerLookControl(this, 20);
        IDLE_SCRATCH = Animation.create((int)80);
        THREAT_BACK_OFF = Animation.create((int)30);
        this.ticksToSit = 20;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLAYING_DEAD, (Object)false);
        this.f_19804_.m_135372_(JOEYS, (Object)0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.14).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, new OpossumBackOffGoal<LivingEntity>(this, LivingEntity.class, 4.0f, 1.0, 1.1, input -> EntityOpossum.getEcoLevel(input) > EntityOpossum.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntityOpossum.getEcoLevel(input) <= EntityOpossum.getEcoLevel((LivingEntity)this)));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.003, 0.0));
                if (!this.isNotMoving() && this.f_19796_.nextInt(5) == 0 && this.m_20184_().m_165924_() > 0.08) {
                    Vec3 testpos = this.m_20182_().m_82520_(Math.cos(Math.toRadians(this.m_146908_() + 90.0f)) * -0.8, 0.0, Math.sin(Math.toRadians(this.m_146908_() + 90.0f)) * -0.8);
                    BlockPos testblockpos = new BlockPos(testpos);
                    if (this.f_19853_.m_8055_(new BlockPos((Vec3i)testblockpos.m_7495_())).m_204336_(BlockTags.f_144283_)) {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, this.f_19853_.m_8055_(testblockpos.m_7495_())), testpos.f_82479_, testpos.f_82480_ + 0.2, testpos.f_82481_, 2, (double)this.f_19796_.nextFloat() * 0.2, (double)this.f_19796_.nextFloat() * 0.2, (double)this.f_19796_.nextFloat() * 0.2, 0.0);
                    } else {
                        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123768_, testpos.f_82479_, testpos.f_82480_ + 0.2, testpos.f_82481_, 2, (double)this.f_19796_.nextFloat() * 0.2, (double)this.f_19796_.nextFloat() * 0.2, (double)this.f_19796_.nextFloat() * 0.2, 0.0);
                    }
                }
            }
            if (this.isPlayingDead() && this.forceSleep == 0) {
                this.setPlayingDead(false);
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                EntityOpossum child;
                this.m_5634_(1.0f);
                if (this.getJoeys() > 0 && this.f_19796_.nextInt(2) == 0 && (child = this.getBreedOffspring((ServerLevel)this.f_19853_, (AgeableMob)this)) != null) {
                    child.setVariant(this.getVariant());
                    child.m_146762_(this.getAdulthoodTime() * -1);
                    child.setGender(this.f_19796_.nextInt(2));
                    child.setRandomMobSize();
                    child.m_6863_(true);
                    child.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
                    if (this.m_142480_() != null) {
                        child.m_21828_((Player)this.m_142480_());
                    }
                    if (this instanceof INeedsPostUpdate) {
                        ((INeedsPostUpdate)((Object)child)).updateAttributes();
                    }
                    if (TEXTURES_COMMON.containsKey(child.m_6095_().getRegistryName().m_135815_())) {
                        this.chooseSkinForSpecies(child, true);
                    }
                    this.f_19853_.m_7967_((Entity)child);
                    this.f_19853_.m_7605_((Entity)this, (byte)18);
                    this.setJoeys(this.getJoeys() - 1);
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_()) {
                int i = this.f_19796_.nextInt(3000);
                if (i <= 8 && !this.m_20069_()) {
                    this.m_21573_().m_26573_();
                    this.setSitting(true);
                } else if ((i <= 12 || this.m_20069_()) && this.isSitting()) {
                    this.setSitting(false);
                } else if (i > 2980) {
                    this.setAnimation(IDLE_SCRATCH);
                }
            }
            if (this.getAnimation() == THREAT_BACK_OFF) {
                this.m_21566_().m_24988_(-0.5f, 0.0f);
            }
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.getJoeys() == 0 && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityOpossum.class, this.m_142469_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            return list.size() >= 1;
        }
        return false;
    }

    @Override
    public <T extends ComplexMob> void breed() {
        this.setJoeys(this.f_19796_.nextInt(3) + 1);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41619_() && this.m_6084_() && hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.setAnimation(THREAT_BACK_OFF);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public EntityOpossum getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityOpossum((EntityType<? extends ComplexMob>)((EntityType)ModEntity.OPOSSUM.get()), this.f_19853_));
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        Entity entity;
        if (!this.isPlayingDead() && (entity = damageSource.m_7639_()) instanceof Mob) {
            Mob aggressor = (Mob)entity;
            aggressor.m_6710_(null);
            this.makeAreaOfEffectCloud(this.f_19853_, this.m_142538_());
            this.setPlayingDead(true);
            this.forceSleep = 600;
        }
        return super.m_6469_(damageSource, amount);
    }

    public boolean m_7301_(MobEffectInstance potionEffectIn) {
        return potionEffectIn.m_19544_() != MobEffects.f_19614_ && super.m_7301_(potionEffectIn);
    }

    private void makeAreaOfEffectCloud(Level worldIn, BlockPos pos) {
        AreaEffectCloud linger_cloud = new AreaEffectCloud(worldIn, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        linger_cloud.m_19712_(3.0f);
        linger_cloud.m_19732_(-0.2f);
        linger_cloud.m_19740_(10);
        linger_cloud.m_19738_(-linger_cloud.m_19743_() / ((float)linger_cloud.m_19748_() * 0.2f));
        linger_cloud.m_19714_(5599028);
        linger_cloud.m_19716_(new MobEffectInstance(MobEffects.f_19604_, 80, 0, true, false));
        worldIn.m_7967_((Entity)linger_cloud);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, IDLE_SCRATCH, THREAT_BACK_OFF};
    }

    @Override
    public boolean canBeTargeted() {
        return !this.isPlayingDead();
    }

    public boolean isPlayingDead() {
        return (Boolean)this.f_19804_.m_135370_(PLAYING_DEAD);
    }

    private void setPlayingDead(boolean short_snout) {
        this.f_19804_.m_135381_(PLAYING_DEAD, (Object)short_snout);
    }

    public int getJoeys() {
        return (Integer)this.f_19804_.m_135370_(JOEYS);
    }

    private void setJoeys(int joeys) {
        this.f_19804_.m_135381_(JOEYS, (Object)joeys);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("playing_dead", this.isPlayingDead());
        compound.m_128405_("joeys", this.getJoeys());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setPlayingDead(compound.m_128471_("playing_dead"));
        this.setJoeys(compound.m_128451_("joeys"));
    }

    public static class OpossumBackOffGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        protected EntityOpossum taskOwner;
        protected final float avoidDistance;
        private final TargetingConditions builtTargetSelector;

        public OpossumBackOffGoal(EntityOpossum entityIn, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, Predicate<LivingEntity> targetSelector) {
            super((PathfinderMob)entityIn, classToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn, EntitySelector.f_20406_::test);
            this.taskOwner = entityIn;
            this.avoidDistance = avoidDistanceIn;
            this.builtTargetSelector = TargetingConditions.m_148352_().m_26883_((double)avoidDistanceIn).m_26888_(targetSelector);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (this.taskOwner.f_19797_ % 4 != 0) {
                return false;
            }
            if (this.taskOwner.m_5448_() != null || this.taskOwner.m_5803_() || this.taskOwner.getCommandInt() != 0 || this.taskOwner.m_21824_()) {
                return false;
            }
            List list = this.taskOwner.f_19853_.m_45971_(this.f_25020_, this.builtTargetSelector, (LivingEntity)this.taskOwner, this.taskOwner.m_142469_().m_82377_((double)this.avoidDistance, 4.0, (double)this.avoidDistance));
            if (list.isEmpty()) {
                return false;
            }
            this.f_25016_ = (LivingEntity)list.get(0);
            return this.f_25016_ != null;
        }

        public boolean m_8045_() {
            return this.taskOwner.getAnimation() == IAnimatedEntity.NO_ANIMATION;
        }

        public void m_8056_() {
            if (!this.taskOwner.m_21573_().m_26571_()) {
                this.taskOwner.m_21573_().m_26573_();
            }
            if (this.taskOwner.isSitting()) {
                this.taskOwner.setSitting(false);
            }
            this.taskOwner.m_5496_(ModSounds.ENTITY_OPOSSUM_HISS, 1.0f, this.taskOwner.m_6100_());
            this.taskOwner.m_21563_().m_148051_((Entity)this.f_25016_);
            this.taskOwner.setAnimation(THREAT_BACK_OFF);
        }

        public void m_8041_() {
            this.f_25016_ = null;
        }

        public void m_8037_() {
            if (this.taskOwner.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.taskOwner.setAnimation(THREAT_BACK_OFF);
            }
            this.taskOwner.m_21391_((Entity)this.f_25016_, 30.0f, 30.0f);
        }
    }
}

