/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.control.look.SmartSwimmerLookControl;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class EntityManatee
extends ComplexMobAquatic
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> IS_EATING = SynchedEntityData.m_135353_(EntityManatee.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int ringBufferIndex = -1;
    public final double[][] ringBuffer = new double[64][3];

    public EntityManatee(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_19804_.m_135372_(IS_EATING, (Object)false);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 30, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmartSwimmerLookControl(this, 30);
        this.turn_speed = 0.1f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_(Attributes.f_22277_, 8.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new ManateeFeedGoal(this, 120));
        this.f_21345_.m_25352_(4, (Goal)new ComplexMobAquatic.SwimGoal(this));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.isEating()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.01f, 0.0));
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
        }
        if (!this.m_21525_() && !this.m_6162_()) {
            if (this.ringBufferIndex < 0) {
                for (int i = 0; i < this.ringBuffer.length; ++i) {
                    this.ringBuffer[i][0] = this.m_146908_();
                    this.ringBuffer[i][1] = this.m_20186_();
                }
            }
            ++this.ringBufferIndex;
            if (this.ringBufferIndex == this.ringBuffer.length) {
                this.ringBufferIndex = 0;
            }
            this.ringBuffer[this.ringBufferIndex][0] = this.f_19859_ + 0.5f * Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
            this.ringBuffer[this.ringBufferIndex][1] = this.m_20186_();
        }
    }

    public double[] getMovementOffsets(int offset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - offset & 0x3F;
        int j = this.ringBufferIndex - offset - 1 & 0x3F;
        double[] adouble = new double[3];
        double d0 = this.ringBuffer[i][0];
        double d1 = this.ringBuffer[j][0] - d0;
        adouble[0] = d0 + d1 * (double)partialTicks;
        d0 = this.ringBuffer[i][1];
        d1 = this.ringBuffer[j][1] - d0;
        adouble[1] = d0 + d1 * (double)partialTicks;
        adouble[2] = Mth.m_14139_((double)partialTicks, (double)this.ringBuffer[i][2], (double)this.ringBuffer[j][2]);
        return adouble;
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityManatee.class, this.m_142469_().m_82377_(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityManatee)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return this.create_offspring(new EntityManatee((EntityType<? extends ComplexMob>)((EntityType)ModEntity.MANATEE.get()), this.f_19853_));
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityManatee.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityManatee.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(IS_EATING);
    }

    private void setIsEating(boolean eating) {
        this.f_19804_.m_135381_(IS_EATING, (Object)eating);
    }

    public class ManateeFeedGoal
    extends Goal {
        private final EntityManatee taskOwner;
        private final int chance;
        private BlockPos targetPos;
        private boolean taskComplete;
        private int counter;
        private int eatingCounter;

        public ManateeFeedGoal(EntityManatee entityIn, int chance) {
            this.taskOwner = entityIn;
            this.chance = chance;
        }

        public boolean m_8036_() {
            if (this.taskOwner.m_21187_().nextInt(this.chance) == 0) {
                this.taskComplete = false;
                this.targetPos = this.getNearbySandBlock(this.taskOwner.m_142538_());
                return this.targetPos != null;
            }
            return false;
        }

        private BlockPos getNearbySandBlock(BlockPos roomCenter) {
            int X = 5;
            int Y = 8;
            for (BlockPos blockpos : BlockPos.MutableBlockPos.m_121940_((BlockPos)roomCenter.m_142082_(-X, -Y, -X), (BlockPos)roomCenter.m_142082_(X, 0, X))) {
                if (!this.taskOwner.f_19853_.m_8055_(blockpos).m_204336_(ModTags.ModBlockTags.GRAZEABLE_ALGAE) || EntityManatee.this.f_19796_.nextInt(2) != 0) continue;
                return blockpos;
            }
            return null;
        }

        public boolean m_8045_() {
            return !this.taskComplete && !this.taskOwner.m_21573_().m_26571_() && this.eatingCounter != 0;
        }

        public void m_8056_() {
            this.eatingCounter = -1;
            this.taskOwner.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_7494_().m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 1.5);
        }

        public void m_8041_() {
            if (this.taskOwner.isEating()) {
                this.taskOwner.setIsEating(false);
            }
            super.m_8041_();
        }

        public void m_8037_() {
            if (this.eatingCounter > 0) {
                --this.eatingCounter;
            }
            if (this.counter == 0 && this.taskOwner.m_20275_((double)this.targetPos.m_123341_() + 0.5, this.targetPos.m_7494_().m_123342_(), (double)this.targetPos.m_123343_() + 0.5) < 1.0) {
                this.taskOwner.m_21573_().m_26573_();
                this.counter = this.taskOwner.m_21187_().nextInt(20) + 30;
            }
            if (this.counter > 0) {
                --this.counter;
                if (this.counter == 0) {
                    this.taskOwner.setIsEating(true);
                    this.eatingCounter = this.taskOwner.m_21187_().nextInt(40) + 20;
                    this.taskOwner.m_21573_().m_26573_();
                    Level worldIn = this.taskOwner.m_183503_();
                    this.taskOwner.m_21563_().m_24946_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_());
                    if (worldIn.m_8055_(this.targetPos).m_204336_(ModTags.ModBlockTags.GRAZEABLE_ALGAE) && ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)this.taskOwner) && ((Boolean)ConfigGamerules.grazerGriefing.get()).booleanValue()) {
                        worldIn.m_46961_(this.targetPos, false);
                    }
                    this.taskOwner.m_8035_();
                    this.taskOwner.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                    this.taskComplete = true;
                }
            }
        }
    }
}

