/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.AngrySleeperTarget;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModLootTables;
import untamedwilds.init.ModSounds;
import untamedwilds.util.EntityUtils;

public class EntityBoar
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> WARTHOG = SynchedEntityData.m_135353_(EntityBoar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private BlockPos lastDugPos = null;
    public static Animation WORK_DIG;
    public static Animation ATTACK;
    public static Animation TALK;

    public EntityBoar(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_19804_.m_135372_(WARTHOG, (Object)false);
        this.turn_speed = 0.6f;
        WORK_DIG = Animation.create((int)48);
        ATTACK = Animation.create((int)18);
        TALK = Animation.create((int)20);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new GoHogWildGoal(this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new FindItemsGoal(this, 12, 100, false, true));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityBoar.getEcoLevel(input) > EntityBoar.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 20, true));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new AngrySleeperTarget<LivingEntity>(this, LivingEntity.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.8).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed()) {
            return !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this) && this.getHunger() >= 80;
        }
        return false;
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SmartFollowOwnerGoal(this, 2.3, 12.0f, 3.0f));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            this.setAngry(this.m_5448_() != null);
            if (this.f_19853_.m_46467_() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.m_5634_(1.0f);
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_() && this.getCommandInt() == 0) {
                int i = this.f_19796_.nextInt(3000);
                if (i == 13 && !this.m_20069_() && this.isNotMoving() && this.canMove()) {
                    this.setSitting(true);
                }
                if (i == 14 && this.isSitting()) {
                    this.setSitting(false);
                }
                if (i > 2960 && i < 2979 && !this.m_20069_() && !this.m_6162_()) {
                    this.setAnimation(TALK);
                }
                if (i > 2980 && !this.m_20069_() && this.getHunger() < 60 && this.canMove() && this.getAnimation() == NO_ANIMATION && (this.lastDugPos == null || this.m_20275_(this.lastDugPos.m_123341_(), this.m_20186_(), this.lastDugPos.m_123343_()) > 50.0) && this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_204336_(BlockTags.f_144283_)) {
                    this.setAnimation(WORK_DIG);
                    this.addHunger(20);
                    this.lastDugPos = this.m_142538_();
                }
            }
            if (this.getAnimation() == WORK_DIG && this.getAnimationTick() % 8 == 0) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.f_19853_.m_8055_(this.m_142538_().m_7495_())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.0, 0.0, 0.0, (double)0.15f);
                this.m_5496_(SoundEvents.f_12406_, 0.8f, 0.6f);
                if (this.getAnimationTick() == 64 && this.f_19796_.nextInt(5) == 0) {
                    List<ItemStack> result = EntityUtils.getItemFromLootTable(ModLootTables.LOOT_DIGGING, this.f_19853_);
                    for (ItemStack itemstack : result) {
                        this.m_19983_(itemstack);
                    }
                }
            }
            if (this.getAnimation() == TALK && this.getAnimationTick() == 1 && this.m_7515_() != null) {
                this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
            }
            if (this.m_5448_() != null && this.f_19797_ % 120 == 0) {
                this.m_5496_(this.getThreatSound(), this.m_6121_(), this.m_6100_());
            }
            if (this.getAnimation() != NO_ANIMATION && this.getAnimation() == ATTACK && this.getAnimationTick() == 8 && this.f_19796_.nextInt(3) == 0) {
                this.m_5496_(ModSounds.ENTITY_BOAR_SQUEAL, this.m_6121_(), this.m_6100_());
            }
        }
        super.m_8107_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_()) {
            if (!this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
                this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
                if (this.m_21187_().nextInt(3) == 0) {
                    this.m_21828_(player);
                    EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
                } else {
                    EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
                }
            }
            if (!this.m_21824_() && !this.m_6162_() && itemstack.m_41619_()) {
                this.setSitting(false);
                this.setSleeping(false);
                if (!this.f_19853_.f_46443_) {
                    player.m_146922_(this.m_146908_());
                    player.m_146926_(this.m_146909_());
                    player.m_20329_((Entity)this);
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            this.setAnimation(ATTACK);
            this.setAnimationTick(0);
        }
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        this.performRetaliation(damageSource, this.m_21223_(), amount, true);
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, WORK_DIG, ATTACK, TALK};
    }

    @Override
    public Animation getAnimationEat() {
        return WORK_DIG;
    }

    @Nullable
    public EntityBoar getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityBoar((EntityType<? extends ComplexMob>)((EntityType)ModEntity.BOAR.get()), this.f_19853_));
    }

    @Override
    public void updateAttributes() {
        this.setWarthog(EntityBoar.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "isWarthog") == 1);
    }

    public boolean isWarthog() {
        return (Boolean)this.f_19804_.m_135370_(WARTHOG);
    }

    private void setWarthog(boolean warthog) {
        this.f_19804_.m_135381_(WARTHOG, (Object)warthog);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isWarthog", this.isWarthog());
        if (this.lastDugPos != null) {
            compound.m_128405_("DugPosX", this.lastDugPos.m_123341_());
            compound.m_128405_("DugPosZ", this.lastDugPos.m_123343_());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setWarthog(compound.m_128471_("isWarthog"));
        if (compound.m_128441_("LastDugPos")) {
            this.lastDugPos = new BlockPos(compound.m_128451_("DugPosX"), 0, compound.m_128451_("DugPosZ"));
        }
    }

    public static class GoHogWildGoal
    extends Goal {
        private final EntityBoar boar;
        private final double speedModifier;
        private double posX;
        private double posY;
        private double posZ;

        public GoHogWildGoal(EntityBoar p_25890_, double p_25891_) {
            this.boar = p_25890_;
            this.speedModifier = p_25891_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.boar.m_21824_() && this.boar.m_20160_()) {
                Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.boar, (int)5, (int)4);
                if (vec3 == null) {
                    return false;
                }
                this.posX = vec3.f_82479_;
                this.posY = vec3.f_82480_;
                this.posZ = vec3.f_82481_;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.boar.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        }

        public boolean m_8045_() {
            return !this.boar.m_21824_() && !this.boar.m_21573_().m_26571_() && this.boar.m_20160_();
        }

        public void m_8037_() {
            if (this.boar.m_21187_().nextInt(this.m_183277_(50)) < 3) {
                this.boar.setAnimation(ATTACK);
                this.boar.m_5496_(ModSounds.ENTITY_BOAR_SQUEAL, this.boar.m_6121_(), this.boar.m_6100_());
            }
            if (!this.boar.m_21824_() && this.boar.m_21187_().nextInt(this.m_183277_(50)) == 0) {
                Entity entity = (Entity)this.boar.m_20197_().get(0);
                if (entity == null) {
                    return;
                }
                this.boar.m_20153_();
                this.boar.m_6710_((LivingEntity)entity);
                this.boar.f_19853_.m_7605_((Entity)this.boar, (byte)6);
            }
        }
    }
}

