/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.MeleeAttackCharger;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.entity.ai.unique.BisonTerritorialityFight;
import untamedwilds.init.ModEntity;
import untamedwilds.init.ModSounds;
import untamedwilds.util.EntityUtils;

public class EntityBison
extends ComplexMobTerrestrial
implements INewSkins,
ISpecies,
IPackEntity {
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(EntityBison.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation ATTACK_THREATEN;
    public static Animation ATTACK_GORE;

    public EntityBison(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        ATTACK_THREATEN = Animation.create((int)50);
        ATTACK_GORE = Animation.create((int)14);
        this.f_19793_ = 1.0f;
        this.turn_speed = 0.2f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING, (Object)false);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new RodeoGoal(this, 1.8f));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackCharger(this, 1.4f, 3));
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.6, false));
        this.f_21345_.m_25352_(3, (Goal)new SmartMateGoal(this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new GrazeGoal(this, 10));
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new BisonTerritorialityFight(this, 1.4f));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 0, true));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new ProtectChildrenTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntityBison) && EntityBison.getEcoLevel(input) > EntityBison.getEcoLevel((LivingEntity)this)));
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SmartFollowOwnerGoal(this, 1.3, 12.0f, 3.0f));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.f_146733_ == 0) {
            return this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            int i;
            if (this.herd == null) {
                IPackEntity.initPack(this);
            } else {
                this.herd.tick();
            }
            if (this.f_19853_.m_46467_() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.m_5634_(1.0f);
                }
            }
            if ((i = this.f_19796_.nextInt(3000)) == 13 && !this.m_20069_() && this.m_5448_() == null && this.isNotMoving() && this.canMove() && this.getAnimation() == NO_ANIMATION) {
                this.setSitting(true);
            }
            if (i == 14 && this.isSitting()) {
                this.setSitting(false);
            }
            this.setAngry(this.m_5448_() != null);
        } else if (this.getAnimation() == ATTACK_THREATEN) {
            this.m_6858_(this.getAnimationTick() % 18 < 6);
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
            if (!this.isCharging()) {
                this.m_5496_(SoundEvents.f_12594_, 1.0f, this.m_6100_());
                HoglinBase.m_34642_((LivingEntity)this, (LivingEntity)((LivingEntity)entityIn));
            }
        }
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        this.performRetaliation(damageSource, this.m_21223_(), amount, true);
        return super.m_6469_(damageSource, amount);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12361_, 0.15f, 1.0f);
    }

    private Animation chooseAttackAnimation() {
        return ATTACK_GORE;
    }

    @Nullable
    public EntityBison getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityBison((EntityType<? extends ComplexMob>)((EntityType)ModEntity.BISON.get()), this.f_19853_));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_()) {
            if (!this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
                this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
                if (this.m_21187_().nextInt(3) == 0) {
                    this.m_21828_(player);
                    EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
                } else {
                    EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
                }
            }
            if (!this.m_21824_() && !this.m_6162_() && itemstack.m_41619_()) {
                this.setSitting(false);
                this.setSleeping(false);
                if (!this.f_19853_.f_46443_) {
                    player.m_146922_(this.m_146908_());
                    player.m_146926_(this.m_146909_());
                    player.m_20329_((Entity)this);
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean bool) {
        this.f_19804_.m_135381_(CHARGING, (Object)bool);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_THREATEN, ATTACK_GORE};
    }

    @Override
    public Animation getAnimationEat() {
        return NO_ANIMATION;
    }

    public static class RodeoGoal
    extends Goal {
        private final EntityBison bison;
        private final double speedModifier;
        private double posX;
        private double posY;
        private double posZ;

        public RodeoGoal(EntityBison p_25890_, double p_25891_) {
            this.bison = p_25890_;
            this.speedModifier = p_25891_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.bison.m_21824_() && this.bison.m_20160_()) {
                Vec3 vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.bison, (int)5, (int)4);
                if (vec3 == null) {
                    return false;
                }
                this.posX = vec3.f_82479_;
                this.posY = vec3.f_82480_;
                this.posZ = vec3.f_82481_;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.bison.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        }

        public boolean m_8045_() {
            return !this.bison.m_21824_() && !this.bison.m_21573_().m_26571_() && this.bison.m_20160_();
        }

        public void m_8037_() {
            if (this.bison.m_21187_().nextInt(this.m_183277_(50)) < 3) {
                this.bison.setAnimation(ATTACK_GORE);
                this.bison.m_5496_(ModSounds.ENTITY_BISON_AMBIENT, this.bison.m_6121_(), this.bison.m_6100_());
            }
            if (!this.bison.m_21824_() && this.bison.m_21187_().nextInt(this.m_183277_(50)) == 0) {
                Entity entity = (Entity)this.bison.m_20197_().get(0);
                if (entity == null) {
                    return;
                }
                this.bison.m_20153_();
                this.bison.m_6710_((LivingEntity)entity);
                this.bison.f_19853_.m_7605_((Entity)this.bison, (byte)6);
            }
        }
    }
}

