/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.fish;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import oshi.util.tuples.Pair;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.unique.CatfishGarbageBinGoal;
import untamedwilds.util.EntityUtils;

public class EntityCatfish
extends ComplexMobAquatic
implements ISpecies,
INewSkins {
    public Pair<Float, Float> whisker_offset = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    private float whisker_y = 0.0f;
    private float whisker_z = 0.0f;

    public EntityCatfish(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.3).m_22268_(Attributes.f_22279_, 0.65).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 8.0);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new CatfishGarbageBinGoal(this, 6, 100));
        this.f_21345_.m_25352_(4, (Goal)new ComplexMobAquatic.SwimGoal(this, 3));
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_20069_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.003, 0.0));
            }
            if (this.f_19797_ % 1000 == 0 && this.wantsToBreed() && !this.isMale()) {
                this.breed();
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
        }
        if (this.f_19797_ % 120 < 11) {
            if (this.f_19797_ % 120 == 1) {
                this.whisker_y = 0.8f - this.f_19796_.nextFloat() * 1.6f;
                this.whisker_z = 0.4f - this.f_19796_.nextFloat() * 0.8f;
            }
            this.whisker_offset = new Pair((Object)Float.valueOf(Mth.m_14179_((float)0.1f, (float)((Float)this.whisker_offset.getA()).floatValue(), (float)this.whisker_y)), (Object)Float.valueOf(Mth.m_14179_((float)0.1f, (float)((Float)this.whisker_offset.getB()).floatValue(), (float)this.whisker_z)));
        }
        super.m_8107_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && itemstack.m_41720_().equals(Items.f_42447_) && this.m_6084_()) {
            EntityUtils.mutateEntityIntoItem((LivingEntity)this, player, hand, "bucket_catfish", itemstack);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntityCatfish.class, this.m_142469_().m_82377_(12.0, 8.0, 12.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntityCatfish)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_catfish", this.getOffspring());
        return null;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11760_;
    }
}

