/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.bird;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INestingMob;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.FindItemsGoal;
import untamedwilds.entity.ai.FollowParentGoal;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.LayEggsOnNestGoal;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.AngrySleeperTarget;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartHurtByTargetGoal;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;
import untamedwilds.util.EntityUtils;

public class EntityTerrorBird
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INeedsPostUpdate,
IPackEntity,
INestingMob {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(EntityTerrorBird.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation ATTACK_PECK;
    public static Animation ATTACK_KICK;
    public static Animation ANIMATION_EAT;
    public static Animation IDLE_TALK;
    public static Animation IDLE_GRAZE;
    public int aggroProgress;

    public EntityTerrorBird(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        IDLE_TALK = Animation.create((int)20);
        IDLE_GRAZE = Animation.create((int)48);
        ATTACK_PECK = Animation.create((int)40);
        ATTACK_KICK = Animation.create((int)40);
        this.turn_speed = 0.1f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new FindItemsGoal(this, 12, true));
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 2.3, false, 1.0f, false, true));
        this.f_21345_.m_25352_(3, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntityTerrorBird.getEcoLevel(input) > EntityTerrorBird.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new LayEggsOnNestGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GrazeGoal(this, 10){

            @Override
            public boolean m_8036_() {
                EntityTerrorBird bird;
                ComplexMobTerrestrial complexMobTerrestrial = this.taskOwner;
                if (complexMobTerrestrial instanceof EntityTerrorBird && !(bird = (EntityTerrorBird)complexMobTerrestrial).isGrazer()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal(this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new SmartHurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AngrySleeperTarget<LivingEntity>(this, LivingEntity.class, true));
        this.f_21346_.m_25352_(3, new ProtectChildrenTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntityTerrorBird)));
        this.f_21346_.m_25352_(4, (Goal)new HuntMobTarget<LivingEntity>((ComplexMob)this, LivingEntity.class, true, 30, false, input -> EntityTerrorBird.getEcoLevel(input) < EntityTerrorBird.getEcoLevel((LivingEntity)this)){

            @Override
            public boolean m_8036_() {
                EntityTerrorBird bird;
                Mob mob = this.f_26135_;
                if (mob instanceof EntityTerrorBird && (bird = (EntityTerrorBird)mob).isGrazer()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 0.8).m_22268_(Attributes.f_22279_, 0.16).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22284_, 0.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this) && this.getHunger() >= 80) {
            if (((Boolean)ConfigGamerules.hardcoreBreeding.get()).booleanValue()) {
                List list = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82377_(6.0, 4.0, 6.0));
                return list.size() < 3;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public EntityTerrorBird getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return Mth.m_14167_((float)((distance * 0.5f - 3.0f) * damageMultiplier));
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            if (this.herd == null && EntityUtils.getPackSize(this.m_6095_(), this.getVariant()) > 1) {
                IPackEntity.initPack(this);
            } else if (EntityUtils.getPackSize(this.m_6095_(), this.getVariant()) > 1) {
                this.herd.tick();
            }
            if (this.f_19853_.m_46467_() % 1000L == 0L) {
                this.addHunger(-3);
                if (!this.isStarving()) {
                    this.m_5634_(2.0f);
                }
            }
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_() && this.getCommandInt() == 0) {
                int i = this.f_19796_.nextInt(3000);
                if (i == 0 && !this.m_20069_() && this.isNotMoving() && this.canMove() && this.isActive()) {
                    this.m_21573_().m_26573_();
                    this.setSitting(true);
                }
                if ((i == 1 || this.m_20069_()) && this.isSitting() && this.getCommandInt() < 2) {
                    this.setSitting(false);
                }
                if (i > 2980 && !this.m_20069_() && !this.m_6162_()) {
                    this.setAnimation(IDLE_TALK);
                }
            }
            if (this.getAnimation() == ATTACK_KICK && this.getAnimationTick() == 4) {
                this.m_21566_().m_24988_(2.0f, 0.0f);
                this.m_21569_().m_24901_();
            }
            this.setAngry(this.m_5448_() != null);
        }
        if (this.getAnimation() == ANIMATION_EAT && (this.getAnimationTick() == 10 || this.getAnimationTick() == 20 || this.getAnimationTick() == 30)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
        }
        if (this.getAnimation() == ATTACK_KICK && this.getAnimationTick() == 10) {
            this.m_5496_(SoundEvents.f_12317_, 1.5f, 0.8f);
        }
        if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1 && this.m_7515_() != null) {
            this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
        }
        if (this.f_19853_.f_46443_ && this.isAngry() && this.aggroProgress < 40) {
            ++this.aggroProgress;
        } else if (this.f_19853_.f_46443_ && !this.isAngry() && this.aggroProgress > 0) {
            --this.aggroProgress;
        }
        super.m_8107_();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SmartFollowOwnerGoal(this, 2.3, 12.0f, 3.0f));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_() && !this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
            if (this.m_21187_().nextInt(3) == 0) {
                this.m_21828_(player);
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation(entityIn);
            this.setAnimation(anim);
            this.setAnimationTick(0);
        }
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        TamableAnimal tamable;
        Entity entity;
        float f = this.m_21223_();
        if (!this.f_19853_.f_46443_ && !this.m_21525_() && this.m_5448_() == damageSource.m_7639_() && amount < f && (damageSource.m_7639_() != null || damageSource.m_7640_() != null) && damageSource.m_7639_() instanceof LivingEntity && (entity = damageSource.m_7639_()) instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_142480_() != null && this.m_142582_(damageSource.m_7639_()) && !damageSource.m_7639_().m_20147_() && this.getAnimation() == NO_ANIMATION) {
            this.m_7327_(damageSource.m_7639_());
        }
        return super.m_6469_(damageSource, amount);
    }

    private Animation chooseAttackAnimation(Entity target) {
        return this.f_19796_.nextBoolean() ? ATTACK_KICK : ATTACK_PECK;
    }

    @Override
    public Animation getAnimationEat() {
        return IDLE_GRAZE;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ATTACK_KICK, ATTACK_PECK, IDLE_TALK, IDLE_GRAZE};
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.9f;
    }

    public boolean isGrazer() {
        return EntityTerrorBird.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "isGrazer") == 1;
    }

    @Override
    public void updateAttributes() {
        this.m_21051_(Attributes.f_22281_).m_22100_((double)EntityTerrorBird.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getAttack().floatValue());
        this.m_21051_(Attributes.f_22276_).m_22100_((double)EntityTerrorBird.getEntityData(this.m_6095_()).getSpeciesData().get(this.getVariant()).getHealth().floatValue());
        this.m_21153_(this.m_21233_());
    }

    @Override
    public boolean wantsToLayEggs() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    @Override
    public void setEggStatus(boolean status) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)status);
    }

    @Override
    public Block getNestType() {
        return (Block)ModBlock.NEST_REPTILE.get();
    }

    @Override
    public boolean isValidNestBlock(BlockPos pos) {
        return this.f_19853_.m_46859_(pos) && this.f_19853_.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.VALID_REPTILE_NEST) && this.getNestType().m_49966_().m_60710_((LevelReader)this.f_19853_, pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("has_egg", this.wantsToLayEggs());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEggStatus(compound.m_128471_("has_egg"));
    }
}

