/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.relict.EntitySpitter;

public class SpitterAttackGoal
extends Goal {
    protected final EntitySpitter attacker;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private final float extraReach;
    private long field_220720_k;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;

    public SpitterAttackGoal(EntitySpitter entityIn, double speedIn, boolean useLongMemory, float reach) {
        this.attacker = entityIn;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.extraReach = reach;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.attacker.f_19853_.m_46467_();
        if (i - this.field_220720_k < 20L) {
            return false;
        }
        this.field_220720_k = i;
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null || this.attacker.m_20146_() < 40 && !this.attacker.m_6040_() || !livingentity.m_6084_()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.m_21573_().m_26571_();
        }
        if (!this.attacker.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        if (!this.attacker.m_6162_()) {
            this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        }
        this.attacker.m_21561_(true);
        this.delayCounter = 0;
        List list = this.attacker.f_19853_.m_45976_(EntitySpitter.class, this.attacker.m_142469_().m_82377_(12.0, 8.0, 12.0));
        for (EntitySpitter entityanimal1 : list) {
            if (entityanimal1.getVariant() != this.attacker.getVariant()) continue;
            entityanimal1.m_6710_(this.attacker.m_5448_());
        }
    }

    public void m_8041_() {
        this.attacker.m_6710_(null);
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        this.attacker.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)livingentity.m_142538_()));
        double d0 = this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_142469_().f_82289_, livingentity.m_20189_());
        --this.delayCounter;
        if (this.attacker.m_20069_() && this.attacker.f_19797_ % 12 == 0 && livingentity.m_142469_().f_82289_ - 2.0 > this.attacker.m_20186_()) {
            this.attacker.m_21569_().m_24901_();
        }
        if (this.attacker.getAnimation() == EntitySpitter.NO_ANIMATION && this.attacker.m_21574_().m_148306_((Entity)livingentity) && this.attacker.m_21187_().nextInt(this.attacker.m_6162_() ? 80 : 200) == 0 && d0 > 12.0) {
            this.attacker.m_21563_().m_148051_((Entity)livingentity);
            this.attacker.setAnimation(EntitySpitter.ATTACK_SPIT);
        } else if (!this.attacker.m_6162_() && (this.longMemory || this.attacker.m_21574_().m_148306_((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_21187_().nextFloat() < 0.05f)) {
            this.targetX = livingentity.m_20185_();
            this.targetY = livingentity.m_142469_().f_82289_;
            this.targetZ = livingentity.m_20189_();
            this.delayCounter = 4 + this.attacker.m_21187_().nextInt(7);
            Objects.requireNonNull(this);
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.m_21573_().m_5624_((Entity)livingentity, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        double d0 = this.getAttackReachSqr(enemy);
        if (this.attacker.m_142582_((Entity)enemy) && distToEnemySqr <= d0 && (this.attackTick <= 0 || this.attackTick <= 10 && this.attacker.getAnimation() == IAnimatedEntity.NO_ANIMATION)) {
            this.attackTick = 20;
            this.attacker.m_7327_((Entity)enemy);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_() + this.extraReach;
    }
}

