/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import java.util.EnumSet;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ai.unique.ButterflyFlutterGoal;
import untamedwilds.entity.arthropod.EntityButterfly;
import untamedwilds.util.EntityUtils;

public class ButterflyFlutterTowardsGoal
extends ButterflyFlutterGoal {
    private final Predicate<BlockState> VALID_POLLINATION_BLOCKS = p_28074_ -> {
        if (p_28074_.m_204336_(BlockTags.f_13041_)) {
            if (p_28074_.m_60713_(Blocks.f_50355_)) {
                return p_28074_.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER;
            }
            return true;
        }
        return false;
    };
    private int successfulPollinatingTicks;
    private int lastSoundPlayedTick;
    private boolean pollinating;
    @Nullable
    private Vec3 hoverPos;
    private int pollinatingTicks;
    private BlockPos blockPos;

    public ButterflyFlutterTowardsGoal(EntityButterfly entityIn, float speed) {
        super(entityIn, speed);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (this.taskOwner.isResting() || this.taskOwner.flight_counter != 0 || this.taskOwner.m_21187_().nextInt(400) != 0) {
            return false;
        }
        if (this.taskOwner.f_19853_.m_46471_()) {
            return false;
        }
        Optional<BlockPos> optional = this.findNearbyFlower();
        if (optional.isPresent()) {
            this.blockPos = optional.get();
            this.taskOwner.m_21573_().m_26519_((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_() + 0.5, (double)this.blockPos.m_123343_() + 0.5, (double)1.2f);
            return true;
        }
        return false;
    }

    @Override
    public boolean m_8045_() {
        if (this.taskOwner.m_21573_().m_26571_() || this.taskOwner.isNotMoving() || this.taskOwner.isResting()) {
            return false;
        }
        if (!this.pollinating) {
            return false;
        }
        if (this.taskOwner.f_19853_.m_46471_()) {
            return false;
        }
        if (this.hasPollinatedLongEnough()) {
            return this.taskOwner.m_21187_().nextFloat() < 0.2f;
        }
        if (this.taskOwner.f_19797_ % 20 == 0 && !this.isFlowerValid(this.blockPos)) {
            this.blockPos = null;
            return false;
        }
        return true;
    }

    private boolean hasPollinatedLongEnough() {
        return this.successfulPollinatingTicks > 400;
    }

    @Override
    public void m_8056_() {
        this.successfulPollinatingTicks = 0;
        this.pollinatingTicks = 0;
        this.lastSoundPlayedTick = 0;
        this.pollinating = true;
    }

    public void m_8041_() {
        if (this.hasPollinatedLongEnough()) {
            this.taskOwner.setResting(true);
        }
        this.taskOwner.setResting(true);
        this.pollinating = false;
        EntityUtils.spawnParticlesOnEntity(this.taskOwner.m_183503_(), (LivingEntity)this.taskOwner, ParticleTypes.f_123782_, 3, 1);
        this.taskOwner.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    boolean isFlowerValid(BlockPos p_27897_) {
        return this.taskOwner.m_183503_().m_46749_(p_27897_) && this.taskOwner.m_183503_().m_8055_(p_27897_).m_204336_(BlockTags.f_13041_);
    }

    @Override
    public void m_8037_() {
        ++this.pollinatingTicks;
        if (this.pollinatingTicks > 300) {
            this.blockPos = null;
        } else {
            Vec3 vec3 = this.taskOwner.m_20318_(0.0f);
            if (this.blockPos != null) {
                vec3 = Vec3.m_82539_((Vec3i)this.blockPos).m_82520_(0.0, (double)0.6f, 0.0);
            }
            if (vec3.m_82554_(this.taskOwner.m_20182_()) > 1.0) {
                this.hoverPos = vec3;
                this.setWantedPos();
            } else {
                if (this.hoverPos == null) {
                    this.hoverPos = vec3;
                }
                boolean flag = this.taskOwner.m_20182_().m_82554_(this.hoverPos) <= 0.1;
                boolean flag1 = true;
                if (!flag && this.pollinatingTicks > 600) {
                    this.blockPos = null;
                } else {
                    if (flag) {
                        boolean flag2;
                        boolean bl = flag2 = this.taskOwner.m_21187_().nextInt(25) == 0;
                        if (flag2) {
                            this.hoverPos = new Vec3(vec3.m_7096_() + (double)this.getOffset(), vec3.m_7098_(), vec3.m_7094_() + (double)this.getOffset());
                            this.taskOwner.m_21573_().m_26573_();
                        } else {
                            flag1 = false;
                        }
                        this.taskOwner.m_21563_().m_24946_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                    }
                    if (flag1) {
                        this.setWantedPos();
                    }
                    ++this.successfulPollinatingTicks;
                    if (this.taskOwner.m_21187_().nextFloat() < 0.05f && this.successfulPollinatingTicks > this.lastSoundPlayedTick + 60) {
                        this.lastSoundPlayedTick = this.successfulPollinatingTicks;
                        this.taskOwner.m_5496_(SoundEvents.f_11693_, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private void setWantedPos() {
        this.taskOwner.m_21566_().m_6849_(this.hoverPos.m_7096_(), this.hoverPos.m_7098_(), this.hoverPos.m_7094_(), (double)0.35f);
    }

    private float getOffset() {
        return (this.taskOwner.m_21187_().nextFloat() * 2.0f - 1.0f) * 0.33333334f;
    }

    private Optional<BlockPos> findNearbyFlower() {
        return this.findNearestBlock(this.VALID_POLLINATION_BLOCKS, 5.0);
    }

    private Optional<BlockPos> findNearestBlock(Predicate<BlockState> p_28076_, double p_28077_) {
        BlockPos blockpos = this.taskOwner.m_142538_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = 0;
        while ((double)i <= p_28077_) {
            int j = 0;
            while ((double)j < p_28077_) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, k, i - 1, l);
                        if (blockpos.m_123314_((Vec3i)blockpos$mutableblockpos, p_28077_) && p_28076_.test(this.taskOwner.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos))) {
                            return Optional.of(blockpos$mutableblockpos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return Optional.empty();
    }
}

