/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;
import untamedwilds.entity.mammal.EntityBison;
import untamedwilds.util.EntityUtils;

public class BisonTerritorialityFight
extends Goal {
    private final EntityBison taskOwner;
    private EntityBison targetAnimal;
    private final double moveSpeed;
    private int charge;
    private boolean isDone = false;
    private Goal slaveGoal;

    public BisonTerritorialityFight(EntityBison entityIn, double speedIn) {
        this.taskOwner = entityIn;
        this.moveSpeed = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!EntityUtils.hasFullHealth((LivingEntity)this.taskOwner) || this.taskOwner.m_6162_() || !this.taskOwner.canMove() || !this.taskOwner.isMale()) {
            return false;
        }
        if (this.taskOwner.m_21187_().nextInt(400) != 0) {
            return false;
        }
        List list = this.taskOwner.f_19853_.m_45976_(this.taskOwner.getClass(), this.taskOwner.m_142469_().m_82377_(8.0, 4.0, 8.0));
        EntityBison target_animal = null;
        double d0 = Double.MAX_VALUE;
        for (EntityBison potential_targets : list) {
            double d1;
            if (potential_targets.equals(this.taskOwner) || potential_targets.m_6162_() || potential_targets.getVariant() != this.taskOwner.getVariant() || !potential_targets.isMale() || !potential_targets.canMove() || !((d1 = this.taskOwner.m_20280_((Entity)potential_targets)) <= d0)) continue;
            d0 = d1;
            target_animal = potential_targets;
        }
        if (target_animal == null) {
            return false;
        }
        this.targetAnimal = target_animal;
        this.isDone = false;
        this.slaveGoal = new TerritorialFightingGoal_slave(this.targetAnimal, 1.4f, this.taskOwner);
        return true;
    }

    public void m_8056_() {
        EntityUtils.spawnParticlesOnEntity(this.taskOwner.f_19853_, (LivingEntity)this.taskOwner, ParticleTypes.f_123792_, 10, 1);
        EntityUtils.spawnParticlesOnEntity(this.targetAnimal.f_19853_, (LivingEntity)this.targetAnimal, ParticleTypes.f_123792_, 10, 1);
        this.charge = 40;
        this.targetAnimal.f_21345_.m_25352_(1, this.slaveGoal);
        this.taskOwner.m_21563_().m_148051_((Entity)this.targetAnimal);
        this.taskOwner.setAnimation(EntityBison.ATTACK_THREATEN);
        this.taskOwner.m_6858_(true);
        if (!this.targetAnimal.canMove()) {
            this.targetAnimal.setSitting(false);
            this.targetAnimal.setSleeping(false);
        }
    }

    public boolean m_8045_() {
        return !this.isDone && EntityUtils.hasFullHealth((LivingEntity)this.taskOwner);
    }

    public void m_8037_() {
        this.taskOwner.m_21563_().m_148051_((Entity)this.targetAnimal);
        if (this.charge > 0) {
            if (--this.charge == 0) {
                this.taskOwner.m_21573_().m_5624_((Entity)this.targetAnimal, this.moveSpeed * (double)1.2f);
            }
        } else {
            AABB offset_box = this.taskOwner.m_142469_().m_82386_(Math.cos(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2);
            List entitiesHit = this.taskOwner.m_183503_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.taskOwner, offset_box);
            for (LivingEntity entityHit : entitiesHit) {
                if (entityHit.equals((Object)this.taskOwner) || !this.taskOwner.m_142582_((Entity)entityHit) || !entityHit.equals((Object)this.targetAnimal)) continue;
                Random rand = this.taskOwner.m_21187_();
                ServerLevel world = (ServerLevel)this.taskOwner.m_183503_();
                world.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)rand.nextFloat((float)offset_box.f_82288_, (float)offset_box.f_82291_), (double)rand.nextFloat((float)offset_box.f_82289_, (float)offset_box.f_82292_), (double)rand.nextFloat((float)offset_box.f_82290_, (float)offset_box.f_82293_), 10, 0.0, 0.0, 0.0, 0.05);
                this.targetAnimal.m_6469_(DamageSource.f_19318_, 2.0f);
                this.isDone = true;
            }
        }
    }

    public void m_8041_() {
        this.targetAnimal.f_21345_.m_25363_(this.slaveGoal);
        this.charge = 0;
        this.taskOwner.m_6858_(false);
        this.taskOwner.f_19853_.m_6263_(null, this.taskOwner.m_20185_(), this.taskOwner.m_20186_(), this.taskOwner.m_20189_(), SoundEvents.f_144170_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.taskOwner.m_20256_(this.taskOwner.m_20184_().m_82490_((double)-0.15f));
    }

    public static class TerritorialFightingGoal_slave
    extends Goal {
        private final EntityBison taskOwner;
        private final EntityBison targetAnimal;
        private final double moveSpeed;
        private int charge;
        private boolean isDone = false;

        public TerritorialFightingGoal_slave(EntityBison entityIn, double speedIn, EntityBison targetAnimal) {
            this.taskOwner = entityIn;
            this.moveSpeed = speedIn;
            this.targetAnimal = targetAnimal;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return !this.taskOwner.m_6162_() && this.taskOwner.canMove() && this.taskOwner.isMale();
        }

        public void m_8056_() {
            this.charge = 40;
            this.isDone = false;
            this.taskOwner.m_21563_().m_148051_((Entity)this.targetAnimal);
            this.taskOwner.setAnimation(EntityBison.ATTACK_THREATEN);
            this.taskOwner.m_6858_(true);
            if (!this.targetAnimal.canMove()) {
                this.targetAnimal.setSitting(false);
                this.targetAnimal.setSleeping(false);
            }
        }

        public boolean m_8045_() {
            return !this.isDone;
        }

        public void m_8037_() {
            this.taskOwner.m_21563_().m_148051_((Entity)this.targetAnimal);
            if (this.charge > 0) {
                if (--this.charge == 0) {
                    this.taskOwner.m_21573_().m_5624_((Entity)this.targetAnimal, this.moveSpeed * (double)1.2f);
                }
            } else {
                AABB offset_box = this.taskOwner.m_142469_().m_82386_(Math.cos(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2);
                List entitiesHit = this.taskOwner.m_183503_().m_45971_(LivingEntity.class, TargetingConditions.m_148352_(), (LivingEntity)this.taskOwner, offset_box);
                for (LivingEntity entityHit : entitiesHit) {
                    if (entityHit.equals((Object)this.taskOwner) || !this.taskOwner.m_142582_((Entity)entityHit) || !entityHit.equals((Object)this.targetAnimal)) continue;
                    Random rand = this.taskOwner.m_21187_();
                    ServerLevel world = (ServerLevel)this.taskOwner.m_183503_();
                    world.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)rand.nextFloat((float)offset_box.f_82288_, (float)offset_box.f_82291_), (double)rand.nextFloat((float)offset_box.f_82289_, (float)offset_box.f_82292_), (double)rand.nextFloat((float)offset_box.f_82290_, (float)offset_box.f_82293_), 10, 0.0, 0.0, 0.0, 0.05);
                    this.targetAnimal.m_6469_(DamageSource.m_19370_(null), 2.0f);
                    this.isDone = true;
                }
            }
        }

        public void m_8041_() {
            this.charge = 0;
            this.taskOwner.m_6858_(false);
            this.taskOwner.m_20256_(this.taskOwner.m_20184_().m_82490_((double)-0.15f));
        }
    }
}

