/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;

public class DontThreadOnMeTarget<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    protected Predicate<T> targetEntitySelector;
    private int runningTicks;

    public DontThreadOnMeTarget(Mob entityIn, Class<T> targetClassIn, boolean checkSight) {
        this(entityIn, targetClassIn, checkSight, false);
    }

    public DontThreadOnMeTarget(Mob entityIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn) {
        super(entityIn, checkSight, nearbyOnlyIn);
        this.targetClass = targetClassIn;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetEntitySelector = entity -> this.isValidTarget((LivingEntity)entity, null);
    }

    protected boolean isValidTarget(LivingEntity entity, @Nullable Predicate<LivingEntity> predicate) {
        Mob mob;
        if (entity instanceof Creeper || entity.equals((Object)this.f_26135_) || !((Boolean)ConfigGamerules.attackUndead.get()).booleanValue() && entity.m_6336_() == MobType.f_21641_ || predicate != null && !predicate.test(entity)) {
            return false;
        }
        if (this.f_26135_.getClass() == entity.getClass() && (mob = this.f_26135_) instanceof ComplexMob) {
            ComplexMob attacker = (ComplexMob)mob;
            if (entity instanceof ComplexMob) {
                ComplexMob defender = (ComplexMob)entity;
                if (attacker.getVariant() == defender.getVariant()) {
                    return false;
                }
            }
        }
        return entity.m_142469_().m_82381_(this.f_26135_.m_142469_()) && this.m_26150_(entity, TargetingConditions.m_148352_().m_26883_(this.m_7623_()));
    }

    public boolean m_8036_() {
        if (!((Boolean)ConfigGamerules.contactAgression.get()).booleanValue()) {
            return false;
        }
        List list = this.f_26135_.f_19853_.m_6443_(this.targetClass, this.f_26135_.m_142469_().m_82400_(1.0), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        this.f_26137_ = (LivingEntity)list.get(0);
        return true;
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.f_26137_);
        this.runningTicks = 60;
        super.m_8056_();
    }

    public boolean m_8045_() {
        --this.runningTicks;
        if (this.runningTicks < 1) {
            this.f_26135_.m_6710_(null);
            return false;
        }
        return super.m_8045_();
    }
}

