/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMob;

public class SmartPanicGoal
extends Goal {
    public static final int WATER_CHECK_DISTANCE_VERTICAL = 1;
    protected final PathfinderMob taskOwner;
    protected final double speedModifier;
    protected double posX;
    protected double posY;
    protected double posZ;
    protected boolean isRunning;
    protected boolean chainFlee;

    public SmartPanicGoal(PathfinderMob entityIn, double speedIn) {
        this(entityIn, speedIn, false);
    }

    public SmartPanicGoal(PathfinderMob p_25691_, double p_25692_, boolean chainFlee) {
        this.taskOwner = p_25691_;
        this.speedModifier = p_25692_;
        this.chainFlee = chainFlee;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        BlockPos blockpos;
        if (!this.shouldPanic()) {
            return false;
        }
        if (this.taskOwner.m_6060_() && (blockpos = this.lookForWater((BlockGetter)this.taskOwner.f_19853_, (Entity)this.taskOwner, 5)) != null) {
            this.posX = blockpos.m_123341_();
            this.posY = blockpos.m_123342_();
            this.posZ = blockpos.m_123343_();
            return true;
        }
        return this.findRandomPosition();
    }

    protected boolean shouldPanic() {
        return this.taskOwner.m_142581_() != null || this.taskOwner.m_203117_() || this.taskOwner.m_6060_();
    }

    protected boolean findRandomPosition() {
        Vec3 vec3;
        if (this.taskOwner.m_142581_() != null) {
            LivingEntity lastHurt = this.taskOwner.m_142581_();
            vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.taskOwner, (int)5, (int)4, (Vec3)new Vec3(lastHurt.m_20185_(), lastHurt.m_20186_(), lastHurt.m_20189_()));
        } else {
            vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.taskOwner, (int)5, (int)4);
        }
        if (vec3 == null) {
            return false;
        }
        this.posX = vec3.f_82479_;
        this.posY = vec3.f_82480_;
        this.posZ = vec3.f_82481_;
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void m_8056_() {
        Object object;
        if (this.chainFlee && (object = this.taskOwner) instanceof ComplexMob) {
            ComplexMob mob = (ComplexMob)((Object)object);
            if (mob.herd != null) {
                for (ComplexMob creature : mob.herd.creatureList) {
                    if (this.taskOwner.m_142581_() != null && this.taskOwner.m_20270_((Entity)this.taskOwner.m_142581_()) > 10.0f) continue;
                    creature.m_6703_(this.taskOwner.m_142581_());
                }
            }
        }
        this.taskOwner.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        this.isRunning = true;
    }

    public void m_8041_() {
        this.isRunning = false;
    }

    public boolean m_8045_() {
        if (this.taskOwner.m_142581_() != null && this.taskOwner.m_20270_((Entity)this.taskOwner.m_142581_()) > 10.0f) {
            return false;
        }
        return !this.taskOwner.m_21573_().m_26571_();
    }

    @Nullable
    protected BlockPos lookForWater(BlockGetter p_198173_, Entity p_198174_, int p_198175_) {
        BlockPos blockpos = p_198174_.m_142538_();
        return !p_198173_.m_8055_(blockpos).m_60812_(p_198173_, blockpos).m_83281_() ? null : (BlockPos)BlockPos.m_121930_((BlockPos)p_198174_.m_142538_(), (int)p_198175_, (int)1, p_196649_ -> p_198173_.m_6425_(p_196649_).m_205070_(FluidTags.f_13131_)).orElse(null);
    }
}

