/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.util.EntityUtils;

public class SmartMeleeAttackGoal
extends Goal {
    protected final PathfinderMob attacker;
    protected int attackTick;
    private final double speedTowardsTarget;
    private final boolean longMemory;
    private Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private final float extraReach;
    private long field_220720_k;
    private int failedPathFindingPenalty = 0;
    private final boolean canPenalize = false;
    private final boolean doSkirmish;
    private final boolean isJumper;

    public SmartMeleeAttackGoal(PathfinderMob entityIn, double speedIn, boolean useLongMemory) {
        this(entityIn, speedIn, useLongMemory, 0.0f, false, false);
    }

    public SmartMeleeAttackGoal(PathfinderMob entityIn, double speedIn, boolean useLongMemory, float reach) {
        this(entityIn, speedIn, useLongMemory, reach, false, false);
    }

    public SmartMeleeAttackGoal(PathfinderMob entityIn, double speedIn, boolean useLongMemory, float reach, boolean doSkirmish, boolean isJumper) {
        this.attacker = entityIn;
        this.speedTowardsTarget = speedIn;
        this.longMemory = useLongMemory;
        this.extraReach = reach;
        this.doSkirmish = doSkirmish;
        this.isJumper = isJumper;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i;
        block7: {
            block6: {
                if (this.attacker.m_6162_() || this.doSkirmish && !EntityUtils.hasFullHealth((LivingEntity)this.attacker)) break block6;
                PathfinderMob pathfinderMob = this.attacker;
                if (!(pathfinderMob instanceof ComplexMobTerrestrial)) break block7;
                ComplexMobTerrestrial complex = (ComplexMobTerrestrial)pathfinderMob;
                if (complex.forceSleep <= 0) break block7;
            }
            return false;
        }
        if ((i = this.attacker.f_19853_.m_46467_()) - this.field_220720_k < 20L) {
            return false;
        }
        this.field_220720_k = i;
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)livingentity, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (livingentity == null || this.attacker.m_20146_() < 40 && !this.attacker.m_6040_() || !livingentity.m_6084_()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.m_21573_().m_26571_();
        }
        if (!this.attacker.m_21444_(livingentity.m_142538_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, this.speedTowardsTarget);
        this.attacker.m_21561_(true);
        this.delayCounter = 0;
    }

    public void m_8041_() {
        this.attacker.m_6710_(null);
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        this.attacker.m_21563_().m_24964_(Vec3.m_82512_((Vec3i)livingentity.m_142538_()));
        double d0 = this.attacker.m_20275_(livingentity.m_20185_(), livingentity.m_142469_().f_82289_, livingentity.m_20189_());
        --this.delayCounter;
        if (this.attacker.m_20069_() && this.attacker.f_19797_ % 12 == 0 && livingentity.m_142469_().f_82289_ - 2.0 > this.attacker.m_20186_()) {
            this.attacker.m_21569_().m_24901_();
        }
        if ((this.longMemory || this.attacker.m_21574_().m_148306_((Entity)livingentity)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingentity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.m_21187_().nextFloat() < 0.05f)) {
            this.targetX = livingentity.m_20185_();
            this.targetY = livingentity.m_142469_().f_82289_;
            this.targetZ = livingentity.m_20189_();
            this.delayCounter = 4 + this.attacker.m_21187_().nextInt(7);
            Objects.requireNonNull(this);
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (!this.attacker.m_21573_().m_5624_((Entity)livingentity, this.speedTowardsTarget)) {
                this.delayCounter += 15;
            }
        }
        BlockPos forwardNearPos = EntityUtils.getRelativeBlockPos((Entity)this.attacker, 1.2f, 0.0f);
        if (this.isJumper && this.attacker.m_20096_() && this.attacker.m_183503_().m_8055_(forwardNearPos.m_7495_()).m_60795_() && this.attacker.m_183503_().m_8055_(forwardNearPos.m_6625_(2)).m_60795_() && this.attacker.m_21574_().m_148306_((Entity)livingentity)) {
            BlockPos forwardFarPos = EntityUtils.getRelativeBlockPos((Entity)this.attacker, 5.0f, 0.0f);
            Vec3 vec3 = new Vec3((double)forwardFarPos.m_123341_(), (double)forwardFarPos.m_123342_(), (double)forwardFarPos.m_123343_());
            if (vec3.m_82554_(livingentity.m_20318_(0.0f)) < this.attacker.m_20318_(0.0f).m_82554_(livingentity.m_20318_(0.0f))) {
                Random rand = this.attacker.m_21187_();
                for (int i = 0; i < 4; ++i) {
                    Optional<Vec3> jump_vec;
                    forwardFarPos.m_142082_(rand.nextInt(2) - 1, rand.nextInt(2) - 1, rand.nextInt(2) - 1);
                    if (!this.attacker.m_21573_().m_6342_(forwardFarPos) || !(jump_vec = this.calculateOptimalJumpVector(this.attacker, Vec3.m_82512_((Vec3i)forwardFarPos))).isPresent()) continue;
                    double d1 = jump_vec.get().m_82553_();
                    double d2 = 1.0 + d1 + (this.attacker.m_21023_(MobEffects.f_19603_) ? (double)(0.1f * (float)(this.attacker.m_21124_(MobEffects.f_19603_).m_19564_() + 1)) : 0.0);
                    this.attacker.m_20334_(jump_vec.get().f_82479_ * d2 / d1, jump_vec.get().f_82480_, jump_vec.get().f_82481_ * d2 / d1);
                    this.attacker.m_21573_().m_26573_();
                    break;
                }
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(livingentity, d0);
    }

    protected void checkAndPerformAttack(LivingEntity enemy, double distToEnemySqr) {
        IAnimatedEntity animated;
        PathfinderMob pathfinderMob;
        double d0 = this.getAttackReachSqr(enemy);
        if (this.attacker.m_142582_((Entity)enemy) && distToEnemySqr <= d0 && (this.attackTick <= 0 || this.attackTick <= 10 && (pathfinderMob = this.attacker) instanceof IAnimatedEntity && (animated = (IAnimatedEntity)pathfinderMob).getAnimation() == IAnimatedEntity.NO_ANIMATION)) {
            this.attackTick = 20;
            this.attacker.m_7327_((Entity)enemy);
        }
    }

    protected double getAttackReachSqr(LivingEntity attackTarget) {
        return this.attacker.m_20205_() * 2.0f * this.attacker.m_20205_() * 2.0f + attackTarget.m_20205_() + this.extraReach;
    }

    private Optional<Vec3> calculateOptimalJumpVector(PathfinderMob entityIn, Vec3 p_147658_) {
        Optional<Vec3> optional = Optional.empty();
        for (int i = 20; i < 55; i += 5) {
            Optional<Vec3> optional1 = this.calculateJumpVectorForAngle(entityIn, p_147658_, i);
            if (!optional.isEmpty() && (!optional1.isPresent() || !(optional1.get().m_82556_() < optional.get().m_82556_()))) continue;
            optional = optional1;
        }
        return optional;
    }

    private Optional<Vec3> calculateJumpVectorForAngle(PathfinderMob entityIn, Vec3 p_147661_, int angleIn) {
        Vec3 vec3 = entityIn.m_20182_();
        Vec3 vec31 = new Vec3(p_147661_.f_82479_ - vec3.f_82479_, 0.0, p_147661_.f_82481_ - vec3.f_82481_).m_82541_().m_82490_(0.5);
        p_147661_ = p_147661_.m_82546_(vec31);
        Vec3 vec32 = p_147661_.m_82546_(vec3);
        float f = (float)angleIn * (float)Math.PI / 180.0f;
        double d0 = Math.atan2(vec32.f_82481_, vec32.f_82479_);
        double d1 = vec32.m_82492_(0.0, vec32.f_82480_, 0.0).m_82556_();
        double d2 = Math.sqrt(d1);
        double d3 = vec32.f_82480_;
        double d4 = Math.sin(2.0f * f);
        double d6 = Math.pow(Math.cos(f), 2.0);
        double d7 = Math.sin(f);
        double d8 = Math.cos(f);
        double d9 = Math.sin(d0);
        double d10 = Math.cos(d0);
        double d11 = d1 * 0.08 / (d2 * d4 - 2.0 * d3 * d6);
        if (d11 < 0.0) {
            return Optional.empty();
        }
        double d12 = Math.sqrt(d11);
        double d13 = d12 * d8;
        double d14 = d12 * d7;
        int i = Mth.m_14165_((double)(d2 / d13)) * 2;
        double d15 = 0.0;
        Vec3 vec33 = null;
        for (int j = 0; j < i - 1; ++j) {
            double d16 = d7 / d8 * (d15 += d2 / (double)i) - Math.pow(d15, 2.0) * 0.08 / (2.0 * d11 * Math.pow(d8, 2.0));
            double d17 = d15 * d10;
            double d18 = d15 * d9;
            Vec3 vec34 = new Vec3(vec3.f_82479_ + d17, vec3.f_82480_ + d16, vec3.f_82481_ + d18);
            if (vec33 != null && !this.isClearTransition((Mob)entityIn, vec33, vec34)) {
                return Optional.empty();
            }
            vec33 = vec34;
        }
        return Optional.of(new Vec3(d13 * d10, d14, d13 * d9).m_82490_((double)0.95f));
    }

    private boolean isClearTransition(Mob p_147664_, Vec3 p_147665_, Vec3 p_147666_) {
        EntityDimensions entitydimensions = p_147664_.m_6972_(Pose.LONG_JUMPING);
        Vec3 vec3 = p_147666_.m_82546_(p_147665_);
        double d0 = Math.min(entitydimensions.f_20377_, entitydimensions.f_20378_);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / d0));
        Vec3 vec31 = vec3.m_82541_();
        Vec3 vec32 = p_147665_;
        for (int j = 0; j < i; ++j) {
            vec32 = j == i - 1 ? p_147666_ : vec32.m_82549_(vec31.m_82490_(d0 * (double)0.9f));
            AABB aabb = entitydimensions.m_20393_(vec32);
            if (p_147664_.f_19853_.m_45756_((Entity)p_147664_, aabb)) continue;
            return false;
        }
        return true;
    }
}

