/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import untamedwilds.block.blockentity.ReptileNestBlockEntity;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INestingMob;
import untamedwilds.init.ModBlock;

public class LayEggsOnNestGoal
extends MoveToBlockGoal {
    private final ComplexMob taskOwner;
    private final Level world;
    private boolean hasReachedDestination;
    private boolean needsToBuildNest = false;
    private int nestBuildingTicks;

    public LayEggsOnNestGoal(ComplexMob entityIn) {
        super((PathfinderMob)entityIn, 1.0, 16, 4);
        this.taskOwner = entityIn;
        this.world = entityIn.f_19853_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!(this.taskOwner instanceof INestingMob) || !((INestingMob)((Object)this.taskOwner)).wantsToLayEggs()) {
            return false;
        }
        if (this.f_25600_ > 0) {
            --this.f_25600_;
            return false;
        }
        this.needsToBuildNest = false;
        this.f_25600_ = this.m_6099_(this.f_25598_);
        if (this.m_25626_()) {
            return true;
        }
        this.needsToBuildNest = true;
        return this.checkForNewNest();
    }

    public boolean m_8045_() {
        return ((INestingMob)((Object)this.taskOwner)).wantsToLayEggs() && super.m_8045_();
    }

    public double m_8052_() {
        return 1.0;
    }

    public void m_8037_() {
        super.m_8037_();
        BlockPos blockpos = this.m_6669_();
        if (!this.isWithinXZDist(blockpos, this.f_25598_.m_20182_(), this.m_8052_())) {
            this.hasReachedDestination = false;
            ++this.f_25601_;
            if (this.m_8064_()) {
                this.f_25598_.m_21573_().m_26519_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, this.f_25599_);
            }
        } else {
            this.hasReachedDestination = true;
            --this.f_25601_;
        }
        if (this.m_25625_()) {
            if (this.needsToBuildNest) {
                --this.nestBuildingTicks;
                if (this.nestBuildingTicks % 30 == 0) {
                    ((ServerLevel)this.taskOwner.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.taskOwner.f_19853_.m_8055_(this.f_25602_.m_7495_())), this.taskOwner.m_20185_(), this.taskOwner.m_20186_(), this.taskOwner.m_20189_(), 20, 0.0, 0.0, 0.0, (double)0.15f);
                    this.taskOwner.m_5496_(SoundEvents.f_12406_, 0.8f, 0.6f);
                }
                if (this.nestBuildingTicks <= 0) {
                    this.world.m_7731_(this.f_25602_, ((Block)ModBlock.NEST_REPTILE.get()).m_49966_(), 2);
                    ReptileNestBlockEntity te = (ReptileNestBlockEntity)this.world.m_7702_(this.f_25602_);
                    if (te != null) {
                        te.setEntityType(this.taskOwner.m_6095_());
                        te.setVariant(this.taskOwner.getVariant());
                        te.setEggCount(0);
                    }
                    this.needsToBuildNest = false;
                }
            } else {
                this.addEggsToNest();
                this.m_8041_();
            }
        }
    }

    @Nullable
    public boolean checkForNewNest() {
        Random random = this.taskOwner.m_21187_();
        BlockPos blockpos = this.taskOwner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.m_142082_(random.nextInt(8) - 4, random.nextInt(4) - 2, random.nextInt(8) - 4);
            if (!((INestingMob)((Object)this.taskOwner)).isValidNestBlock(blockpos1) || !this.m_6465_((LevelReader)this.f_25598_.f_19853_, blockpos1)) continue;
            this.nestBuildingTicks = 400 + this.taskOwner.m_21187_().nextInt(300);
            this.f_25602_ = blockpos1;
            return true;
        }
        return false;
    }

    private void addEggsToNest() {
        BlockEntity blockEntity;
        BlockState blockstate = this.taskOwner.f_19853_.m_8055_(this.f_25602_);
        if (blockstate.m_60713_((Block)ModBlock.NEST_REPTILE.get()) && (blockEntity = this.taskOwner.f_19853_.m_7702_(this.f_25602_)) instanceof ReptileNestBlockEntity) {
            ReptileNestBlockEntity nest = (ReptileNestBlockEntity)blockEntity;
            if (((INestingMob)((Object)this.taskOwner)).wantsToLayEggs()) {
                nest.setEggCount(nest.getEggCount() + this.taskOwner.getOffspring());
            }
            this.taskOwner.f_19853_.m_46717_(this.f_25602_, blockstate.m_60734_());
            ((INestingMob)((Object)this.taskOwner)).setEggStatus(false);
        }
    }

    private boolean isWithinXZDist(BlockPos blockpos, Vec3 positionVec, double distance) {
        return blockpos.m_123331_((Vec3i)new BlockPos(positionVec.m_7096_(), (double)blockpos.m_123342_(), positionVec.m_7094_())) < distance * distance;
    }

    protected boolean m_25625_() {
        return this.hasReachedDestination;
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        if (this.needsToBuildNest) {
            return ((INestingMob)((Object)this.taskOwner)).isValidNestBlock(pos);
        }
        return worldIn.m_8055_(pos).m_60713_((Block)ModBlock.NEST_REPTILE.get()) && worldIn.m_7702_(pos) instanceof ReptileNestBlockEntity && ((ReptileNestBlockEntity)worldIn.m_7702_(pos)).getVariant() == this.taskOwner.getVariant();
    }
}

