/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.ai.control.look.SmartSwimmerLookControl;
import untamedwilds.entity.ai.control.movement.SmartSwimmingMoveControl;

public abstract class ComplexMobAmphibious
extends ComplexMobTerrestrial {
    protected boolean isAmphibious;

    public ComplexMobAmphibious(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SmartSwimmingMoveControl((Mob)this, 40, 5, 0.25f, 0.3f, true);
        this.f_21365_ = new SmartSwimmerLookControl(this, 20);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_19793_ = 1.0f;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new AmphibiousPathNavigation(this, worldIn);
    }

    public boolean wantsToBeOnLand() {
        return true;
    }

    public boolean wantsToBeInWater() {
        return false;
    }

    public float m_6108_() {
        return this.m_20096_() ? 0.8f : 0.9f;
    }

    public boolean m_6040_() {
        return true;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_144067_;
    }

    static class AmphibiousPathNavigation
    extends WaterBoundPathNavigation {
        private final ComplexMobAmphibious entityIn;

        AmphibiousPathNavigation(ComplexMobAmphibious entityIn, Level worldIn) {
            super((Mob)entityIn, worldIn);
            this.entityIn = entityIn;
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_149222_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_149222_);
        }

        public boolean m_6342_(BlockPos destinationIn) {
            if (this.entityIn.wantsToBeInWater()) {
                return !this.f_26495_.m_8055_(destinationIn).m_60804_((BlockGetter)this.f_26495_, destinationIn) && this.f_26495_.m_6425_(destinationIn) != null;
            }
            if (this.entityIn.wantsToBeOnLand()) {
                BlockPos blockpos = destinationIn.m_7495_();
                return this.f_26495_.m_8055_(blockpos).m_60804_((BlockGetter)this.f_26495_, blockpos);
            }
            return !this.f_26495_.m_8055_(destinationIn.m_7495_()).m_60795_();
        }
    }
}

