/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import untamedwilds.entity.ComplexMobAquatic;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModTags;

public class ReedBlock
extends Block
implements BonemealableBlock,
SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE_NORMAL = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final IntegerProperty PROPERTY_AGE = BlockStateProperties.f_61406_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty PROPERTY_STAGE = BlockStateProperties.f_61387_;

    public ReedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PROPERTY_AGE, PROPERTY_STAGE, WATERLOGGED});
    }

    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        return SHAPE_NORMAL.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockState getStateForWorldgen(LevelAccessor world, BlockPos pos) {
        boolean isWaterLogged = !world.m_6425_(pos).m_76178_();
        BlockState blockstate = world.m_8055_(pos.m_7495_());
        if (blockstate.m_60734_() == ModBlock.COMMON_REED.get()) {
            BlockState blockstate1;
            if (world.m_6425_(pos.m_7495_()).m_76178_() || world.m_8055_(pos.m_6625_(2)).m_60734_() == ModBlock.COMMON_REED.get()) {
                world.m_7731_(pos.m_7495_(), (BlockState)blockstate.m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)), 1);
            }
            return (blockstate1 = world.m_8055_(pos.m_7494_())).m_60734_() != ModBlock.COMMON_REED.get() ? (BlockState)((BlockState)((Block)ModBlock.COMMON_REED.get()).m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged)) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        if (blockstate.m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(isWaterLogged ? 2 : 0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        return null;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isWaterLogged = !context.m_43725_().m_6425_(context.m_8083_()).m_76178_();
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if (blockstate.m_60734_() == ModBlock.COMMON_REED.get()) {
            BlockState blockstate1;
            if (context.m_43725_().m_6425_(context.m_8083_().m_7495_()).m_76178_() || context.m_43725_().m_8055_(context.m_8083_().m_6625_(2)).m_60734_() == ModBlock.COMMON_REED.get()) {
                context.m_43725_().m_46597_(context.m_8083_().m_7495_(), (BlockState)blockstate.m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)));
            }
            return (blockstate1 = context.m_43725_().m_8055_(context.m_8083_().m_7494_())).m_60734_() != ModBlock.COMMON_REED.get() ? (BlockState)((BlockState)((Block)ModBlock.COMMON_REED.get()).m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged)) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        if (blockstate.m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(isWaterLogged ? 2 : 0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
        }
        return null;
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)PROPERTY_STAGE) == 0;
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        int i;
        if ((Integer)state.m_61143_((Property)PROPERTY_STAGE) == 0 && random.nextInt(8) == 0 && worldIn.m_46859_(pos.m_7494_()) && worldIn.m_7146_(pos.m_7494_()) >= 9 && (i = this.getNumReedBlocksBelow((BlockGetter)worldIn, pos) + 1) < 4 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(3) == 0 ? 1 : 0) != 0)) {
            this.grow(state, (Level)worldIn, pos, random, i);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON) || worldIn.m_8055_(pos.m_7495_()).m_60734_() == ModBlock.COMMON_REED.get();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int j;
        int i = this.getNumReedBlocksAbove(worldIn, pos);
        return i + (j = this.getNumReedBlocksBelow(worldIn, pos)) + 1 < 4 && (Integer)worldIn.m_8055_(pos.m_6630_(i)).m_61143_((Property)PROPERTY_STAGE) != 1;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        int i = this.getNumReedBlocksAbove((BlockGetter)worldIn, pos);
        int j = this.getNumReedBlocksBelow((BlockGetter)worldIn, pos);
        int k = i + j + 1;
        int l = 1 + rand.nextInt(2);
        for (int i1 = 0; i1 < l; ++i1) {
            BlockPos blockpos = pos.m_6630_(i);
            BlockState blockstate = worldIn.m_8055_(blockpos);
            if (k >= 4 || (Integer)blockstate.m_61143_((Property)PROPERTY_STAGE) == 1 || !worldIn.m_46859_(blockpos.m_7494_())) {
                return;
            }
            this.grow(blockstate, (Level)worldIn, blockpos, rand, k);
            ++i;
            ++k;
        }
    }

    protected void grow(BlockState blockStateIn, Level worldIn, BlockPos posIn, Random rand, int p_220258_5_) {
        int j;
        BlockState blockstate = worldIn.m_8055_(posIn.m_7495_());
        boolean i = (Integer)blockStateIn.m_61143_((Property)PROPERTY_AGE) == 1 || blockstate.m_60734_() == ModBlock.COMMON_REED.get();
        int n = j = !(p_220258_5_ >= 1 && rand.nextFloat() < 0.4f || p_220258_5_ == 4) ? 0 : 1;
        if ((Integer)blockStateIn.m_61143_((Property)PROPERTY_AGE) != 2) {
            worldIn.m_7731_(posIn, (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(j)), 3);
        }
        worldIn.m_7731_(posIn.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(j)), 3);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return player.m_21205_().canPerformAction(ToolActions.SWORD_DIG) ? 1.0f : super.m_5880_(state, player, worldIn, pos);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!(!(entityIn instanceof LivingEntity) || entityIn instanceof WaterAnimal || entityIn instanceof FlyingAnimal || entityIn instanceof ComplexMobAquatic || entityIn.m_20069_() || entityIn.m_20161_())) {
            entityIn.m_7601_(state, new Vec3((double)0.95f, 1.0, (double)0.95f));
            if (worldIn.m_5822_().nextInt(20) == 0) {
                worldIn.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11992_, SoundSource.AMBIENT, 1.0f, 1.0f, true);
            }
        }
    }

    protected int getNumReedBlocksAbove(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.m_8055_(pos.m_6630_(i + 1)).m_60734_() == ModBlock.COMMON_REED.get(); ++i) {
        }
        return i;
    }

    protected int getNumReedBlocksBelow(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; i < 4 && worldIn.m_8055_(pos.m_6625_(i + 1)).m_60734_() == ModBlock.COMMON_REED.get(); ++i) {
        }
        return i;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

