/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import untamedwilds.block.blockentity.EggBlockEntity;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.ISpecies;
import untamedwilds.init.ModAdvancementTriggers;
import untamedwilds.world.FaunaHandler;

public class FeederBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    public static final IntegerProperty HAS_FOOD = BlockStateProperties.f_61407_;

    public FeederBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HAS_FOOD, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_FOOD});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = this.m_49966_();
        return (BlockState)blockstate.m_61124_((Property)HAS_FOOD, (Comparable)Integer.valueOf(0));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader serverLevel, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return this.isValidGround(serverLevel.m_8055_(blockpos), (BlockGetter)serverLevel, blockpos);
    }

    protected boolean isValidGround(BlockState state, BlockGetter serverLevel, BlockPos pos) {
        return !state.m_60812_(serverLevel, pos).m_83263_(Direction.DOWN).m_83281_();
    }

    public InteractionResult m_6227_(BlockState state, Level serverLevel, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = playerIn.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && itemstack.m_150930_(Items.f_42787_)) {
            if (!serverLevel.f_46443_) {
                ModAdvancementTriggers.ACTIVATED_FEEDER.trigger((ServerPlayer)playerIn);
            }
            playerIn.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
            serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_FOOD, (Comparable)Integer.valueOf(3)), 3);
            serverLevel.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor serverLevel, BlockPos currentPos, BlockPos facingPos) {
        if (!this.m_7898_(stateIn, (LevelReader)serverLevel, currentPos)) {
            serverLevel.m_46961_(currentPos, true);
        }
        return super.m_7417_(stateIn, facing, facingState, serverLevel, currentPos, facingPos);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EggBlockEntity(pos, state);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)HAS_FOOD) > 0;
    }

    public void m_7455_(BlockState state, ServerLevel serverLevel, BlockPos pos, Random random) {
        if ((Integer)state.m_61143_((Property)HAS_FOOD) > 0) {
            this.spawnMobs(serverLevel, pos);
            this.spawnParticles((Level)serverLevel, pos, ParticleTypes.f_123748_);
            serverLevel.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_FOOD, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)HAS_FOOD) - 1)), 3);
        }
    }

    private <T extends ParticleOptions> void spawnParticles(Level serverLevel, BlockPos pos, T particle) {
        Random random = serverLevel.m_5822_();
        float d3 = random.nextFloat() * 0.02f;
        float d1 = random.nextFloat() * 0.02f;
        float d2 = random.nextFloat() * 0.02f;
        ((ServerLevel)serverLevel).m_8767_(particle, (double)((float)pos.m_123341_() + random.nextFloat()), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + random.nextFloat()), 15, (double)d3, (double)d1, (double)d2, (double)0.12f);
    }

    private void spawnMobs(ServerLevel serverLevel, BlockPos pos) {
        int count = serverLevel.f_46441_.nextInt(3) + 1;
        for (int i = 0; i < count; ++i) {
            int z;
            int y;
            int x;
            EntityType<?> entityType;
            Optional entry = WeightedRandom.m_146317_((Random)serverLevel.f_46441_, FaunaHandler.getSpawnableList(FaunaHandler.animalType.FEEDER));
            if (!entry.isPresent() || !serverLevel.m_45772_((entityType = ((FaunaHandler.SpawnListEntry)((Object)entry.get())).entityType).m_20585_((double)(x = pos.m_123341_() + serverLevel.f_46441_.nextInt(16) - 8), (double)(y = pos.m_123342_() + serverLevel.f_46441_.nextInt(6) - 3), (double)(z = pos.m_123343_() + serverLevel.f_46441_.nextInt(16) - 8))) || !SpawnPlacements.m_21759_(entityType, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.CHUNK_GENERATION, (BlockPos)pos, (Random)serverLevel.m_5822_())) continue;
            Entity spawn = entityType.m_20655_(serverLevel, null, null, null, new BlockPos(x, y, z), MobSpawnType.NATURAL, true, true);
            if (spawn instanceof ComplexMob) {
                ComplexMob entitySpawn = (ComplexMob)spawn;
                Holder optional = serverLevel.m_204166_(new BlockPos(x, y, z));
                int species = ((ISpecies)spawn).setSpeciesByBiome((Holder<Biome>)optional, MobSpawnType.NATURAL);
                entitySpawn.setVariant(species);
                if (species == 99) {
                    entitySpawn.m_142687_(Entity.RemovalReason.DISCARDED);
                    continue;
                }
                entitySpawn.chooseSkinForSpecies(entitySpawn, true);
                entitySpawn.setRandomMobSize();
                entitySpawn.setGender(entitySpawn.m_21187_().nextInt(2));
                if (spawn instanceof INeedsPostUpdate) {
                    ((INeedsPostUpdate)((Object)entitySpawn)).updateAttributes();
                }
            }
            serverLevel.m_47205_(spawn);
        }
    }
}

