/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.util;

import com.google.common.collect.ArrayListMultimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.AutoRegLib;
import vazkii.arl.interf.IBlockColorProvider;
import vazkii.arl.interf.IBlockItemProvider;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.interf.IItemPropertiesFiller;

public final class RegistryHelper {
    private static final Map<String, ModData> modData = new HashMap<String, ModData>();
    private static Queue<Pair<Item, IItemColorProvider>> itemColors = new ArrayDeque<Pair<Item, IItemColorProvider>>();
    private static Queue<Pair<Block, IBlockColorProvider>> blockColors = new ArrayDeque<Pair<Block, IBlockColorProvider>>();

    private static ModData getCurrentModData() {
        return RegistryHelper.getModData(ModLoadingContext.get().getActiveNamespace());
    }

    private static ModData getModData(String modid) {
        ModData data = modData.get(modid);
        if (data == null) {
            data = new ModData();
            modData.put(modid, data);
            FMLJavaModLoadingContext.get().getModEventBus().register(RegistryHelper.class);
        }
        return data;
    }

    @SubscribeEvent
    public static void onRegistryEvent(RegistryEvent.Register<?> event) {
        RegistryHelper.getCurrentModData().register(event.getRegistry());
    }

    public static void registerBlock(Block block, String resloc) {
        RegistryHelper.registerBlock(block, resloc, true);
    }

    public static void registerBlock(Block block, String resloc, boolean hasBlockItem) {
        RegistryHelper.register(block, resloc);
        if (hasBlockItem) {
            ModData data = RegistryHelper.getCurrentModData();
            data.defers.put(Item.class, () -> data.createItemBlock(block));
        }
        if (block instanceof IBlockColorProvider) {
            blockColors.add((Pair<Block, IBlockColorProvider>)Pair.of((Object)block, (Object)((IBlockColorProvider)block)));
        }
    }

    public static void registerItem(Item item, String resloc) {
        RegistryHelper.register(item, resloc);
        if (item instanceof IItemColorProvider) {
            itemColors.add((Pair<Item, IItemColorProvider>)Pair.of((Object)item, (Object)((IItemColorProvider)item)));
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistryEntry<T> obj, String resloc) {
        if (obj == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        obj.setRegistryName(GameData.checkPrefix((String)resloc, (boolean)false));
        RegistryHelper.getCurrentModData().defers.put((Object)obj.getRegistryType(), () -> obj);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistryEntry<T> obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Can't register null object.");
        }
        if (obj.getRegistryName() == null) {
            throw new IllegalArgumentException("Can't register object without registry name.");
        }
        RegistryHelper.getCurrentModData().defers.put((Object)obj.getRegistryType(), () -> obj);
    }

    public static void setCreativeTab(Block block, CreativeModeTab group) {
        ResourceLocation res = block.getRegistryName();
        if (res == null) {
            throw new IllegalArgumentException("Can't set the creative tab for a block without a registry name yet");
        }
        RegistryHelper.getCurrentModData().groups.put(block.getRegistryName(), group);
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RegistryHelper.loadCompleteClient(event));
        itemColors.clear();
        blockColors.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean loadCompleteClient(FMLLoadCompleteEvent event) {
        BlockColor color;
        Object pair;
        Minecraft mc = Minecraft.m_91087_();
        BlockColors bcolors = mc.m_91298_();
        ItemColors icolors = mc.getItemColors();
        while (!blockColors.isEmpty()) {
            pair = blockColors.poll();
            color = ((IBlockColorProvider)pair.getSecond()).getBlockColor();
            if (color == null) continue;
            bcolors.m_92589_(color, new Block[]{(Block)pair.getFirst()});
        }
        while (!itemColors.isEmpty()) {
            pair = itemColors.poll();
            color = ((IItemColorProvider)pair.getSecond()).getItemColor();
            if (color == null) continue;
            icolors.m_92689_((ItemColor)color, new ItemLike[]{(ItemLike)pair.getFirst()});
        }
        return true;
    }

    private static class ModData {
        private Map<ResourceLocation, CreativeModeTab> groups = new LinkedHashMap<ResourceLocation, CreativeModeTab>();
        private ArrayListMultimap<Class<?>, Supplier<IForgeRegistryEntry<?>>> defers = ArrayListMultimap.create();

        private ModData() {
        }

        private void register(IForgeRegistry registry) {
            Class type = registry.getRegistrySuperType();
            if (this.defers.containsKey((Object)type)) {
                List ourEntries = this.defers.get((Object)type);
                for (Supplier supplier : ourEntries) {
                    IForgeRegistryEntry entry = (IForgeRegistryEntry)supplier.get();
                    registry.register(entry);
                    AutoRegLib.LOGGER.debug("Registering to " + registry.getRegistryName() + " - " + entry.getRegistryName());
                }
                this.defers.removeAll((Object)type);
            }
        }

        private Item createItemBlock(Block block) {
            Item.Properties props = new Item.Properties();
            ResourceLocation registryName = block.getRegistryName();
            CreativeModeTab group = this.groups.get(registryName);
            if (group != null) {
                props = props.m_41491_(group);
            }
            if (block instanceof IItemPropertiesFiller) {
                ((IItemPropertiesFiller)block).fillItemProperties(props);
            }
            BlockItem blockitem = block instanceof IBlockItemProvider ? ((IBlockItemProvider)block).provideItemBlock(block, props) : new BlockItem(block, props);
            if (block instanceof IItemColorProvider) {
                itemColors.add((Pair<Item, IItemColorProvider>)Pair.of((Object)blockitem, (Object)((IItemColorProvider)block)));
            }
            return (Item)blockitem.setRegistryName(registryName);
        }
    }
}

