/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.level.pathfinder;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class MutantWalkNodeEvaluator
extends WalkNodeEvaluator {
    public static BlockPathTypes getBlockPathTypeStatic(BlockGetter blockReader, BlockPos.MutableBlockPos mutable) {
        int posX = mutable.m_123341_();
        int posY = mutable.m_123342_();
        int posZ = mutable.m_123343_();
        BlockPathTypes rawNode = MutantWalkNodeEvaluator.getBlockPathTypeRaw(blockReader, (BlockPos)mutable);
        if (rawNode == BlockPathTypes.OPEN && posY >= blockReader.m_141937_() + 1) {
            BlockPathTypes nodeBelow = MutantWalkNodeEvaluator.getBlockPathTypeRaw(blockReader, (BlockPos)mutable.m_122178_(posX, posY - 1, posZ));
            rawNode = nodeBelow != BlockPathTypes.WALKABLE && nodeBelow != BlockPathTypes.OPEN && nodeBelow != BlockPathTypes.WATER && nodeBelow != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            switch (nodeBelow) {
                case DAMAGE_FIRE: 
                case DAMAGE_OTHER: 
                case DANGER_OTHER: 
                case STICKY_HONEY: {
                    BlockPathTypes blockPathTypes = nodeBelow;
                    break;
                }
                case POWDER_SNOW: {
                    BlockPathTypes blockPathTypes = BlockPathTypes.DANGER_POWDER_SNOW;
                    break;
                }
                default: {
                    BlockPathTypes blockPathTypes = rawNode = rawNode;
                }
            }
        }
        if (rawNode == BlockPathTypes.WALKABLE) {
            rawNode = MutantWalkNodeEvaluator.checkNeighbourBlocks(blockReader, mutable.m_122178_(posX, posY, posZ), rawNode);
        }
        return rawNode;
    }

    public static BlockPathTypes checkNeighbourBlocks(BlockGetter blockReader, BlockPos.MutableBlockPos mutable, BlockPathTypes pathNodeType) {
        int x = mutable.m_123341_();
        int y = mutable.m_123342_();
        int z = mutable.m_123343_();
        for (int extraX = -1; extraX <= 1; ++extraX) {
            for (int extraY = -1; extraY <= 1; ++extraY) {
                for (int extraZ = -1; extraZ <= 1; ++extraZ) {
                    if (extraX == 0 && extraZ == 0) continue;
                    mutable.m_122178_(x + extraX, y + extraY, z + extraZ);
                    BlockPathTypes rawNode = MutantWalkNodeEvaluator.getBlockPathTypeRaw(blockReader, (BlockPos)mutable);
                    switch (rawNode) {
                        case DAMAGE_FIRE: {
                            return BlockPathTypes.DANGER_FIRE;
                        }
                        case DAMAGE_OTHER: 
                        case DANGER_OTHER: {
                            return BlockPathTypes.DANGER_OTHER;
                        }
                        case WATER: {
                            return BlockPathTypes.WATER_BORDER;
                        }
                        case LAVA: {
                            return BlockPathTypes.LAVA;
                        }
                    }
                }
            }
        }
        return pathNodeType;
    }

    protected static BlockPathTypes getBlockPathTypeRaw(BlockGetter blockReader, BlockPos blockPos) {
        BlockState blockstate = blockReader.m_8055_(blockPos);
        Block block = blockstate.m_60734_();
        if (blockstate.m_204336_(BlockTags.f_13075_)) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        if (block.m_49964_() < 1.0f) {
            return BlockPathTypes.STICKY_HONEY;
        }
        if (block.m_49961_() < 1.0f || blockstate.m_60713_(Blocks.f_50033_) || blockstate.m_204336_(BlockTags.f_13099_) || blockstate.m_60713_(Blocks.f_50267_) || blockstate.m_60713_(Blocks.f_50070_)) {
            return BlockPathTypes.DANGER_OTHER;
        }
        return WalkNodeEvaluator.m_77643_((BlockGetter)blockReader, (BlockPos)blockPos);
    }

    protected BlockPathTypes m_6603_(BlockGetter blockReader, boolean canOpenDoors, boolean canEnterDoors, BlockPos blockPos, BlockPathTypes pathNodeType) {
        if (pathNodeType == BlockPathTypes.DOOR_WOOD_CLOSED && canOpenDoors && canEnterDoors) {
            pathNodeType = BlockPathTypes.WALKABLE;
        }
        if (pathNodeType == BlockPathTypes.DOOR_OPEN && !canEnterDoors) {
            pathNodeType = BlockPathTypes.BLOCKED;
        }
        if (pathNodeType == BlockPathTypes.LEAVES) {
            pathNodeType = BlockPathTypes.BLOCKED;
        }
        return pathNodeType;
    }

    public BlockPathTypes m_8086_(BlockGetter blockaccessIn, int x, int y, int z) {
        return MutantWalkNodeEvaluator.getBlockPathTypeStatic(blockaccessIn, new BlockPos.MutableBlockPos(x, y, z));
    }
}

