/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.proxy.Proxy;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.OwnerTargetGoal;
import fuzs.mutantmonsters.world.level.ExplosionInteraction;
import fuzs.mutantmonsters.world.level.MutatedExplosion;
import fuzs.mutantmonsters.world.level.pathfinder.MutantGroundPathNavigation;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LandOnOwnersShoulderGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class CreeperMinion
extends ShoulderRidingEntity {
    private static final EntityDataAccessor<Byte> CREEPER_MINION_FLAGS = SynchedEntityData.m_135353_(CreeperMinion.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> EXPLODE_STATE = SynchedEntityData.m_135353_(CreeperMinion.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> EXPLOSION_RADIUS = SynchedEntityData.m_135353_(CreeperMinion.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private final int fuseTime = 26;

    public CreeperMinion(EntityType<? extends CreeperMinion> type, Level worldIn) {
        super(type, worldIn);
        this.setDestroyBlocks(true);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new CreeperMinionSwellGoal());
        this.f_21345_.m_25352_(3, (Goal)new AvoidDamageGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal<Animal>((PathfinderMob)this, Animal.class, 6.0f, 1.0, 1.2, EntityUtil::isFeline){

            public boolean m_8036_() {
                return !CreeperMinion.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new MutantMeleeAttackGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new CreeperMinionFollowOwnerGoal());
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LandOnOwnersShoulderGoal(this){

            public boolean m_8036_() {
                return CreeperMinion.this.m_21824_() && CreeperMinion.this.m_142480_() instanceof Player && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new OwnerTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByNearestTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, true, null));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CreeperMinion.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CREEPER_MINION_FLAGS, (Object)0);
        this.f_19804_.m_135372_(EXPLODE_STATE, (Object)-1);
        this.f_19804_.m_135372_(EXPLOSION_RADIUS, (Object)Float.valueOf(2.0f));
    }

    @Nullable
    public LivingEntity m_142480_() {
        UUID uuid = this.m_142504_();
        if (uuid == null) {
            return null;
        }
        Player entity = this.f_19853_.m_46003_(uuid);
        if (entity == null && this.f_19853_ instanceof ServerLevel) {
            entity = ((ServerLevel)this.f_19853_).m_8791_(uuid);
        }
        return entity instanceof LivingEntity ? (LivingEntity)entity : null;
    }

    public int getExplodeState() {
        return (Integer)this.f_19804_.m_135370_(EXPLODE_STATE);
    }

    public void setExplodeState(int state) {
        this.f_19804_.m_135381_(EXPLODE_STATE, (Object)state);
    }

    public boolean isCharged() {
        return ((Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS) & 1) != 0;
    }

    public void setCharged(boolean charged) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS);
        this.f_19804_.m_135381_(CREEPER_MINION_FLAGS, (Object)(charged ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean hasIgnited() {
        return ((Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS) & 4) != 0;
    }

    public void ignite() {
        byte b0 = (Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS);
        this.f_19804_.m_135381_(CREEPER_MINION_FLAGS, (Object)((byte)(b0 | 4)));
    }

    public boolean canExplodeContinuously() {
        return ((Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS) & 8) != 0;
    }

    public void setCanExplodeContinuously(boolean continuously) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS);
        this.f_19804_.m_135381_(CREEPER_MINION_FLAGS, (Object)(continuously ? (byte)(b0 | 8) : (byte)(b0 & 0xFFFFFFF7)));
    }

    public boolean canDestroyBlocks() {
        return ((Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS) & 0x10) != 0;
    }

    public void setDestroyBlocks(boolean destroy) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS);
        this.f_19804_.m_135381_(CREEPER_MINION_FLAGS, (Object)(destroy ? (byte)(b0 | 0x10) : (byte)(b0 & 0xFFFFFFEF)));
    }

    public boolean canRideOnShoulder() {
        return ((Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS) & 0x20) != 0;
    }

    public void setCanRideOnShoulder(boolean canRide) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CREEPER_MINION_FLAGS);
        this.f_19804_.m_135381_(CREEPER_MINION_FLAGS, (Object)(canRide ? (byte)(b0 | 0x20) : (byte)(b0 & 0xFFFFFFDF)));
    }

    public float getExplosionRadius() {
        return ((Float)this.f_19804_.m_135370_(EXPLOSION_RADIUS)).floatValue();
    }

    public void setExplosionRadius(float radius) {
        this.f_19804_.m_135381_(EXPLOSION_RADIUS, (Object)Float.valueOf(radius));
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (f_21798_.equals(key)) {
            this.m_6210_();
        }
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new MutantGroundPathNavigation((Mob)this, worldIn);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.m_21825_() ? super.m_6972_(poseIn).m_20390_(1.0f, 0.75f) : super.m_6972_(poseIn);
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean m_29897_() {
        return super.m_29897_() && this.canRideOnShoulder() && this.m_5448_() == null && this.getExplodeState() <= 0;
    }

    public void m_8038_(ServerLevel serverWorld, LightningBolt lightningBoltEntity) {
        super.m_8038_(serverWorld, lightningBoltEntity);
        this.setCharged(true);
    }

    protected boolean m_8028_() {
        return !this.m_21824_();
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        boolean hasFallen = super.m_142535_(distance, damageMultiplier, source);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return hasFallen;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setExplodeState(1);
            }
            if ((i = this.getExplodeState()) > 0 && this.timeSinceIgnited == 0) {
                this.m_5496_((SoundEvent)ModRegistry.ENTITY_CREEPER_MINION_PRIMED_SOUND_EVENT.get(), 1.0f, this.m_6100_());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = 0;
                if (!this.f_19853_.f_46443_) {
                    MutatedExplosion.create((Entity)this, this.getExplosionRadius() + (this.isCharged() ? 2.0f : 0.0f), false, this.canDestroyBlocks() ? ExplosionInteraction.MOB : ExplosionInteraction.NONE);
                    if (!this.canExplodeContinuously()) {
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.m_142480_() instanceof ServerPlayer) {
                            ((ServerPlayer)this.m_142480_()).m_6352_((Component)new TranslatableComponent("death.attack.explosion", new Object[]{this.m_5446_()}), this.m_142480_().m_142081_());
                        }
                        this.f_20890_ = true;
                        this.m_146870_();
                        EntityUtil.spawnLingeringCloud((LivingEntity)this);
                    }
                }
                this.setExplodeState(-this.fuseTime);
            }
            if (this.m_20184_().m_82556_() > (double)0.8f && this.m_5448_() != null && this.m_142469_().m_82369_(this.m_20184_()).m_82400_(0.5).m_82381_(this.m_5448_().m_142469_())) {
                this.timeSinceIgnited = this.fuseTime;
            }
        }
        super.m_8119_();
    }

    public float getFlashIntensity(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_21824_()) {
            if (item == ModRegistry.CREEPER_MINION_TRACKER_ITEM.get()) {
                if (this.f_19853_.f_46443_) {
                    Proxy.INSTANCE.displayCreeperMinionTrackerGUI(this);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.m_21830_((LivingEntity)player)) {
                if (item == Items.f_42403_) {
                    if (this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(1.0f);
                        itemstack.m_41774_(1);
                        double d0 = this.f_19796_.nextGaussian() * 0.02;
                        double d1 = this.f_19796_.nextGaussian() * 0.02;
                        double d2 = this.f_19796_.nextGaussian() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
                        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                    }
                    if (this.m_21233_() < 20.0f) {
                        this.m_21051_(Attributes.f_22276_).m_22100_((double)(this.m_21233_() + 1.0f));
                        itemstack.m_41774_(1);
                        double d0 = this.f_19796_.nextGaussian() * 0.02;
                        double d1 = this.f_19796_.nextGaussian() * 0.02;
                        double d2 = this.f_19796_.nextGaussian() * 0.02;
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
                        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                    }
                } else {
                    if (item != Items.f_41996_) {
                        if (!this.f_19853_.f_46443_) {
                            this.m_21839_(!this.m_21827_());
                            this.m_6703_(null);
                            this.m_6710_(null);
                        }
                        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                    }
                    if (!this.canExplodeContinuously()) {
                        this.f_146735_ += 15;
                        this.setCanExplodeContinuously(true);
                        itemstack.m_41774_(1);
                        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                    }
                    float explosionRadius = this.getExplosionRadius();
                    if (explosionRadius < 4.0f) {
                        this.f_146735_ += 10;
                        this.setExplosionRadius(explosionRadius + 0.11f);
                        itemstack.m_41774_(1);
                        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                    }
                }
            }
            return InteractionResult.PASS;
        }
        if (item == Items.f_42409_ && !this.hasIgnited()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)player, livingEntity -> livingEntity.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (player.m_7500_() && item == ModRegistry.CREEPER_MINION_TRACKER_ITEM.get() && this.m_142480_() == null) {
            if (!this.f_19853_.f_46443_) {
                this.m_7105_(true);
                this.m_21816_(player.m_142081_());
                player.m_6352_((Component)new TranslatableComponent(((Item)ModRegistry.CREEPER_MINION_TRACKER_ITEM.get()).m_5524_() + ".tame_success", new Object[]{this.m_5446_(), player.m_5446_()}), player.m_142081_());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        return EntityUtil.shouldAttackEntity((TamableAnimal)this, target, owner, true);
    }

    public boolean m_7327_(Entity entityIn) {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_19372_()) {
            if (this.m_21824_()) {
                return false;
            }
            if (amount >= 2.0f) {
                amount = 2.0f;
            }
        }
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    public boolean m_6128_() {
        return this.m_21824_();
    }

    public boolean m_6573_(Player player) {
        return super.m_6573_(player) && this.m_21824_();
    }

    public boolean m_6549_(EntityType<?> typeIn) {
        return super.m_6549_(typeIn) && typeIn != ModRegistry.MUTANT_CREEPER_ENTITY_TYPE.get();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21824_();
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.72f * this.m_20192_()), (double)(this.m_20205_() * 0.2f));
    }

    @Nullable
    public Team m_5647_() {
        LivingEntity owner = this.m_142480_();
        return owner != null ? owner.m_5647_() : super.m_5647_();
    }

    public boolean m_7307_(Entity entityIn) {
        LivingEntity owner = this.m_142480_();
        return owner != null && (entityIn == owner || owner.m_7307_(entityIn)) || super.m_7307_(entityIn);
    }

    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        return null;
    }

    public void m_8032_() {
        if (this.m_5448_() == null && this.getExplodeState() <= 0) {
            super.m_8032_();
        }
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.5f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.ENTITY_CREEPER_MINION_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)ModRegistry.ENTITY_CREEPER_MINION_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.ENTITY_CREEPER_MINION_DEATH_SOUND_EVENT.get();
    }

    public SoundSource m_5720_() {
        return this.m_21824_() ? SoundSource.NEUTRAL : SoundSource.HOSTILE;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Tamed", this.m_21824_());
        compound.m_128379_("ExplodesContinuously", this.canExplodeContinuously());
        compound.m_128379_("DestroysBlocks", this.canDestroyBlocks());
        compound.m_128379_("CanRideOnShoulder", this.canRideOnShoulder());
        compound.m_128379_("Ignited", this.hasIgnited());
        compound.m_128350_("ExplosionRadius", this.getExplosionRadius());
        if (this.isCharged()) {
            compound.m_128379_("Powered", true);
        }
        for (String s : new String[]{"Age", "ForcedAge", "InLove", "LoveCause"}) {
            compound.m_128473_(s);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_7105_(compound.m_128471_("Tamed"));
        this.setCanExplodeContinuously(compound.m_128471_("ExplodesContinuously"));
        this.setDestroyBlocks(compound.m_128471_("DestroysBlocks"));
        this.setCanRideOnShoulder(compound.m_128471_("CanRideOnShoulder"));
        this.setCharged(compound.m_128471_("Powered"));
        if (compound.m_128441_("ExplosionRadius")) {
            this.setExplosionRadius(compound.m_128457_("ExplosionRadius"));
        }
        if (compound.m_128471_("Ignited")) {
            this.ignite();
        }
    }

    class CreeperMinionSwellGoal
    extends Goal {
        public CreeperMinionSwellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = CreeperMinion.this.m_5448_();
            return !CreeperMinion.this.m_21827_() && (CreeperMinion.this.getExplodeState() > 0 || livingentity != null && CreeperMinion.this.m_20280_((Entity)livingentity) < 9.0 && CreeperMinion.this.m_142582_((Entity)livingentity));
        }

        public void m_8037_() {
            CreeperMinion.this.setExplodeState(CreeperMinion.this.m_5448_() != null && !(CreeperMinion.this.m_20280_((Entity)CreeperMinion.this.m_5448_()) > 36.0) && CreeperMinion.this.m_21574_().m_148306_((Entity)CreeperMinion.this.m_5448_()) ? 1 : -1);
        }

        public void m_8056_() {
            CreeperMinion.this.m_21573_().m_26573_();
        }
    }

    class CreeperMinionFollowOwnerGoal
    extends FollowOwnerGoal {
        public CreeperMinionFollowOwnerGoal() {
            super((TamableAnimal)CreeperMinion.this, 1.2, 10.0f, 5.0f, false);
        }

        public void m_8037_() {
            if (!CreeperMinion.this.m_21824_()) {
                if (CreeperMinion.this.m_142480_() != null) {
                    CreeperMinion.this.m_21573_().m_5624_((Entity)CreeperMinion.this.m_142480_(), 1.2);
                }
            } else {
                super.m_8037_();
            }
        }
    }
}

