/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.data;

import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.GameStages;
import net.darkhax.gamestages.data.FakePlayerData;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gamestages")
public class GameStageSaveHandler {
    private static final Map<UUID, IStageData> GLOBAL_STAGE_DATA = new HashMap<UUID, IStageData>();
    private static final Map<String, FakePlayerData> FAKE_STAGE_DATA = new HashMap<String, FakePlayerData>();
    private static final Set<String> KNOWN_STAGES = new HashSet<String>();
    private static final File FAKE_PLAYER_STAGE_FILE = new File("config/gamestages/fake_players.json");
    private static final File KNOWN_STAGES_FILE = new File("config/gamestages/known_stages.json");
    private static final Gson GSON = new Gson();
    @OnlyIn(value=Dist.CLIENT)
    private static IStageData clientData;

    @SubscribeEvent
    public static void onPlayerLoad(PlayerEvent.LoadFromFile event) {
        File playerFile = GameStageSaveHandler.getPlayerFile(event.getPlayerDirectory(), event.getPlayerUUID());
        StageData playerData = new StageData();
        if (playerFile.exists()) {
            try {
                CompoundTag tag = NbtIo.m_128937_((File)playerFile);
                playerData.readFromNBT(tag);
                GameStages.LOG.debug("Loaded {} stages for {}.", (Object)playerData.getStages().size(), (Object)event.getPlayer().m_7755_());
            }
            catch (IOException e) {
                GameStages.LOG.error("Could not read player data for {}.", (Object)event.getPlayer().m_7755_());
                GameStages.LOG.catching((Throwable)e);
            }
        }
        GLOBAL_STAGE_DATA.put(event.getPlayer().m_142081_(), playerData);
    }

    @SubscribeEvent
    public static void onPlayerSave(PlayerEvent.SaveToFile event) {
        UUID playerUUID = event.getPlayer().m_142081_();
        if (GLOBAL_STAGE_DATA.containsKey(playerUUID)) {
            IStageData playerData = GameStageSaveHandler.getPlayerData(playerUUID);
            File playerFile = GameStageSaveHandler.getPlayerFile(event.getPlayerDirectory(), event.getPlayerUUID());
            CompoundTag tag = playerData.writeToNBT();
            if (tag != null) {
                try {
                    NbtIo.m_128944_((CompoundTag)tag, (File)playerFile);
                    GameStages.LOG.debug("Saved {} stages for {}.", (Object)playerData.getStages().size(), (Object)event.getPlayer().m_7755_());
                }
                catch (IOException e) {
                    GameStages.LOG.error("Could not write player data for {}.", (Object)playerFile.getName());
                    GameStages.LOG.catching((Throwable)e);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            GameStageHelper.syncPlayer((ServerPlayer)event.getPlayer());
        }
    }

    @Nullable
    public static IStageData getPlayerData(UUID uuid) {
        return GLOBAL_STAGE_DATA.get(uuid);
    }

    private static File getPlayerFile(File playerDir, String uuid) {
        File saveDir = new File(playerDir, "gamestages");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        return new File(saveDir, uuid + ".dat");
    }

    public static void reloadFakePlayers() {
        GameStages.LOG.debug("Reloading fakeplayers stage data from {}.", (Object)FAKE_PLAYER_STAGE_FILE.getName());
        if (!FAKE_PLAYER_STAGE_FILE.getParentFile().exists()) {
            FAKE_PLAYER_STAGE_FILE.getParentFile().mkdirs();
        }
        FAKE_STAGE_DATA.clear();
        if (FAKE_PLAYER_STAGE_FILE.exists()) {
            try (BufferedReader reader = Files.newReader((File)FAKE_PLAYER_STAGE_FILE, (Charset)StandardCharsets.UTF_8);){
                FakePlayerData[] fakePlayers = (FakePlayerData[])GSON.fromJson((Reader)reader, FakePlayerData[].class);
                if (fakePlayers != null) {
                    Arrays.stream(fakePlayers).forEach(GameStageSaveHandler::addFakePlayer);
                } else {
                    GameStages.LOG.error("Your fake player stages file is incorrect. Expected an array of fake player entries.");
                }
            }
            catch (Exception e) {
                GameStages.LOG.error("Could not read {}.", (Object)FAKE_PLAYER_STAGE_FILE.getName());
                GameStages.LOG.catching((Throwable)e);
            }
        }
    }

    public static void reloadKnownStages() {
        GameStages.LOG.debug("Reloading known stages data from {}.", (Object)KNOWN_STAGES_FILE.getName());
        if (!KNOWN_STAGES_FILE.getParentFile().exists()) {
            KNOWN_STAGES_FILE.getParentFile().mkdirs();
        }
        KNOWN_STAGES.clear();
        if (KNOWN_STAGES_FILE.exists()) {
            try (BufferedReader reader = Files.newReader((File)KNOWN_STAGES_FILE, (Charset)StandardCharsets.UTF_8);){
                String[] knownStages = (String[])GSON.fromJson((Reader)reader, String[].class);
                if (knownStages != null) {
                    for (String stageName : knownStages) {
                        if (GameStageHelper.isValidStageName(stageName)) {
                            KNOWN_STAGES.add(stageName);
                            continue;
                        }
                        GameStages.LOG.error("Rejected an invalid stage name of {}. It will not be usable. Stage names must be under 64 characters and may only include alphanumeric characters, underscores, and colons.", (Object)stageName);
                    }
                } else {
                    GameStages.LOG.error("Your known stages file is incorrect! The file must be a string array!");
                }
                GameStages.LOG.debug("Loaded {} known stages.", (Object)KNOWN_STAGES.size());
            }
            catch (Exception e) {
                GameStages.LOG.error("Could not read {}.", (Object)KNOWN_STAGES_FILE.getName());
                GameStages.LOG.catching((Throwable)e);
            }
        }
    }

    public static boolean hasFakePlayer(String fakePlayerName) {
        return FAKE_STAGE_DATA.containsKey(fakePlayerName);
    }

    public static void addFakePlayer(FakePlayerData data) {
        FAKE_STAGE_DATA.put(data.getFakePlayerName(), data);
        GameStages.LOG.debug("Adding fakeplayer {} with gamestages {}", (Object)data.getFakePlayerName(), data.getStages());
    }

    public static void removeFakePlayer(String fakePlayerName) {
        FakePlayerData removedData = FAKE_STAGE_DATA.remove(fakePlayerName);
        if (removedData != null) {
            GameStages.LOG.debug("Removing fakeplayer {} with gamestages {}", (Object)fakePlayerName, removedData.getStages());
        }
    }

    public static IStageData getFakeData(String fakePlayerName) {
        return FAKE_STAGE_DATA.getOrDefault(fakePlayerName, FakePlayerData.DEFAULT);
    }

    public static Set<String> getKnownStages() {
        return KNOWN_STAGES;
    }

    public static boolean isStageKnown(String stage) {
        return KNOWN_STAGES.contains(stage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static IStageData getClientData() {
        return clientData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setClientData(IStageData stageData) {
        clientData = stageData;
    }
}

