/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.stream.Collectors;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.command.StageArgumentType;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class GameStageCommands {
    public static void initializeCommands() {
        MinecraftForge.EVENT_BUS.addListener(GameStageCommands::registerCommands);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(GameStageCommands::registerArguments);
    }

    private static void registerCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = Commands.m_82127_((String)"gamestage");
        root.then(GameStageCommands.createSilentStageCommand("add", 2, (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, true)), (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, true))));
        root.then(GameStageCommands.createSilentStageCommand("remove", 2, (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, false, false)), (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.changeStages((CommandContext<CommandSourceStack>)ctx, true, false))));
        root.then(GameStageCommands.createPlayerCommand("info", 0, (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.getStageInfo((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.getStageInfo((CommandContext<CommandSourceStack>)ctx, false))));
        root.then(GameStageCommands.createPlayerCommand("clear", 2, (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.clearStages((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.clearStages((CommandContext<CommandSourceStack>)ctx, false))));
        root.then(GameStageCommands.createPlayerCommand("all", 2, (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.grantAll((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.grantAll((CommandContext<CommandSourceStack>)ctx, false))));
        root.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(sender -> sender.m_6761_(2))).executes(GameStageCommands::reloadGameStages));
        root.then(GameStageCommands.createPlayerStageCommand("check", 2, (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.checkStage((CommandContext<CommandSourceStack>)ctx, true)), (Command<CommandSourceStack>)((Command)ctx -> GameStageCommands.checkStage((CommandContext<CommandSourceStack>)ctx, false))));
        event.getDispatcher().register(root);
    }

    private static void registerArguments(FMLCommonSetupEvent event) {
        ArgumentTypes.m_121601_((String)"stagename", StageArgumentType.class, StageArgumentType.SERIALIZERS);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createPlayerCommand(String key, int permissions, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).executes(commandNoPlayer)).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(command));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createSilentStageCommand(String key, int permissions, Command<CommandSourceStack> command, Command<CommandSourceStack> silent) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)).then(Commands.m_82129_((String)"silent", (ArgumentType)BoolArgumentType.bool()).executes(silent))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createPlayerStageCommand(String key, int permissions, Command<CommandSourceStack> command, Command<CommandSourceStack> commandNoPlayer) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)key).requires(sender -> sender.m_6761_(permissions))).then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(commandNoPlayer))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"stage", (ArgumentType)new StageArgumentType()).executes(command)));
    }

    private static int grantAll(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        if (hasPlayer) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
                GameStageCommands.grantAll(ctx, player);
            }
        } else {
            GameStageCommands.grantAll(ctx, ((CommandSourceStack)ctx.getSource()).m_81375_());
        }
        return 0;
    }

    private static void grantAll(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        for (String knownStage : GameStageHelper.getKnownStages()) {
            GameStageHelper.addStage(player, knownStage);
        }
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.all.target"), true);
        if (player != ((CommandSourceStack)ctx.getSource()).m_81373_()) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.all.sender", new Object[]{player.m_5446_()}), true);
        }
    }

    private static int clearStages(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        if (hasPlayer) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
                GameStageCommands.clearStages(ctx, player);
            }
        } else {
            GameStageCommands.clearStages(ctx, ((CommandSourceStack)ctx.getSource()).m_81375_());
        }
        return 0;
    }

    private static void clearStages(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        int removedStages = GameStageHelper.clearStages(player);
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.clear.target", new Object[]{removedStages}), true);
        if (player != ((CommandSourceStack)ctx.getSource()).m_81373_()) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.clear.sender", new Object[]{removedStages, player.m_5446_()}), true);
        }
    }

    private static int checkStage(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        if (hasPlayer) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
                GameStageCommands.checkStage(ctx, player);
            }
        } else {
            GameStageCommands.checkStage(ctx, ((CommandSourceStack)ctx.getSource()).m_81375_());
        }
        return 0;
    }

    private static boolean checkStage(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        String stage = StageArgumentType.getStage(ctx, "stage");
        boolean hasStage = GameStageHelper.hasStage((Player)player, stage);
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent(hasStage ? "commands.gamestage.check.success" : "commands.gamestage.check.failure", new Object[]{player.m_5446_(), stage}), false);
        return hasStage;
    }

    private static int reloadGameStages(CommandContext<CommandSourceStack> ctx) {
        GameStageSaveHandler.reloadFakePlayers();
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.reloadfakes.info"), true);
        GameStageSaveHandler.reloadKnownStages();
        ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.reloadknown.info", new Object[]{GameStageSaveHandler.getKnownStages().size()}), true);
        return 0;
    }

    private static int getStageInfo(CommandContext<CommandSourceStack> ctx, boolean hasPlayer) throws CommandSyntaxException {
        if (hasPlayer) {
            for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
                GameStageCommands.getStageInfo(ctx, player);
            }
        } else {
            GameStageCommands.getStageInfo(ctx, ((CommandSourceStack)ctx.getSource()).m_81375_());
        }
        return 0;
    }

    private static void getStageInfo(CommandContext<CommandSourceStack> ctx, ServerPlayer player) {
        String stageInfo = GameStageHelper.getPlayerData((Player)player).getStages().stream().map(Object::toString).collect(Collectors.joining(", "));
        if (stageInfo.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.info.empty", new Object[]{player.m_5446_()}), false);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("commands.gamestage.info.stages", new Object[]{player.m_5446_(), stageInfo}), false);
        }
    }

    private static int changeStages(CommandContext<CommandSourceStack> ctx, boolean silent, boolean adding) throws CommandSyntaxException {
        String stageName = StageArgumentType.getStage(ctx, "stage");
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"targets")) {
            if (adding) {
                GameStageHelper.addStage(player, stageName);
            } else {
                GameStageHelper.removeStage(player, stageName);
            }
            if (silent && BoolArgumentType.getBool(ctx, (String)"silent")) continue;
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent(adding ? "commands.gamestage.add.target" : "commands.gamestage.remove.target", new Object[]{stageName}), true);
            if (player == ((CommandSourceStack)ctx.getSource()).m_81373_()) continue;
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent(adding ? "commands.gamestage.add.sender" : "commands.gamestage.remove.sender", new Object[]{stageName, player.m_5446_()}), true);
        }
        return 0;
    }
}

