/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.terralith.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.stardustlabs.terralith.Terralith;
import net.stardustlabs.terralith.TerralithExpectPlatform;
import net.stardustlabs.terralith.config.TerralithConfig;
import net.stardustlabs.terralith.utils.Util;

public class ConfigUtil {
    public static final Path TERRALITH_CONFIG_DIR = TerralithExpectPlatform.getConfigDirectory().resolve("terralith");
    public static final Path OLD_FILE_PATH = TERRALITH_CONFIG_DIR.resolve("config.json");
    public static final Path FILE_PATH = TERRALITH_CONFIG_DIR.resolve("terralith.toml");
    public static final Path README_PATH = TERRALITH_CONFIG_DIR.resolve("README.txt");
    public static final String MODE_NAME = "terrablender_compatibility";
    public static final String CURSED_NAME = "cursed_skylands";
    public static TerralithConfig CONFIG;

    public static void createConfig() {
        try {
            Util.createDirectoriesSafe(TERRALITH_CONFIG_DIR);
        }
        catch (IOException e) {
            Terralith.LOGGER.error("Couldn't create directories", (Throwable)e);
        }
        if (README_PATH.toFile().exists()) {
            README_PATH.toFile().delete();
        }
        boolean mode_value = true;
        String cursed_value = "none";
        if (OLD_FILE_PATH.toFile().exists()) {
            mode_value = ConfigUtil.readConfigMode(OLD_FILE_PATH);
            cursed_value = ConfigUtil.readConfigCursed(OLD_FILE_PATH);
            OLD_FILE_PATH.toFile().delete();
            Terralith.LOGGER.info("Detected old json config file. Migrating to toml...");
        } else {
            Terralith.LOGGER.info("No config file detected. Creating one...");
        }
        CONFIG = new TerralithConfig(FILE_PATH, mode_value, cursed_value);
    }

    public static boolean readConfigMode() {
        if (CONFIG != null) {
            return ConfigUtil.CONFIG.terrablenderCompatibility;
        }
        return ConfigUtil.readConfigMode(FILE_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readConfigMode(Path filepath) {
        try (InputStream in = Files.newInputStream(filepath, new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(in);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (!(jsonElement instanceof JsonObject)) return false;
            JsonObject o = (JsonObject)jsonElement;
            JsonElement element = o.get(MODE_NAME);
            if (!(element instanceof JsonPrimitive)) return false;
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (!primitive.isBoolean()) return false;
            boolean bl = element.getAsBoolean();
            return bl;
        }
        catch (IOException e) {
            Terralith.LOGGER.error("Couldn't read " + filepath, (Throwable)e);
        }
        return false;
    }

    public static String readConfigCursed() {
        if (CONFIG != null) {
            return ConfigUtil.CONFIG.cursedSkylands;
        }
        return ConfigUtil.readConfigCursed(FILE_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readConfigCursed(Path filepath) {
        try (InputStream in = Files.newInputStream(filepath, new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(in);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (!(jsonElement instanceof JsonObject)) return "none";
            JsonObject o = (JsonObject)jsonElement;
            JsonElement element = o.get(CURSED_NAME);
            if (!(element instanceof JsonPrimitive)) return "none";
            JsonPrimitive primitive = (JsonPrimitive)element;
            if (!primitive.isString()) return "none";
            String string = element.getAsString();
            return string;
        }
        catch (IOException e) {
            Terralith.LOGGER.error("Couldn't read " + filepath, (Throwable)e);
        }
        return "none";
    }
}

