/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.terralith.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;

public class Config {
    private final CommentedConfig config;

    public Config(CommentedConfig config) {
        this.config = config;
    }

    public <T> List<T> addList(String comment, String key, List<T> defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            this.config.setComment(key, comment);
        }
        return (List)this.config.get(key);
    }

    public Config addSubConfig(String comment, String key, Config defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, (Object)Config.sortConfig(defaultValue.config));
        }
        CommentedConfig subConfig = (CommentedConfig)this.config.get(key);
        String commentValue = this.config.getComment(key);
        if (commentValue == null) {
            this.config.setComment(key, comment);
        }
        return new Config(subConfig);
    }

    public Map<?, ?> addMap(String comment, String key, Map<?, Number> defaultValue) {
        CommentedConfig subConfig;
        if (this.config.get(key) == null) {
            subConfig = this.config.createSubConfig();
            defaultValue.forEach((a, b) -> {
                String subConfigKey = a.toString();
                if (subConfig.get(a.toString()) == null) {
                    subConfig.set(subConfigKey, b);
                }
            });
            this.config.set(key, (Object)subConfig);
        }
        subConfig = (CommentedConfig)this.config.get(key);
        String commentValue = this.config.getComment(key);
        if (commentValue == null) {
            this.config.setComment(key, comment);
        }
        return subConfig.valueMap();
    }

    public <T> T add(String comment, String key, T defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            this.config.setComment(key, comment);
        }
        return (T)this.config.get(key);
    }

    public <T extends Number> T addNumber(String comment, String key, T defaultValue, T min, T max) {
        Number value;
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            this.config.setComment(key, comment + String.format("\nRange: %s-%s", min, max));
        }
        return (T)(((Comparable)((Object)(value = (Number)this.config.get(key)))).compareTo(max) > 0 ? max : (((Comparable)((Object)value)).compareTo(min) < 0 ? min : value));
    }

    public <T extends Boolean> T addBool(String comment, String key, T defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            this.config.setComment(key, comment + "\nOptions: true, false");
        }
        return (T)((Boolean)this.config.get(key));
    }

    public <T extends Enum<T>> T addEnum(String comment, String key, T defaultValue) {
        if (this.config.get(key) == null) {
            this.config.set(key, defaultValue);
        }
        if (this.config.getComment(key) == null) {
            StringBuilder builder = new StringBuilder().append("Values: ").append(defaultValue instanceof StringRepresentable ? "\n" : "");
            for (Enum value : (Enum[])defaultValue.getDeclaringClass().getEnumConstants()) {
                if (defaultValue instanceof StringRepresentable) {
                    builder.append(((StringRepresentable)value).m_7912_()).append("\n");
                    continue;
                }
                builder.append(value.name()).append(", ");
            }
            this.config.setComment(key, comment + "\n" + builder);
        }
        String value = this.config.get(key).toString();
        return Enum.valueOf(defaultValue.getDeclaringClass(), value);
    }

    public <T> T getValue(String key) {
        return (T)this.config.get(key);
    }

    public Config getSubConfig(String key) {
        CommentedConfig sub = (CommentedConfig)this.config.get(key);
        return new Config(sub != null ? sub : CommentedConfig.inMemory());
    }

    protected CommentedConfig getConfig() {
        return this.config;
    }

    protected static CommentedConfig sortConfig(CommentedConfig config) {
        CommentedConfig newConfig = CommentedConfig.of((Supplier)com.electronwill.nightconfig.core.Config.getDefaultMapCreator((boolean)false, (boolean)true), (ConfigFormat)TomlFormat.instance());
        List<Map.Entry> organizedCollection = config.valueMap().entrySet().stream().sorted(Comparator.comparing(Objects::toString)).toList();
        organizedCollection.forEach(stringObjectEntry -> newConfig.add((String)stringObjectEntry.getKey(), stringObjectEntry.getValue()));
        newConfig.commentMap().putAll(config.commentMap());
        return newConfig;
    }
}

