/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.utils;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.ServerPlayerMovement;
import tictim.paraglider.contents.Contents;

public final class ParagliderUtils {
    private ParagliderUtils() {
    }

    public static void giveItem(Player player, ItemStack stack) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        while (!stack.m_41619_()) {
            int slot = player.m_150109_().m_36050_(stack);
            if (slot == -1) {
                slot = player.m_150109_().m_36062_();
            }
            if (slot == -1) {
                while (!stack.m_41619_()) {
                    ItemEntity itemEntity = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), stack.m_41620_(stack.m_41741_()));
                    itemEntity.m_32010_(40);
                    itemEntity.m_20334_(0.0, 0.0, 0.0);
                    player.f_19853_.m_7967_((Entity)itemEntity);
                }
                break;
            }
            int count = stack.m_41741_() - player.m_150109_().m_8020_(slot).m_41613_();
            if (!player.m_150109_().m_36040_(slot, stack.m_41620_(count))) continue;
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, slot, player.m_150109_().m_8020_(slot)));
        }
    }

    public static boolean takeHeartContainers(Player player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (m.getHeartContainers() < quantity) {
            return false;
        }
        if (!simulate && !player.f_19853_.f_46443_) {
            m.setHeartContainers(m.getHeartContainers() - quantity);
        }
        return true;
    }

    public static boolean takeStaminaVessels(Player player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (m.getStaminaVessels() < quantity) {
            return false;
        }
        if (!simulate && !player.f_19853_.f_46443_) {
            m.setStaminaVessels(m.getStaminaVessels() - quantity);
        }
        return true;
    }

    public static boolean takeEssences(Player player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (m.getEssence() < quantity) {
            return false;
        }
        if (!simulate && !player.f_19853_.f_46443_) {
            m.setEssence(m.getEssence() - quantity);
        }
        return true;
    }

    public static boolean giveHeartContainers(Player player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement playerMovement = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (playerMovement == null) {
            return false;
        }
        if (ModCfg.maxHeartContainers() - playerMovement.getHeartContainers() < quantity) {
            return false;
        }
        if (!simulate && !player.f_19853_.f_46443_) {
            playerMovement.setHeartContainers(playerMovement.getHeartContainers() + quantity);
            player.m_21153_(player.m_21233_());
            if (effect) {
                ParagliderUtils.spawnParticle(player, (ParticleOptions)ParticleTypes.f_123750_, 5 + 5 * quantity);
            }
        }
        return true;
    }

    public static boolean giveStaminaVessels(Player player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (ModCfg.maxStaminaVessels() - m.getStaminaVessels() < quantity) {
            return false;
        }
        if (!simulate && !player.f_19853_.f_46443_) {
            m.setStaminaVessels(m.getStaminaVessels() + quantity);
            m.setStamina(m.getDoubleMaxStamina());
            if (effect) {
                ParagliderUtils.spawnParticle(player, (ParticleOptions)ParticleTypes.f_123748_, 7 + 7 * quantity);
            }
        }
        return true;
    }

    public static boolean giveEssences(Player player, int quantity, boolean simulate, boolean effect) {
        if (quantity <= 0) {
            return true;
        }
        ServerPlayerMovement m = ServerPlayerMovement.of((ICapabilityProvider)player);
        if (m == null) {
            return false;
        }
        if (Integer.MAX_VALUE - m.getEssence() < quantity) {
            return false;
        }
        if (!simulate && !player.f_19853_.f_46443_) {
            m.setEssence(m.getEssence() + quantity);
        }
        return true;
    }

    private static void spawnParticle(Player player, ParticleOptions particle, int count) {
        ServerLevel world;
        ServerLevel serverLevel = world = player.f_19853_ instanceof ServerLevel ? (ServerLevel)player.f_19853_ : null;
        if (world == null) {
            return;
        }
        world.m_8767_(particle, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), count, 1.0, 2.0, 1.0, 0.0);
    }

    @Nullable
    public static Item getAppropriateVessel() {
        return ModCfg.enableHeartContainers() ? (Item)Contents.HEART_CONTAINER.get() : (ModCfg.enableSpiritOrbGens() ? (Item)Contents.SPIRIT_ORB.get() : null);
    }
}

