/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.recipe.bargain;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class BargainResult {
    private final Set<FailedReason> failedReasons;

    public static BargainResult success() {
        return new BargainResult(Collections.emptySet());
    }

    public static BargainResult failure(FailedReason ... reasons) {
        HashSet<FailedReason> set = new HashSet<FailedReason>();
        Collections.addAll(set, reasons);
        return new BargainResult(set);
    }

    public static BargainResult result(Set<FailedReason> reasons) {
        return new BargainResult(reasons);
    }

    private BargainResult(Set<FailedReason> failedReasons) {
        this.failedReasons = failedReasons;
    }

    public boolean isSuccess() {
        return this.failedReasons.isEmpty();
    }

    public Set<FailedReason> getFailureReasons() {
        return this.failedReasons;
    }

    public boolean has(FailedReason reason) {
        return this.failedReasons.contains((Object)reason);
    }

    public String toString() {
        return "BargainResult{failedReasons=" + this.failedReasons + "}";
    }

    public static enum FailedReason {
        NOT_ENOUGH_ITEMS,
        NOT_ENOUGH_HEART,
        NOT_ENOUGH_STAMINA,
        NOT_ENOUGH_ESSENCE,
        HEART_FULL,
        STAMINA_FULL,
        ESSENCE_FULL,
        OTHER;

    }
}

