/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.loot;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import tictim.paraglider.ModCfg;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.item.ParagliderItem;

public class ParagliderModifier
extends LootModifier {
    public final boolean dekuLeaf;

    public ParagliderModifier(LootItemCondition[] conditionsIn) {
        this(conditionsIn, false);
    }

    public ParagliderModifier(LootItemCondition[] conditionsIn, boolean dekuLeaf) {
        super(conditionsIn);
        this.dekuLeaf = dekuLeaf;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        ConfigOption configOption = ModCfg.paragliderInTowersOfTheWild();
        if (configOption != ConfigOption.DISABLE) {
            ParagliderItem item = (ParagliderItem)((Object)(configOption == ConfigOption.DEKU_LEAF_ONLY || configOption != ConfigOption.PARAGLIDER_ONLY && this.dekuLeaf ? Contents.DEKU_LEAF : Contents.PARAGLIDER).get());
            ItemStack stack = new ItemStack((ItemLike)item);
            if (context.m_78933_().nextBoolean()) {
                stack = DyeableLeatherItem.m_41118_((ItemStack)stack, Arrays.asList(DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)context.m_78933_().nextInt(16))), DyeItem.m_41082_((DyeColor)DyeColor.m_41053_((int)context.m_78933_().nextInt(16)))));
            }
            generatedLoot.add(stack);
        }
        return generatedLoot;
    }

    public static enum ConfigOption {
        DEFAULT,
        DISABLE,
        PARAGLIDER_ONLY,
        DEKU_LEAF_ONLY;

    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ParagliderModifier> {
        public ParagliderModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            return new ParagliderModifier(lootConditions, object.get("dekuLeaf").getAsBoolean());
        }

        public JsonObject write(ParagliderModifier instance) {
            JsonObject jsonObject = this.makeConditions(instance.conditions);
            jsonObject.addProperty("dekuLeaf", Boolean.valueOf(instance.dekuLeaf));
            return jsonObject;
        }
    }
}

