/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.client.BargainScreenStaminaWheelRenderer;
import tictim.paraglider.client.DisableStaminaRender;
import tictim.paraglider.client.StaminaWheelRenderer;
import tictim.paraglider.network.BargainMsg;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.recipe.bargain.BargainPreview;
import tictim.paraglider.recipe.bargain.StatueBargain;
import tictim.paraglider.recipe.bargain.StatueBargainContainer;
import tictim.paraglider.utils.TooltipFactory;

public class StatueBargainScreen
extends AbstractContainerScreen<StatueBargainContainer>
implements DisableStaminaRender {
    private static final ResourceLocation MERCHANT_GUI_TEXTURE = new ResourceLocation("textures/gui/container/villager2.png");
    private static final long ITEM_CYCLE_TIME = 1000L;
    private static final long DIALOG_FADEOUT_START = 1750L;
    private static final long DIALOG_FADEOUT_END = 2000L;
    private static final int SCROLL_BOX_THING_WIDTH = 97;
    private static final int SCROLL_BOX_THING_HEIGHT = 142;
    private final BargainButton[] buttons = new BargainButton[7];
    private int buttonIndexOffset;
    private boolean isDragging;
    private long createdTime;
    private long currentTickTimestamp;
    @Nullable
    private Component dialog;
    private long dialogTimestamp;
    private boolean dialogUpdated;
    private StaminaWheelRenderer staminaWheelRenderer;
    private static final int BUTTON_INPUT_X_OFFSET_START = 2;
    private static final int BUTTON_INPUT_X_OFFSET_END = 22;
    private static final int BUTTON_OUTPUT_X_OFFSET_START = 50;
    private static final int BUTTON_OUTPUT_X_OFFSET_END = 70;

    public StatueBargainScreen(StatueBargainContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void m_7856_() {
        this.f_97726_ = this.f_96543_;
        this.f_97727_ = this.f_96544_;
        this.currentTickTimestamp = this.createdTime = System.currentTimeMillis();
        PlayerMovement m = PlayerMovement.of((ICapabilityProvider)this.f_96541_.f_91074_);
        this.staminaWheelRenderer = new BargainScreenStaminaWheelRenderer(m == null ? 0.0 : m.getDoubleMaxStamina());
        super.m_7856_();
        int y = this.getTop() + 1;
        for (int i = 0; i < 7; ++i) {
            this.buttons[i] = (BargainButton)this.m_142416_((GuiEventListener)new BargainButton(31, y + 20 * i, i));
        }
    }

    public int getLeft() {
        return 30;
    }

    public int getTop() {
        return (this.f_96544_ - 142) / 2;
    }

    public int getBottom() {
        return this.getTop() + 142;
    }

    public void setDialog(@Nullable Component dialog) {
        this.dialog = dialog;
        this.dialogUpdated = dialog != null;
    }

    private void renderScroller(PoseStack matrixStack, int left, int top) {
        int yOffset;
        int offScreenBargains = ((StatueBargainContainer)this.f_97732_).getBargains().size() + 1 - 7;
        if (offScreenBargains > 1) {
            int j = 139 - (27 + (offScreenBargains - 1) * 139 / offScreenBargains);
            int k = 1 + j / offScreenBargains + 139 / offScreenBargains;
            yOffset = Math.min(113, this.buttonIndexOffset * k);
            if (this.buttonIndexOffset == offScreenBargains - 1) {
                yOffset = 113;
            }
        } else {
            yOffset = 0;
        }
        StatueBargainScreen.m_93143_((PoseStack)matrixStack, (int)(left + 90), (int)(top + 1 + yOffset), (int)this.m_93252_(), (float)0.0f, (float)199.0f, (int)6, (int)27, (int)512, (int)256);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        long newTimestamp = System.currentTimeMillis();
        if (StatueBargainScreen.m_96638_()) {
            this.createdTime += newTimestamp - this.currentTickTimestamp;
        }
        this.currentTickTimestamp = newTimestamp;
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
        this.lookAtStatue(partialTicks);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        List<StatueBargain> bargains;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MERCHANT_GUI_TEXTURE);
        StatueBargainScreen.m_93143_((PoseStack)matrixStack, (int)this.getLeft(), (int)this.getTop(), (int)this.m_93252_(), (float)4.0f, (float)17.0f, (int)97, (int)142, (int)512, (int)256);
        this.staminaWheelRenderer.renderStamina(matrixStack, this.getLeft() + 97 + 5, this.getTop() - 5 - 10, 0.0);
        if (this.dialog != null) {
            long t;
            int alpha;
            if (this.dialogUpdated) {
                this.dialogTimestamp = this.currentTickTimestamp;
                this.dialogUpdated = false;
            }
            if ((alpha = (t = this.currentTickTimestamp - this.dialogTimestamp) >= 2000L ? 0 : (t <= 1750L ? 255 : Mth.m_14045_((int)((int)((2000L - t) * 255L / 250L)), (int)0, (int)255))) > 4) {
                StatueBargainScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.dialog, (int)(this.f_96543_ / 2), (int)(this.getBottom() + 9), (int)(alpha << 24 | 0xFFFFFF));
            }
        }
        if (!(bargains = ((StatueBargainContainer)this.f_97732_).getBargains()).isEmpty()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)MERCHANT_GUI_TEXTURE);
            this.renderScroller(matrixStack, this.getLeft(), this.getTop());
            this.f_96542_.f_115093_ = 100.0f;
            for (BargainButton button : this.buttons) {
                button.renderItems();
            }
            this.f_96542_.f_115093_ = 0.0f;
            for (BargainButton button : this.buttons) {
                if (button.m_198029_()) {
                    this.renderPreview(button.getActualIndex());
                }
                button.f_93624_ = button.index < ((StatueBargainContainer)this.f_97732_).getBargains().size();
            }
            RenderSystem.m_69482_();
        }
    }

    protected void m_7025_(PoseStack poseStack, int x, int y) {
        for (BargainButton button : this.buttons) {
            button.m_7428_(poseStack, x, y);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
    }

    public void m_96558_(PoseStack matrixStack, int vOffset) {
        if (this.f_96541_.f_91073_ != null) {
            this.m_93179_(matrixStack, 0, 0, this.f_96543_, this.f_96544_, 0x70101010, -1609560048);
            MinecraftForge.EVENT_BUS.post((Event)new ScreenEvent.BackgroundDrawnEvent((Screen)this, matrixStack));
        } else {
            this.m_96626_(vOffset);
        }
    }

    private void renderPreview(int bargainIndex) {
        int textMag;
        StatueBargainContainer.ItemDemand[] demands = ((StatueBargainContainer)this.f_97732_).getDemandPreview(bargainIndex);
        if (demands.length == 0) {
            return;
        }
        int mag = demands.length <= 2 ? 8 : (demands.length <= 8 ? 4 : 2);
        int n = textMag = demands.length <= 8 ? 2 : 1;
        int rows = demands.length <= 2 ? 2 : (demands.length <= 8 ? 4 : 8);
        int left = this.getLeft() + 97 + 20;
        int top = this.getTop();
        for (int i = 0; i < demands.length; ++i) {
            StatueBargainContainer.ItemDemand demand = demands[i];
            int xOff = left + i % rows * (16 * mag);
            int yOff = top + i / rows * (16 * mag);
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_85837_((double)xOff, (double)yOff, 0.0);
            modelViewStack.m_85841_((float)mag, (float)mag, 1.0f);
            RenderSystem.m_157182_();
            this.f_96542_.m_115218_(this.cycle(demand.getPreviewItems()), 0, 0);
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
            String s = (Serializable)(demand.getCount() >= demand.getQuantity() ? Integer.valueOf(demand.getCount()) : "" + ChatFormatting.RED + demand.getCount() + ChatFormatting.RESET) + "/" + demand.getQuantity();
            PoseStack pose = new PoseStack();
            pose.m_85837_((double)xOff, (double)yOff, 0.0);
            pose.m_85837_((double)(15 * mag + 2 * textMag), (double)(16 * mag - 7 * textMag), (double)(this.f_96542_.f_115093_ + 200.0f));
            pose.m_85841_((float)textMag, (float)textMag, 1.0f);
            StatueBargainScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)s, (int)(-this.f_96547_.m_92895_(s)), (int)0, (int)-1);
        }
    }

    private void lookAtStatue(float partialTicks) {
        Vec3 lookAt = ((StatueBargainContainer)this.f_97732_).getLookAt();
        if (lookAt == null) {
            return;
        }
        LocalPlayer player = this.f_96541_.f_91074_;
        Vec3 eyePosition = player.m_20299_(partialTicks);
        double lookX = lookAt.m_7096_() - eyePosition.f_82479_;
        double lookY = lookAt.m_7098_() - eyePosition.f_82480_;
        double lookZ = lookAt.m_7094_() - eyePosition.f_82481_;
        double xzLength = Math.sqrt(lookX * lookX + lookZ * lookZ);
        double rotationPitch = Mth.m_14177_((float)((float)(-Mth.m_14136_((double)lookY, (double)xzLength) * 57.29577951308232)));
        double rotationYaw = Mth.m_14177_((float)((float)(Mth.m_14136_((double)lookZ, (double)lookX) * 57.29577951308232) - 90.0f));
        double lerpPercentage = (double)partialTicks * 0.3;
        player.m_146926_(StatueBargainScreen.lerpAngle(lerpPercentage, Mth.m_14177_((float)player.m_146909_()), rotationPitch));
        player.m_146922_(StatueBargainScreen.lerpAngle(lerpPercentage, Mth.m_14177_((float)player.m_146908_()), rotationYaw));
        player.m_5616_(player.m_146908_());
        player.f_19860_ = player.m_146909_();
        player.f_19859_ = player.m_146908_();
        player.f_20886_ = player.f_20885_;
        player.f_20884_ = player.f_20883_ = player.f_20885_;
    }

    private static float lerpAngle(double percentage, double start, double end) {
        return (float)Mth.m_14139_((double)percentage, (double)(start < end ? (end - start > 180.0 ? start + 360.0 : start) : (start - end > 180.0 ? start - 360.0 : start)), (double)end);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int bargainSize = ((StatueBargainContainer)this.f_97732_).getBargains().size();
        if (bargainSize > 7) {
            this.buttonIndexOffset = Mth.m_14045_((int)((int)((double)this.buttonIndexOffset - delta)), (int)0, (int)(bargainSize - 7));
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDragging) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        int offScreenBargains = ((StatueBargainContainer)this.f_97732_).getBargains().size() - 7;
        this.buttonIndexOffset = Mth.m_14045_((int)((int)((mouseY - (double)this.getTop() + 1.0 - 13.5) / 112.0 * (double)offScreenBargains + 0.5)), (int)0, (int)offScreenBargains);
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int left = this.getLeft();
        int top = this.getTop();
        if (((StatueBargainContainer)this.f_97732_).getBargains().size() > 7 && mouseX > (double)(left + 90) && mouseX < (double)(left + 90 + 6) && mouseY > (double)(top + 1) && mouseY <= (double)(top + 1 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private ItemStack cycle(ItemStack[] stacks) {
        if (stacks.length == 0) {
            return ItemStack.f_41583_;
        }
        return stacks[(int)(Math.abs(this.currentTickTimestamp - this.createdTime) / 1000L % (long)stacks.length)];
    }

    private static int determinePosition(int n, int length, int start, int end) {
        if (n >= length) {
            throw new IllegalArgumentException("length");
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start");
        }
        if (length == 1) {
            return (start + end) / 2;
        }
        int span = end - start;
        int spanPerElement = Math.min(16, span / (length - 1));
        if (spanPerElement == 0) {
            return start - (length - 1 - span) / 2 + n;
        }
        int leftover = span % spanPerElement;
        return start + leftover / 2 + spanPerElement * n;
    }

    private final class BargainButton
    extends AbstractButton {
        private final int index;

        public BargainButton(int x, int y, int index) {
            super(x, y, 89, 20, TextComponent.f_131282_);
            this.index = index;
            this.f_93624_ = false;
        }

        public void m_5691_() {
            StatueBargain bargain = this.getBargain();
            if (bargain != null) {
                ModNet.NET.sendToServer((Object)new BargainMsg(bargain.m_6423_()));
            }
        }

        public int getIndex() {
            return this.index;
        }

        public int getActualIndex() {
            return this.index + StatueBargainScreen.this.buttonIndexOffset;
        }

        @Nullable
        public StatueBargain getBargain() {
            return ((StatueBargainContainer)StatueBargainScreen.this.f_97732_).getBargain(this.getActualIndex());
        }

        protected int m_7202_(boolean isHovered) {
            return !((StatueBargainContainer)StatueBargainScreen.this.f_97732_).canBargain(this.getActualIndex()) ? 0 : (isHovered ? 2 : 1);
        }

        protected void m_7906_(PoseStack pose, Minecraft mc, int mouseX, int mouseY) {
            RenderSystem.m_69478_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)MERCHANT_GUI_TEXTURE);
            BargainButton.m_93143_((PoseStack)pose, (int)(this.f_93620_ + 39), (int)(this.f_93621_ + 5), (int)this.m_93252_(), (float)(((StatueBargainContainer)StatueBargainScreen.this.f_97732_).canBargain(this.getActualIndex()) ? 15.0f : 25.0f), (float)171.0f, (int)10, (int)9, (int)512, (int)256);
        }

        public void renderItems() {
            int itemX;
            ItemStack stack;
            if (!this.f_93624_) {
                return;
            }
            StatueBargain bargain = this.getBargain();
            if (bargain == null) {
                return;
            }
            BargainPreview preview = bargain.getPreview();
            int buttonElementTop = this.f_93621_ + 2;
            List<BargainPreview.Demand> demands = preview.demands();
            for (int i = demands.size() - 1; i >= 0; --i) {
                BargainPreview.Demand demand = demands.get(i);
                ItemStack[] stacks = demand.getPreviewItems();
                if (stacks.length == 0) {
                    ParagliderMod.LOGGER.warn("Some of ItemDemandPreview has empty array of items.");
                    continue;
                }
                stack = StatueBargainScreen.this.cycle(stacks);
                if (stack.m_41619_()) {
                    ParagliderMod.LOGGER.warn("Some of ItemDemandPreview has empty items.");
                    continue;
                }
                itemX = this.f_93620_ + StatueBargainScreen.determinePosition(i, demands.size(), 2, 22);
                StatueBargainScreen.this.f_96542_.m_115218_(stack, itemX, buttonElementTop);
                if (demand.getQuantity() == 1) continue;
                StatueBargainScreen.this.f_96542_.m_115174_(StatueBargainScreen.this.f_96547_, stack, itemX, buttonElementTop, String.valueOf(demand.getQuantity()));
            }
            List<BargainPreview.Offer> offers = preview.offers();
            for (int i = offers.size() - 1; i >= 0; --i) {
                BargainPreview.Offer offer = offers.get(i);
                stack = offer.getPreview();
                if (stack.m_41619_()) {
                    ParagliderMod.LOGGER.warn("Some of ItemOfferPreview has empty item.");
                    continue;
                }
                itemX = this.f_93620_ + StatueBargainScreen.determinePosition(i, offers.size(), 50, 70);
                StatueBargainScreen.this.f_96542_.m_115218_(stack, itemX, buttonElementTop);
                if (offer.getQuantity() == 1) continue;
                StatueBargainScreen.this.f_96542_.m_115174_(StatueBargainScreen.this.f_96547_, stack, itemX, buttonElementTop, String.valueOf(offer.getQuantity()));
            }
        }

        public void m_7428_(PoseStack matrixStack, int mouseX, int mouseY) {
            if (!this.f_93622_) {
                return;
            }
            StatueBargain bargain = this.getBargain();
            if (bargain == null) {
                return;
            }
            BargainPreview preview = bargain.getPreview();
            List<BargainPreview.Demand> demands = preview.demands();
            BargainPreview.Demand closestDemand = null;
            int closestDemandDistance = Integer.MAX_VALUE;
            for (int i = 0; i < demands.size(); ++i) {
                int itemX = this.f_93620_ + StatueBargainScreen.determinePosition(i, demands.size(), 2, 22);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestDemandDistance <= dist) break;
                closestDemandDistance = dist;
                closestDemand = demands.get(i);
            }
            if (closestDemand != null) {
                TooltipFactory tf = closestDemand.getTooltipFactory();
                if (tf != null) {
                    StatueBargainScreen.this.m_96597_(matrixStack, tf.getTooltip(), mouseX, mouseY);
                } else {
                    StatueBargainScreen.this.m_6057_(matrixStack, StatueBargainScreen.this.cycle(closestDemand.getPreviewItems()), mouseX, mouseY);
                }
                return;
            }
            List<BargainPreview.Offer> offers = preview.offers();
            BargainPreview.Offer closestOffer = null;
            int closestOfferDistance = Integer.MAX_VALUE;
            for (int i = 0; i < offers.size(); ++i) {
                int itemX = this.f_93620_ + StatueBargainScreen.determinePosition(i, offers.size(), 50, 70);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestOfferDistance <= dist) break;
                closestOfferDistance = dist;
                closestOffer = offers.get(i);
            }
            if (closestOffer != null) {
                TooltipFactory tf = closestOffer.getTooltipFactory();
                if (tf != null) {
                    StatueBargainScreen.this.m_96597_(matrixStack, tf.getTooltip(), mouseX, mouseY);
                } else {
                    StatueBargainScreen.this.m_6057_(matrixStack, closestOffer.getPreview(), mouseX, mouseY);
                }
            }
        }

        public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
        }
    }
}

