/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import tictim.paraglider.ModCfg;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.client.StaminaWheelConstants;
import tictim.paraglider.client.StaminaWheelRenderer;
import tictim.paraglider.utils.Color;

public class InGameStaminaWheelRenderer
extends StaminaWheelRenderer {
    private double prevStamina;
    private long fullTime;

    @Override
    protected void makeWheel(PlayerMovement playerMovement) {
        double maxStamina;
        double stamina = playerMovement.getDoubleStamina();
        if (stamina >= (maxStamina = playerMovement.getDoubleMaxStamina())) {
            long timeDiff;
            long time = System.currentTimeMillis();
            if (this.prevStamina != stamina) {
                this.prevStamina = stamina;
                this.fullTime = time;
                timeDiff = 0L;
            } else {
                timeDiff = time - this.fullTime;
            }
            Color color = StaminaWheelConstants.getGlowAndFadeColor(timeDiff);
            if (color.alpha <= 0.0f) {
                return;
            }
            for (StaminaWheelRenderer.WheelLevel t : StaminaWheelRenderer.WheelLevel.values()) {
                this.addWheel(t, 0.0, t.getProportion(stamina), color);
            }
        } else {
            this.prevStamina = stamina;
            Color color = StaminaWheelConstants.DEPLETED_1.blend(StaminaWheelConstants.DEPLETED_2, StaminaWheelConstants.cycle(System.currentTimeMillis(), playerMovement.isDepleted() ? 600L : 300L));
            PlayerState state = playerMovement.getState();
            for (StaminaWheelRenderer.WheelLevel t : StaminaWheelRenderer.WheelLevel.values()) {
                this.addWheel(t, 0.0, t.getProportion(maxStamina), StaminaWheelConstants.EMPTY);
                if (!playerMovement.canAction()) {
                    this.addWheel(t, 0.0, t.getProportion(stamina), color);
                    continue;
                }
                this.addWheel(t, 0.0, t.getProportion(stamina), StaminaWheelConstants.IDLE.blend(StaminaWheelConstants.DEPLETED_2, (float)(1.0 - stamina / maxStamina)));
                if (!state.isConsume() || !(state.isParagliding() ? ModCfg.paraglidingConsumesStamina() : ModCfg.runningConsumesStamina())) continue;
                this.addWheel(t, t.getProportion(stamina + state.doubleChange() * 10.0), t.getProportion(stamina), color);
            }
        }
    }
}

