/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.capabilities;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;
import tictim.paraglider.ModCfg;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.Paraglider;
import tictim.paraglider.capabilities.PlayerMovement;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.ModAdvancements;
import tictim.paraglider.item.ParagliderItem;
import tictim.paraglider.network.ModNet;
import tictim.paraglider.network.SyncMovementMsg;
import tictim.paraglider.network.SyncParaglidingMsg;
import tictim.paraglider.network.SyncVesselMsg;
import tictim.paraglider.wind.Wind;

public final class ServerPlayerMovement
extends PlayerMovement
implements INBTSerializable<CompoundTag> {
    public static final int PANIC_INITIAL_DELAY = 10;
    public static final int PANIC_DELAY = 30;
    public static final int PANIC_DURATION = 15;
    public static final UUID HEART_CONTAINER_UUID = UUID.fromString("a0f1c25b-c4f9-4413-9619-7841cd7982a3");
    public static final UUID STAMINA_CONTAINER_UUID = UUID.fromString("8eb77123-6306-4188-9227-56082ba4887a");
    private final ServerPlayer serverPlayer;
    private PlayerState prevState = PlayerState.IDLE;
    private boolean healthNeedsUpdate = true;
    private boolean staminaNeedsUpdate = true;
    private boolean prevIsParagliding;
    public boolean vesselNeedsSync;
    public boolean movementNeedsSync;
    public boolean paraglidingNeedsSync;
    private double prevY;
    private double accumulatedFallDistance;
    private int panicParaglidingDelay = 10;
    private int panicParaglidingDuration = 0;
    private int essence;

    public ServerPlayerMovement(ServerPlayer player) {
        super((Player)player);
        this.serverPlayer = player;
    }

    public int getEssence() {
        return this.essence;
    }

    public void setEssence(int essence) {
        this.essence = Math.max(essence, 0);
    }

    @Override
    public void setStaminaVessels(int staminaVessels) {
        int cache = this.getStaminaVessels();
        super.setStaminaVessels(staminaVessels);
        if (cache != staminaVessels) {
            this.vesselNeedsSync = true;
            this.staminaNeedsUpdate = true;
        }
    }

    @Override
    public void setHeartContainers(int heartContainers) {
        int cache = this.getHeartContainers();
        super.setHeartContainers(heartContainers);
        if (cache != heartContainers) {
            this.vesselNeedsSync = true;
            this.healthNeedsUpdate = true;
        }
    }

    @Override
    public boolean isParagliding() {
        return this.prevIsParagliding;
    }

    @Override
    public void update() {
        Record msg;
        boolean isParagliding;
        if (this.healthNeedsUpdate) {
            double delta = this.applyAttribute(Attributes.f_22276_, HEART_CONTAINER_UUID, "Heart Containers", ModCfg.additionalMaxHealth(this.getHeartContainers()));
            this.player.m_21153_(Math.min(this.player.m_21233_(), this.player.m_21223_() + Math.max(0.0f, (float)delta)));
            this.healthNeedsUpdate = false;
        }
        if (this.staminaNeedsUpdate) {
            this.applyAttribute((Attribute)Contents.MAX_STAMINA.get(), STAMINA_CONTAINER_UUID, "Stamina Vessels", ModCfg.maxStamina(this.getStaminaVessels()));
            this.setStamina(Math.min(this.getDoubleStamina(), this.getDoubleMaxStamina()));
            this.staminaNeedsUpdate = false;
        }
        this.accumulatedFallDistance = this.player.m_20096_() || this.player.m_20186_() > this.prevY ? 0.0 : (this.accumulatedFallDistance += this.prevY - this.player.m_20186_());
        boolean isHoldingParaglider = Paraglider.isParaglider(this.player.m_21205_());
        this.setState(this.calculatePlayerState(isHoldingParaglider));
        if (this.prevState != this.getState()) {
            this.movementNeedsSync = true;
        }
        boolean wasDepleted = this.isDepleted();
        this.updateStamina();
        if (!this.player.m_7500_() && this.isDepleted() && !wasDepleted) {
            this.player.m_7292_(new MobEffectInstance((MobEffect)Contents.EXHAUSTED.get(), this.getRecoveryDelay() + 10, 0, false, false, false));
        }
        boolean bl = isParagliding = this.getState().isParagliding() && (this.canUseParaglider() || this.tryPanicParagliding());
        if (this.prevIsParagliding != isParagliding) {
            this.paraglidingNeedsSync = true;
            this.prevIsParagliding = isParagliding;
        }
        this.applyMovement();
        if (this.movementNeedsSync) {
            msg = new SyncMovementMsg(this);
            if (ModCfg.traceMovementPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player {}", (Object)msg, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> this.serverPlayer), (Object)msg);
            this.paraglidingNeedsSync = true;
            this.movementNeedsSync = false;
        }
        if (this.paraglidingNeedsSync) {
            SyncParaglidingMsg msg2 = new SyncParaglidingMsg(this);
            if (ModCfg.traceParaglidingPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player tracking {}", (Object)msg2, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.serverPlayer), (Object)msg2);
            this.paraglidingNeedsSync = false;
        }
        if (this.vesselNeedsSync) {
            msg = new SyncVesselMsg(this.getDoubleStamina(), this.getHeartContainers(), this.getStaminaVessels());
            if (ModCfg.traceVesselPacket()) {
                ParagliderMod.LOGGER.debug("Sending packet {} to player {}", (Object)msg, (Object)this.player);
            }
            ModNet.NET.send(PacketDistributor.PLAYER.with(() -> this.serverPlayer), (Object)msg);
            if (ModCfg.maxHeartContainers() <= this.getHeartContainers() && ModCfg.maxStaminaVessels() <= this.getStaminaVessels()) {
                ModAdvancements.give(this.serverPlayer, ModAdvancements.ALL_VESSELS, "code_triggered");
            }
            this.vesselNeedsSync = false;
        }
        this.prevState = this.getState();
        this.prevY = this.player.m_20186_();
        for (int i = 0; i < this.player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = this.player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof ParagliderItem)) continue;
            ParagliderItem.setItemParagliding(stack, i == this.player.m_150109_().f_35977_ && isParagliding);
        }
    }

    private double applyAttribute(Attribute attribute, UUID uuid, String name, double value) {
        AttributeInstance attrib = this.player.m_21051_(attribute);
        if (attrib == null) {
            return 0.0;
        }
        AttributeModifier prev = attrib.m_22111_(uuid);
        if (prev != null) {
            attrib.m_22130_(prev);
        }
        if (value != 0.0) {
            attrib.m_22125_(new AttributeModifier(uuid, () -> name, value, AttributeModifier.Operation.ADDITION));
        }
        return value - (prev != null ? prev.m_22218_() : 0.0);
    }

    private PlayerState calculatePlayerState(boolean isHoldingParaglider) {
        if (this.player.m_150110_().f_35935_) {
            return PlayerState.IDLE;
        }
        if (this.player.m_20202_() != null) {
            return PlayerState.RIDING;
        }
        if (this.player.m_6069_()) {
            return PlayerState.SWIMMING;
        }
        if (this.player.m_20069_()) {
            return this.canBreathe() ? PlayerState.BREATHING_UNDERWATER : PlayerState.UNDERWATER;
        }
        if (!this.player.m_20096_() && isHoldingParaglider && !this.player.m_21255_()) {
            if (ModCfg.ascendingWinds() && Wind.isInside(this.player.f_19853_, this.player.m_142469_())) {
                return PlayerState.ASCENDING;
            }
            if (this.prevState.isParagliding() || this.accumulatedFallDistance >= (double)1.45f) {
                return PlayerState.PARAGLIDING;
            }
        }
        if (this.player.m_20142_() && !this.player.m_6117_()) {
            return PlayerState.RUNNING;
        }
        if (this.player.m_20096_()) {
            return PlayerState.IDLE;
        }
        return PlayerState.MIDAIR;
    }

    private boolean canBreathe() {
        ItemStack feet;
        if (this.player.m_21023_(MobEffects.f_19608_)) {
            return true;
        }
        if (this.player.m_20096_() && (!this.player.m_204029_(FluidTags.f_13131_) || this.player.f_19853_.m_8055_(new BlockPos(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_())).m_60713_(Blocks.f_50628_))) {
            return true;
        }
        ItemStack head = this.player.m_6844_(EquipmentSlot.HEAD);
        if (!head.m_41619_()) {
            if (head.m_41720_() == Items.f_42354_) {
                return true;
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44971_, (ItemStack)head) > 0) {
                return true;
            }
        }
        return !(feet = this.player.m_6844_(EquipmentSlot.FEET)).m_41619_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44973_, (ItemStack)feet) > 0;
    }

    @Override
    protected void applyMovement() {
        super.applyMovement();
        if (this.isParagliding()) {
            this.serverPlayer.f_8906_.f_9737_ = 0;
            ItemStack stack = this.player.m_21205_();
            if (Paraglider.isParaglider(stack)) {
                ServerPlayerMovement.damageParagliderWithoutBreaking(this.player, stack);
            }
        }
    }

    private static void damageParagliderWithoutBreaking(Player player, ItemStack stack) {
        AtomicBoolean fuck = new AtomicBoolean();
        int count = stack.m_41613_();
        stack.m_41622_(1, (LivingEntity)player, p -> {
            p.m_21190_(InteractionHand.MAIN_HAND);
            stack.m_41764_(count + 1);
            fuck.set(true);
        });
        if (fuck.get()) {
            stack.m_41764_(count);
            stack.m_41721_(stack.m_41776_());
        }
    }

    @Override
    protected void updateStamina() {
        boolean wasDepleted = this.isDepleted();
        super.updateStamina();
        if (this.isDepleted() != wasDepleted) {
            this.movementNeedsSync = true;
        }
        if (this.isDepleted()) {
            if (this.getDoubleStamina() >= this.getDoubleMaxStamina() || this.canAction()) {
                this.setDepleted(false);
                this.movementNeedsSync = true;
            }
        } else if (this.getDoubleStamina() <= 0.0) {
            this.setDepleted(true);
            this.panicParaglidingDelay = 10;
            this.movementNeedsSync = true;
        }
    }

    private boolean tryPanicParagliding() {
        if (this.panicParaglidingDuration > 0) {
            --this.panicParaglidingDuration;
            return true;
        }
        if (this.panicParaglidingDelay > 0) {
            --this.panicParaglidingDelay;
            return false;
        }
        this.panicParaglidingDelay = 30;
        this.panicParaglidingDuration = 15;
        return true;
    }

    @Override
    public void copyTo(PlayerMovement another) {
        super.copyTo(another);
        if (another instanceof ServerPlayerMovement) {
            ((ServerPlayerMovement)another).setEssence(this.getEssence());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("stamina", this.getDoubleStamina());
        nbt.m_128379_("depleted", this.isDepleted());
        nbt.m_128405_("recoveryDelay", this.getRecoveryDelay());
        nbt.m_128405_("panicParaglidingDelay", this.panicParaglidingDelay);
        nbt.m_128405_("staminaVessels", this.getStaminaVessels());
        nbt.m_128405_("heartContainers", this.getHeartContainers());
        nbt.m_128405_("essence", this.getEssence());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.setStamina(nbt.m_128459_("stamina"));
        this.setDepleted(nbt.m_128471_("depleted"));
        this.setRecoveryDelay(nbt.m_128451_("recoveryDelay"));
        this.panicParaglidingDelay = nbt.m_128451_("panicParaglidingDelay");
        this.setStaminaVessels(nbt.m_128451_("staminaVessels"));
        this.setHeartContainers(nbt.m_128451_("heartContainers"));
        this.setEssence(nbt.m_128451_("essence"));
    }

    @Nullable
    public static ServerPlayerMovement of(ICapabilityProvider capabilityProvider) {
        PlayerMovement movement = PlayerMovement.of(capabilityProvider);
        return movement instanceof ServerPlayerMovement ? (ServerPlayerMovement)movement : null;
    }
}

