/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.capabilities;

import java.util.Objects;
import net.minecraftforge.common.ForgeConfigSpec;

public enum PlayerState {
    IDLE("idle", false, 20.0),
    MIDAIR("midair", false, 0.0),
    RUNNING("running", false, -10.0),
    SWIMMING("swimming", false, -6.0),
    UNDERWATER("underwater", false, 3.0),
    BREATHING_UNDERWATER("breathingUnderwater", false, 10.0),
    RIDING("riding", false, 20.0),
    PARAGLIDING("paragliding", true, -3.0),
    ASCENDING("ascending", true, -3.0);

    public final String id;
    private final boolean paragliding;
    public final double defaultChange;
    private ForgeConfigSpec.DoubleValue change;

    private PlayerState(String id, boolean paragliding, double defaultChange) {
        this.id = id;
        this.paragliding = paragliding;
        this.defaultChange = defaultChange;
    }

    public boolean isParagliding() {
        return this.paragliding;
    }

    public double doubleChange() {
        return (Double)this.change.get();
    }

    @Deprecated
    public int change() {
        return (int)this.doubleChange();
    }

    public boolean isConsume() {
        return this.doubleChange() < 0.0;
    }

    public void setConfig(ForgeConfigSpec.DoubleValue change) {
        if (this.change != null) {
            throw new IllegalStateException("Multiple config entry");
        }
        this.change = Objects.requireNonNull(change);
    }

    public static PlayerState of(int meta) {
        PlayerState[] values = PlayerState.values();
        return values[meta % values.length];
    }
}

