/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider;

import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.capabilities.PlayerState;
import tictim.paraglider.loot.ParagliderModifier;

@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModCfg {
    private static ForgeConfigSpec.BooleanValue ascendingWinds;
    private static ForgeConfigSpec.BooleanValue paraglidingConsumesStamina;
    private static ForgeConfigSpec.BooleanValue runningConsumesStamina;
    private static ForgeConfigSpec.ConfigValue<List<? extends String>> windSources;
    private static Map<Block, Predicate<BlockState>> windSourcesParsed;
    private static ForgeConfigSpec.DoubleValue paraglidingSpeed;
    private static ForgeConfigSpec.IntValue paragliderDurability;
    private static ForgeConfigSpec.BooleanValue enderDragonDropsVessel;
    private static ForgeConfigSpec.BooleanValue raidGivesVessel;
    private static ForgeConfigSpec.IntValue startingHearts;
    private static ForgeConfigSpec.IntValue maxHeartContainers;
    private static ForgeConfigSpec.DoubleValue maxStamina;
    private static ForgeConfigSpec.DoubleValue startingStamina;
    private static ForgeConfigSpec.IntValue maxStaminaVessels;
    private static ForgeConfigSpec.EnumValue<ParagliderModifier.ConfigOption> paragliderInTowersOfTheWild;
    private static ForgeConfigSpec.BooleanValue enableSpiritOrbGens;
    private static ForgeConfigSpec.BooleanValue enableHeartContainers;
    private static ForgeConfigSpec.BooleanValue enableStaminaVessels;
    private static ForgeConfigSpec.BooleanValue enableStructures;
    private static ForgeConfigSpec.BooleanValue enableNoActionDepletedRegenerating;
    private static ForgeConfigSpec.BooleanValue debugPlayerMovement;
    private static ForgeConfigSpec.BooleanValue traceMovementPacket;
    private static ForgeConfigSpec.BooleanValue traceParaglidingPacket;
    private static ForgeConfigSpec.BooleanValue traceVesselPacket;
    private static final double DEFAULT_STAMINA_WHEEL_X = 0.382903981264637;
    private static final double DEFAULT_STAMINA_WHEEL_Y = 0.46875;
    private static double staminaWheelX;
    private static double staminaWheelY;
    private static final Pattern REGEX;

    private ModCfg() {
    }

    public static boolean ascendingWinds() {
        return (Boolean)ascendingWinds.get();
    }

    public static boolean paraglidingConsumesStamina() {
        return (Boolean)paraglidingConsumesStamina.get();
    }

    public static boolean runningConsumesStamina() {
        return (Boolean)runningConsumesStamina.get();
    }

    public static boolean isWindSource(BlockState state) {
        Predicate<BlockState> p = windSourcesParsed.get(state.m_60734_());
        return p != null && p.test(state);
    }

    public static double paraglidingSpeed() {
        return (Double)paraglidingSpeed.get();
    }

    public static int paragliderDurability() {
        return (Integer)paragliderDurability.get();
    }

    public static boolean enderDragonDropsVessel() {
        return (Boolean)enderDragonDropsVessel.get();
    }

    public static boolean raidGivesVessel() {
        return (Boolean)raidGivesVessel.get();
    }

    public static int startingHearts() {
        return (Integer)startingHearts.get();
    }

    public static int maxHeartContainers() {
        return (Integer)maxHeartContainers.get();
    }

    public static double maxStamina() {
        return (Double)maxStamina.get();
    }

    public static double startingStamina() {
        return Math.min(ModCfg.maxStamina(), (Double)startingStamina.get());
    }

    public static int maxStaminaVessels() {
        return (Integer)maxStaminaVessels.get();
    }

    public static int additionalMaxHealth(int heartContainers) {
        return (ModCfg.startingHearts() - 10 + Math.min(ModCfg.maxHeartContainers(), heartContainers)) * 2;
    }

    public static double maxStamina(int staminaVessels) {
        int maxStaminaVessels = ModCfg.maxStaminaVessels();
        double startingStamina = ModCfg.startingStamina();
        if (maxStaminaVessels <= 0) {
            return startingStamina;
        }
        if (maxStaminaVessels <= staminaVessels) {
            ModCfg.maxStamina();
        }
        return startingStamina + (double)((int)((double)staminaVessels / (double)maxStaminaVessels * (ModCfg.maxStamina() - startingStamina)));
    }

    public static ParagliderModifier.ConfigOption paragliderInTowersOfTheWild() {
        return (ParagliderModifier.ConfigOption)((Object)paragliderInTowersOfTheWild.get());
    }

    public static boolean enableSpiritOrbGens() {
        return (Boolean)enableSpiritOrbGens.get();
    }

    public static boolean enableHeartContainers() {
        return (Boolean)enableHeartContainers.get();
    }

    public static boolean enableStaminaVessels() {
        return (Boolean)enableStaminaVessels.get();
    }

    public static boolean enableStructures() {
        return (Boolean)enableStructures.get();
    }

    public static boolean enableNoActionDepletedRegenerating() {
        return (Boolean)enableNoActionDepletedRegenerating.get();
    }

    public static boolean debugPlayerMovement() {
        return (Boolean)debugPlayerMovement.get();
    }

    public static boolean traceMovementPacket() {
        return (Boolean)traceMovementPacket.get();
    }

    public static boolean traceParaglidingPacket() {
        return (Boolean)traceParaglidingPacket.get();
    }

    public static boolean traceVesselPacket() {
        return (Boolean)traceVesselPacket.get();
    }

    public static double staminaWheelX() {
        return staminaWheelX;
    }

    public static void setStaminaWheelX(double staminaWheelX) {
        ModCfg.staminaWheelX = ModCfg.filterBadValue(staminaWheelX, 0.382903981264637);
    }

    public static double staminaWheelY() {
        return staminaWheelY;
    }

    public static void setStaminaWheelY(double staminaWheelY) {
        ModCfg.staminaWheelY = ModCfg.filterBadValue(staminaWheelY, 0.46875);
    }

    public static void setStaminaWheel(double x, double y) {
        ModCfg.setStaminaWheelX(x);
        ModCfg.setStaminaWheelY(y);
    }

    private static double filterBadValue(double d, double defaultValue) {
        if (Double.isNaN(d)) {
            return defaultValue;
        }
        return Mth.m_14008_((double)d, (double)0.0, (double)1.0);
    }

    public static void init() {
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        ascendingWinds = server.comment("Fire will float you upward.").define("ascendingWinds", true);
        windSources = server.comment("You can customize which block produces wind.\nWrite each blockstate to one of this format:\n  [block ID]   (Matches all state of the block)\n  [block ID]#[property1=value],[property2=value],[property3=value]   (Matches state of the block that has specified properties)\nSame property cannot be specified multiple times. Wind sources with any invalid part will be excluded.").defineListAllowEmpty(Collections.singletonList("windSources"), () -> ImmutableList.of((Object)"fire", (Object)"soul_fire", (Object)"campfire#lit=true", (Object)"soul_campfire#lit=true"), o -> true);
        paraglidingSpeed = server.comment("Horizontal movement speed while paragliding.").defineInRange("paraglidingSpeed", 1.0, 0.2, 10.0);
        paragliderDurability = server.comment("Durability of Paragliders. Set to zero to disable durability.").defineInRange("paragliderDurability", 0, 0, Integer.MAX_VALUE);
        server.push("spiritOrbs");
        enderDragonDropsVessel = server.comment("If true, Ender Dragon will drop heart container(stamina vessel if heart container is disabled) upon death.").define("enderDragonDropsVessel", true);
        raidGivesVessel = server.comment("If true, Raids will give heart container(stamina vessel if heart container is disabled) upon victory.").define("raidGivesVessel", true);
        server.pop();
        server.push("vessels");
        startingHearts = server.comment("Starting health points.").defineInRange("startingHearts", 10, 1, 512);
        maxHeartContainers = server.comment("Maximum amount of Heart Containers one player can consume.\nDo note that the maximum health point is capped at 1024 (512 hearts).").defineInRange("maxHeartContainers", 20, 0, 512);
        maxStamina = server.comment("Maximum amount of stamina Player can get. Do note that one third of this value is equal to one stamina wheel.").defineInRange("maxStamina", 3000.0, 0.0, 2.147483647E9);
        startingStamina = server.comment("Amount of stamina Player starts with. Values higher than maxStamina doesn't work.\nIf you want to make this value displayed as exactly one stamina wheel, you have to make this value one third of maxStamina.").defineInRange("startingStamina", 1000.0, 0.0, 2.147483647E9);
        maxStaminaVessels = server.comment("Stamina Vessels players need to obtain max out stamina. More vessels means lesser stamina increase per vessel.").defineInRange("maxStaminaVessels", 10, 0, Integer.MAX_VALUE);
        server.pop();
        paragliderInTowersOfTheWild = server.comment("Configurable option for Towers of the Wild compat feature. Can be ignored if Towers of the Wild is not installed.\nDEFAULT: Default option, spawn Deku Leaf in ocean tower chests and Paraglider in normal tower chests\nDISABLE: Don't spawn anything\nPARAGLIDER_ONLY: Spawn paraglider in both ocean and normal tower chests\nDEKU_LEAF_ONLY: Spawn deku leaf in both ocean and normal tower chests, like a boss\n(Note: The TotW datapack for 1.18 only has regular towers, thus options for ocean chests have no effect.)").defineEnum("paragliderInTowersOfTheWild", (Enum)ParagliderModifier.ConfigOption.DEFAULT);
        server.push("stamina");
        paraglidingConsumesStamina = server.comment("Paragliding and ascending will consume stamina.").define("paraglidingConsumesStamina", true);
        runningConsumesStamina = server.comment("Actions other than paragliding or ascending will consume stamina.").define("runningAndSwimmingConsumesStamina", false);
        server.push("consumptions");
        for (PlayerState state : PlayerState.values()) {
            state.setConfig(server.defineInRange(state.id + "StaminaConsumption", state.defaultChange, -2.147483648E9, 2.147483647E9));
        }
        server.pop();
        server.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)server.build());
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.comment("Easy to access switches to toggle newer features on and off.\nMost of them requires server restart or datapack reload. All of them, actually.").push("features");
        enableSpiritOrbGens = common.comment("For those who wants to remove entirety of Spirit Orbs generated from chests, more specifically...\n  * Spirit Orbs generated in various chests\n  * Spirit Orbs dropped by spawners and such\nNote that bargain recipe for Heart Containers/Stamina Vessels will persist, even if this option is disabled.").define("spiritOrbGens", true);
        enableHeartContainers = common.comment("For those who wants to remove entirety of Heart Containers from the game, more specifically...\n  * Heart Containers obtained by \"challenges\" (i.e. Killing dragon, wither, raid)\n  * Bargains using Heart Containers (custom recipes won't be affected)\nNote that if this option is disabled while staminaVessels is enabled, \"challenges\" will drop stamina vessels instead.").define("heartContainers", true);
        enableStaminaVessels = common.comment("For those who wants to remove entirety of Stamina Vessels from the game, more specifically...\n  * Bargains using Stamina Vessels (custom recipes won't be affected)").define("staminaVessels", true);
        enableStructures = common.comment("For those who wants to remove all structures added by this mod. Requires restart.").define("structures", true);
        enableNoActionDepletedRegenerating = common.comment("For those who wants to action when regenerating after depleted").define("noActionDepletedRegenerating", true);
        common.pop();
        common.push("debug");
        debugPlayerMovement = common.define("debugPlayerMovement", false);
        traceMovementPacket = common.define("traceMovementPacket", false);
        traceParaglidingPacket = common.define("traceParaglidingPacket", false);
        traceVesselPacket = common.define("traceVesselPacket", false);
        common.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)common.build());
        ModCfg.loadParagliderSettings();
    }

    private static void loadParagliderSettings() {
        block8: {
            try {
                Path file = FMLPaths.GAMEDIR.get().resolve("paragliderSettings.nbt");
                if (Files.exists(file, new LinkOption[0])) {
                    try (DataInputStream dis = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                        CompoundTag nbt = NbtIo.m_128928_((DataInput)dis);
                        CompoundTag staminaWheel = nbt.m_128469_("staminaWheel");
                        ModCfg.setStaminaWheelX(staminaWheel.m_128459_("x"));
                        ModCfg.setStaminaWheelY(staminaWheel.m_128459_("y"));
                        break block8;
                    }
                }
                staminaWheelX = 0.382903981264637;
                staminaWheelY = 0.46875;
            }
            catch (IOException | RuntimeException ex) {
                ParagliderMod.LOGGER.error("Error occurred while loading paraglider settings: ", (Throwable)ex);
                staminaWheelX = 0.382903981264637;
                staminaWheelY = 0.46875;
            }
        }
    }

    public static boolean saveParagliderSettings() {
        try {
            CompoundTag nbt = new CompoundTag();
            CompoundTag staminaWheel = new CompoundTag();
            staminaWheel.m_128347_("x", staminaWheelX);
            staminaWheel.m_128347_("y", staminaWheelY);
            nbt.m_128365_("staminaWheel", (Tag)staminaWheel);
            Path file = FMLPaths.GAMEDIR.get().resolve("paragliderSettings.nbt");
            try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(file, StandardOpenOption.CREATE));){
                NbtIo.m_128941_((CompoundTag)nbt, (DataOutput)dos);
            }
            ParagliderMod.LOGGER.debug("Saved paraglider settings.");
            return true;
        }
        catch (IOException | RuntimeException ex) {
            ParagliderMod.LOGGER.error("Error occurred while saving paraglider settings: ", (Throwable)ex);
            return false;
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        ModConfig cfg = event.getConfig();
        if (cfg.getModId().equals("paraglider") && cfg.getType() == ModConfig.Type.SERVER) {
            windSourcesParsed = Collections.unmodifiableMap(ModCfg.parseWindSources());
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        MinecraftServer server;
        ModConfig cfg = event.getConfig();
        if (cfg.getModId().equals("paraglider") && cfg.getType() == ModConfig.Type.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            server.execute(() -> {
                windSourcesParsed = Collections.unmodifiableMap(ModCfg.parseWindSources());
            });
        }
    }

    private static Map<Block, Predicate<BlockState>> parseWindSources() {
        IdentityHashMap<Block, Predicate<BlockState>> map = new IdentityHashMap<Block, Predicate<BlockState>>();
        Matcher m = REGEX.matcher("");
        for (String s : (List)windSources.get()) {
            if (!m.reset(s).matches()) {
                ModCfg.warnIgnoredWindSource(s, "input pattern is incorrect", new Object[0]);
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(m.group(1)));
            if (block == null || block == Blocks.f_50016_) {
                ModCfg.warnIgnoredWindSource(s, "no such block exists", new Object[0]);
                continue;
            }
            Predicate<BlockState> p = ModCfg.parsePredicate(s, m, block);
            if (p == null) continue;
            map.compute(block, (k, v) -> v == null ? p : v.or(p));
        }
        return map;
    }

    @Nullable
    private static Predicate<BlockState> parsePredicate(String input, Matcher matcher, Block block) {
        String blockState = matcher.group(2);
        if (blockState == null) {
            return s -> true;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String s2 : blockState.split(",")) {
            int i = s2.indexOf(61);
            String key = s2.substring(0, i);
            if (properties.containsKey(key)) {
                ModCfg.warnIgnoredWindSource(input, "same property '{}' was defined twice", key);
                return null;
            }
            properties.put(key, s2.substring(i + 1));
        }
        IdentityHashMap parsedProperties = new IdentityHashMap();
        for (Map.Entry e : properties.entrySet()) {
            String key = (String)e.getKey();
            Property property = block.m_49965_().m_61081_(key);
            if (property == null) {
                ModCfg.warnIgnoredWindSource(input, "property '{}' doesn't exist on that block", key);
                return null;
            }
            if (parsedProperties.containsKey(property)) {
                ModCfg.warnIgnoredWindSource(input, "same property '{}' was defined twice", key);
                return null;
            }
            Optional o2 = property.m_6215_((String)e.getValue());
            if (o2.isEmpty()) {
                ModCfg.warnIgnoredWindSource(input, "property '{}' doesn't contain value '{}'", key, e.getValue());
                return null;
            }
            parsedProperties.put(property, o2.get());
        }
        BlockStatePredicate m = BlockStatePredicate.m_61287_((Block)block);
        for (Map.Entry e : parsedProperties.entrySet()) {
            Object v = e.getValue();
            m.m_61295_((Property)e.getKey(), o -> o != null && o.equals(v));
        }
        return m;
    }

    private static void warnIgnoredWindSource(String input, String cause, Object ... args) {
        ParagliderMod.LOGGER.warn("Wind source '" + input + "' was ignored, because " + cause, args);
    }

    static {
        staminaWheelX = 0.382903981264637;
        staminaWheelY = 0.46875;
        REGEX = Pattern.compile("^((?:[a-z0-9_.-]+:)?[a-z0-9_.-]+)(?:\\s*#\\s*([A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+(?:\\s*,\\s*[A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+)*))?$");
    }
}

