/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.armorcurve.mixin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import jackiecrazy.armorcurve.CurveConfig;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public abstract class ArmorDegradationMixin {
    private static final Cache<ItemStack, ImmutableMultimap<Attribute, AttributeModifier>> cache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(1L, TimeUnit.SECONDS).build();

    @Shadow
    public abstract Item m_41720_();

    @Shadow
    public abstract boolean m_41619_();

    @Shadow
    public abstract int m_41773_();

    @Shadow
    public abstract int m_41776_();

    @Shadow
    public abstract boolean m_41763_();

    @Inject(cancellable=true, at={@At(value="RETURN")}, method={"getAttributeModifiers"}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void getAttributeModifiers(EquipmentSlot equipmentSlot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> info, Multimap<Attribute, AttributeModifier> m) {
        if (!this.m_41619_() && equipmentSlot != EquipmentSlot.MAINHAND && equipmentSlot != EquipmentSlot.OFFHAND && this.m_41763_()) {
            ImmutableMultimap cached = (ImmutableMultimap)cache.getIfPresent((Object)((ItemStack)this));
            if (cached != null) {
                info.setReturnValue((Object)cached);
            }
            ImmutableMultimap.Builder copy = ImmutableMultimap.builder();
            if (CurveConfig.degrade == null || CurveConfig.degrade.toString().equals("1")) {
                return;
            }
            float degrade = CurveConfig.degrade.with("remaining", new BigDecimal(this.m_41776_() - this.m_41773_())).and("max", new BigDecimal(this.m_41776_())).eval().floatValue();
            for (Attribute e : m.keySet()) {
                boolean handle = true;
                if (e.getRegistryName() != null && e.getRegistryName().m_135827_().equals("wardance")) {
                    handle = e.m_22087_().equals("wardance.absorption") || e.m_22087_().equals("wardance.deflection") || e.m_22087_().equals("wardance.shatter") || e.m_22087_().equals("stealth");
                } else if (e != Attributes.f_22284_ && !CurveConfig.degradeAll) {
                    handle = false;
                }
                for (AttributeModifier eam : m.get((Object)e)) {
                    AttributeModifier degradedEAM = new AttributeModifier(eam.m_22209_(), eam.m_22214_(), handle ? (double)degrade * eam.m_22218_() : eam.m_22218_(), eam.m_22217_());
                    copy.put((Object)e, (Object)degradedEAM);
                }
            }
            cached = copy.build();
            cache.put((Object)((ItemStack)this), (Object)cached);
            info.setReturnValue((Object)cached);
        }
    }
}

