/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.base.MoreObjects;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.visibility.CategoryVisibilityPredicate;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.unwrap.JEIUnwrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEICatalystLookup;
import me.shedaniel.rei.jeicompat.wrap.JEIFocusFactory;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeCategoriesLookup;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLookup;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeRegistration;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum JEIRecipeManager implements IRecipeManager
{
    INSTANCE;

    Set<CategoryIdentifier<?>> hiddenCategories = new HashSet();
    Map<CategoryIdentifier<?>, Set<Object>> hiddenRecipes = new HashMap();
    public DisplayPredicate displayPredicate = new DisplayPredicate();
    public CategoryPredicate categoryPredicate = new CategoryPredicate();

    @Override
    @Nullable
    public IRecipeCategory<?> getRecipeCategory(ResourceLocation recipeCategoryUid, boolean includeHidden) {
        try {
            DisplayCategory category = CategoryRegistry.getInstance().get(JEIPluginDetector.categoryId(recipeCategoryUid)).getCategory();
            if (CategoryRegistry.getInstance().isCategoryVisible(category)) {
                return new JEIUnwrappedCategory(category);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory, List<? extends IFocus<?>> focuses, boolean includeHidden) {
        if (focuses != null && !focuses.isEmpty()) {
            throw JEIPluginDetector.TODO();
        }
        return JEIPluginDetector.wrapRecipes(JEIPluginDetector.categoryId(recipeCategory.getRecipeType()), !includeHidden);
    }

    @Override
    public List<ITypedIngredient<?>> getRecipeCatalystsTyped(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ArrayList objects = new ArrayList();
        for (EntryIngredient stacks : CategoryRegistry.getInstance().get(JEIPluginDetector.categoryId(recipeCategory.getRecipeType())).getWorkstations()) {
            objects.addAll(CollectionUtils.map((Collection)stacks, JEIPluginDetector::typedJeiValue));
        }
        return objects;
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        return JEIFocusFactory.INSTANCE.createFocus(mode, ingredient);
    }

    @Override
    public <V> List<IRecipeCategory<?>> getRecipeCategories(@Nullable IFocus<V> focus, boolean includeHidden) {
        if (focus != null) {
            throw JEIPluginDetector.TODO();
        }
        return CollectionUtils.filterAndMap((Iterable)CategoryRegistry.getInstance(), config -> includeHidden || CategoryRegistry.getInstance().isCategoryVisible(config.getCategory()), config -> new JEIUnwrappedCategory(config.getCategory()));
    }

    @Override
    public List<IRecipeCategory<?>> getRecipeCategories(Collection<? extends IFocus<?>> focuses, boolean includeHidden) {
        if (focuses != null && !focuses.isEmpty()) {
            throw JEIPluginDetector.TODO();
        }
        return CollectionUtils.filterAndMap((Iterable)CategoryRegistry.getInstance(), config -> includeHidden || CategoryRegistry.getInstance().isCategoryVisible(config.getCategory()), config -> new JEIUnwrappedCategory(config.getCategory()));
    }

    @Override
    public <V> List<IRecipeCategory<?>> getRecipeCategories(Collection<ResourceLocation> recipeCategoryUids, @Nullable IFocus<V> focus, boolean includeHidden) {
        if (focus != null) {
            throw JEIPluginDetector.TODO();
        }
        return CollectionUtils.map(recipeCategoryUids, id -> this.getRecipeCategory((ResourceLocation)id, includeHidden));
    }

    @Override
    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, @Nullable IFocus<V> focus, boolean includeHidden) {
        if (focus != null) {
            throw JEIPluginDetector.TODO();
        }
        return JEIPluginDetector.wrapRecipes(JEIPluginDetector.categoryId(recipeCategory.getRecipeType()), !includeHidden);
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (EntryIngredient stacks : CategoryRegistry.getInstance().get(JEIPluginDetector.categoryId(recipeCategory.getRecipeType())).getWorkstations()) {
            objects.addAll(CollectionUtils.map((Collection)stacks, JEIPluginDetector::jeiValue));
        }
        return objects;
    }

    @Override
    public <R> IRecipeLookup<R> createRecipeLookup(RecipeType<R> recipeType) {
        return new JEIRecipeLookup(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    public IRecipeCategoriesLookup createRecipeCategoryLookup() {
        return new JEIRecipeCategoriesLookup();
    }

    @Override
    public IRecipeCatalystLookup createRecipeCatalystLookup(RecipeType<?> recipeType) {
        return new JEICatalystLookup(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    public <T> void hideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        this.hiddenRecipes.computeIfAbsent(JEIPluginDetector.categoryId(recipeType), $ -> new HashSet()).addAll(recipes);
    }

    @Override
    public <T> void unhideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        CategoryIdentifier categoryIdentifier = JEIPluginDetector.categoryId(recipeType);
        this.hiddenRecipes.computeIfAbsent(categoryIdentifier, $ -> new HashSet()).removeAll(recipes);
        if (this.hiddenRecipes.get(categoryIdentifier).isEmpty()) {
            this.hiddenRecipes.remove(categoryIdentifier);
        }
    }

    @Override
    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        JEIRecipeRegistration.addRecipes0(recipes, recipeType.getUid());
    }

    @Override
    public void hideRecipeCategory(RecipeType<?> recipeType) {
        this.hiddenCategories.add(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    public void unhideRecipeCategory(RecipeType<?> recipeType) {
        this.hiddenCategories.remove(JEIPluginDetector.categoryId(recipeType));
    }

    @Override
    @Nullable
    public <T> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, @Nullable IFocus<?> focus) {
        throw JEIPluginDetector.TODO();
    }

    @Override
    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        Set recipes = this.hiddenRecipes.computeIfAbsent(JEIPluginDetector.categoryId(recipeCategoryUid), $ -> new HashSet());
        recipes.add(recipe);
    }

    @Override
    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        CategoryIdentifier categoryIdentifier = JEIPluginDetector.categoryId(recipeCategoryUid);
        Set recipes = this.hiddenRecipes.computeIfAbsent(categoryIdentifier, $ -> new HashSet());
        recipes.remove(recipe);
        if (recipes.isEmpty()) {
            this.hiddenRecipes.remove(categoryIdentifier);
        }
    }

    @Override
    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.hiddenCategories.add(JEIPluginDetector.categoryId(recipeCategoryUid));
    }

    @Override
    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.hiddenCategories.remove(JEIPluginDetector.categoryId(recipeCategoryUid));
    }

    @Override
    public <T> void addRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        JEIRecipeRegistration.addRecipes0(Collections.singletonList(recipe), recipeCategoryUid);
    }

    public class DisplayPredicate
    implements DisplayVisibilityPredicate {
        public EventResult handleDisplay(DisplayCategory<?> category, Display display) {
            Set<Object> hidden = JEIRecipeManager.this.hiddenRecipes.get(category.getCategoryIdentifier());
            if (hidden != null && hidden.contains(MoreObjects.firstNonNull((Object)JEIPluginDetector.jeiValue(display), (Object)display))) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        }
    }

    public class CategoryPredicate
    implements CategoryVisibilityPredicate {
        public EventResult handleCategory(DisplayCategory<?> category) {
            if (JEIRecipeManager.this.hiddenCategories.contains(category.getCategoryIdentifier())) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        }
    }
}

