/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIDisplaySetup;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeSlot;
import me.shedaniel.rei.jeicompat.wrap.JEITypedIngredient;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeLayoutLegacyAdapter
implements IRecipeLayout {
    private final Map<EntryType<?>, GroupView<?>> groups = new HashMap();
    private final JEIDisplaySetup.Result view;

    public JEIRecipeLayoutLegacyAdapter(JEIDisplaySetup.Result view) {
        this.view = view;
    }

    @Override
    @NotNull
    public IGuiItemStackGroup getItemStacks() {
        return (IGuiItemStackGroup)this.getIngredientsGroup(VanillaTypes.ITEM);
    }

    @Override
    @NotNull
    public IGuiFluidStackGroup getFluidStacks() {
        return (IGuiFluidStackGroup)this.getIngredientsGroup(ForgeTypes.FLUID);
    }

    @Override
    @NotNull
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(@NotNull IIngredientType<T> ingredientType) {
        return this.groups.computeIfAbsent(JEIPluginDetector.unwrapType(ingredientType), type -> {
            if (Objects.equals(ingredientType.getIngredientClass(), ItemStack.class)) {
                return new GroupViewItem(ingredientType.cast());
            }
            if (Objects.equals(ingredientType.getIngredientClass(), FluidStack.class)) {
                return new GroupViewFluid(ingredientType.cast());
            }
            return new GroupView(ingredientType);
        });
    }

    @Nullable
    public IFocus<?> getFocus() {
        IFocusGroup foci = JEIWrappedDisplay.getFoci();
        if (foci.isEmpty()) {
            return null;
        }
        return foci.getAllFocuses().get(0);
    }

    @Override
    @Nullable
    public <V> IFocus<V> getFocus(@NotNull IIngredientType<V> ingredientType) {
        IFocus<?> focus = this.getFocus();
        if (focus == null) {
            return null;
        }
        ITypedIngredient<?> typedIngredient = focus.getTypedValue();
        return new JEIFocus(focus.getRole(), new JEITypedIngredient(typedIngredient.getType(), typedIngredient.getIngredient()));
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        throw new UnsupportedOperationException("This method is not supported during transfer");
    }

    @Override
    public void setShapeless() {
        throw new UnsupportedOperationException("This method is not supported during transfer");
    }

    public class GroupViewItem
    extends GroupView<ItemStack>
    implements IGuiItemStackGroup {
        public GroupViewItem(IIngredientType<ItemStack> type) {
            super(type);
        }
    }

    public class GroupViewFluid
    extends GroupView<FluidStack>
    implements IGuiFluidStackGroup {
        public GroupViewFluid(IIngredientType<FluidStack> type) {
            super(type);
        }

        @Override
        public void init(int ingredientIndex, boolean input, int xPosition, int yPosition, int width, int height, int capacityMb, boolean showCapacity, @Nullable IDrawable overlay) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }
    }

    public class GroupView<T>
    implements IGuiIngredientGroup<T> {
        private final IIngredientType<T> type;

        public GroupView(IIngredientType<T> type) {
            this.type = type;
        }

        @Override
        public void set(IIngredients ingredients) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        @Override
        public void set(int ingredientIndex, @Nullable List<T> ingredients) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        @Override
        public void set(int ingredientIndex, @Nullable T ingredient) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        @Override
        public void setBackground(int ingredientIndex, IDrawable background) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        @Override
        public void addTooltipCallback(ITooltipCallback<T> tooltipCallback) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        @Override
        public Map<Integer, ? extends IGuiIngredient<T>> getGuiIngredients() {
            HashMap<Integer, GuiIngredientView> ingredients = new HashMap<Integer, GuiIngredientView>();
            for (JEIRecipeSlot slot : JEIRecipeLayoutLegacyAdapter.this.view.slots) {
                if (slot.getIndex() < 0) continue;
                ingredients.put(slot.getIndex(), new GuiIngredientView(slot));
            }
            return ingredients;
        }

        @Override
        public void init(int ingredientIndex, boolean input, int xPosition, int yPosition) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        @Override
        public void init(int ingredientIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, int xPosition, int yPosition, int width, int height, int xInset, int yInset) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        @Override
        public void setOverrideDisplayFocus(@Nullable IFocus<T> focus) {
            throw new UnsupportedOperationException("This method is not supported during transfer");
        }

        public class GuiIngredientView
        implements IGuiIngredient<T> {
            public final JEIRecipeSlot slot;

            public GuiIngredientView(JEIRecipeSlot slot) {
                this.slot = slot;
            }

            @Override
            public IIngredientType<T> getIngredientType() {
                return GroupView.this.type;
            }

            @Override
            @Nullable
            public T getDisplayedIngredient() {
                return this.slot.getDisplayedIngredient(GroupView.this.type).orElse(null);
            }

            @Override
            public List<T> getAllIngredients() {
                return this.slot.getIngredients(GroupView.this.type).collect(Collectors.toList());
            }

            @Override
            public boolean isInput() {
                return this.slot.role == RecipeIngredientRole.INPUT || this.slot.role == RecipeIngredientRole.CATALYST;
            }

            @Override
            public void drawHighlight(PoseStack stack, int color, int xOffset, int yOffset) {
                stack.m_85836_();
                stack.m_85837_((double)xOffset, (double)yOffset, 0.0);
                this.slot.drawHighlight(stack, color);
                stack.m_85849_();
            }
        }
    }
}

