/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;

public class JEIRecipeCategoriesLookup
implements IRecipeCategoriesLookup {
    private Set<CategoryIdentifier<?>> categoryFilter = Set.of();
    private Set<CategoryIdentifier<?>> focusFilter = Set.of();
    private boolean includeHidden = false;

    @Override
    public IRecipeCategoriesLookup limitTypes(Collection<RecipeType<?>> recipeTypes) {
        Preconditions.checkNotNull(recipeTypes, (Object)"recipeTypes");
        this.categoryFilter = CollectionUtils.mapToSet(recipeTypes, type -> JEIPluginDetector.categoryId(type));
        return this;
    }

    @Override
    public IRecipeCategoriesLookup limitFocus(Collection<? extends IFocus<?>> focuses) {
        Preconditions.checkNotNull(focuses, (Object)"focuses");
        if (!focuses.isEmpty()) {
            ViewSearchBuilder builder = ViewSearchBuilder.builder();
            for (IFocus<?> focus : focuses) {
                EntryStack<?> stack = JEIPluginDetector.unwrapStack(focus.getTypedValue());
                if (focus.getRole() == RecipeIngredientRole.INPUT || focus.getRole() == RecipeIngredientRole.CATALYST) {
                    builder.addUsagesFor(stack);
                    continue;
                }
                builder.addRecipesFor(stack);
            }
            this.focusFilter = CollectionUtils.mapToSet(builder.buildMapInternal().keySet(), DisplayCategory::getCategoryIdentifier);
        }
        return this;
    }

    @Override
    public IRecipeCategoriesLookup includeHidden() {
        this.includeHidden = true;
        return this;
    }

    @Override
    public Stream<IRecipeCategory<?>> get() {
        Stream<IRecipeCategory<?>> stream = CollectionUtils.filterAndMap((Iterable)CategoryRegistry.getInstance(), cat -> {
            if (!this.includeHidden && CategoryRegistry.getInstance().isCategoryInvisible(cat.getCategory())) {
                return false;
            }
            Sets.SetView filter = Sets.intersection(this.categoryFilter, this.focusFilter);
            return filter.isEmpty() || filter.contains(cat.getCategoryIdentifier());
        }, cat -> JEIPluginDetector.wrapCategory(cat.getCategory())).stream();
        return stream;
    }
}

