/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientListOverlay;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JEIIngredientListOverlay implements IIngredientListOverlay
{
    INSTANCE;


    @Override
    public Optional<ITypedIngredient<?>> getIngredientUnderMouse() {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return Optional.empty();
        }
        ScreenOverlay overlay = (ScreenOverlay)REIRuntime.getInstance().getOverlay().get();
        EntryStack stack = overlay.getEntryList().getFocusedStack();
        return JEIPluginDetector.typedJeiValueOpWild(stack);
    }

    @Override
    @Nullable
    public <T> T getIngredientUnderMouse(@NotNull IIngredientType<T> ingredientType) {
        return this.getIngredientUnderMouse().flatMap(ingredient -> ingredient.getIngredient(ingredientType)).orElse(null);
    }

    @Override
    public boolean isListDisplayed() {
        if (!REIRuntime.getInstance().isOverlayVisible()) {
            return false;
        }
        ScreenOverlay overlay = (ScreenOverlay)REIRuntime.getInstance().getOverlay().get();
        return overlay.getEntryList().getEntries().findAny().isPresent();
    }

    @Override
    public boolean hasKeyboardFocus() {
        return REIRuntime.getInstance().isOverlayVisible() && REIRuntime.getInstance().getSearchTextField().isFocused();
    }

    @Override
    @NotNull
    public <T> List<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        if (REIRuntime.getInstance().isOverlayVisible()) {
            EntryType type = JEIPluginDetector.unwrapType(ingredientType);
            ScreenOverlay overlay = (ScreenOverlay)REIRuntime.getInstance().getOverlay().get();
            return overlay.getEntryList().getEntries().filter(entryStack -> entryStack.getType() == type).map(JEIPluginDetector::jeiValue).collect(Collectors.toList());
        }
        return null;
    }
}

