/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;

public class JEIFocusGroup
implements IFocusGroup {
    public static final IFocusGroup EMPTY = new JEIFocusGroup(Collections.emptyList());
    private List<IFocus<?>> foci;

    public JEIFocusGroup(List<IFocus<?>> foci) {
        this.foci = foci;
    }

    @Override
    public boolean isEmpty() {
        return this.foci.isEmpty();
    }

    @Override
    public List<IFocus<?>> getAllFocuses() {
        return Collections.unmodifiableList(this.foci);
    }

    @Override
    public Stream<IFocus<?>> getFocuses(RecipeIngredientRole role) {
        return this.foci.stream().filter(focus -> focus.getRole() == role);
    }

    @Override
    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType) {
        return this.foci.stream().flatMap(focus -> {
            if (focus instanceof IFocusGroup) {
                IFocusGroup group = (IFocusGroup)((Object)focus);
                return group.getFocuses(ingredientType);
            }
            if (Objects.equals(focus.getTypedValue().getType(), ingredientType)) {
                return Stream.of(focus);
            }
            return Stream.empty();
        });
    }

    @Override
    public <T> Stream<IFocus<T>> getFocuses(IIngredientType<T> ingredientType, RecipeIngredientRole role) {
        return this.getFocuses(ingredientType).filter(focus -> focus.getRole() == role);
    }
}

