/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import org.jetbrains.annotations.Nullable;

public enum JEICraftingGridHelper implements ICraftingGridHelper
{
    INSTANCE;


    @Override
    public <T> List<IRecipeSlotBuilder> createAndSetInputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> inputs, int width, int height) {
        ArrayList<IRecipeSlotBuilder> slotBuilders = new ArrayList<IRecipeSlotBuilder>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                slotBuilders.add(builder.addSlot(RecipeIngredientRole.INPUT, 14 + x * 18, 3 + y * 18));
            }
        }
        this.setInputs(slotBuilders, ingredientType, inputs, width, height);
        return slotBuilders;
    }

    @Override
    public <T> void setInputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> inputs, int width, int height) {
        this.createAndSetInputs(builder, ingredientType, inputs, width, height);
    }

    @Override
    public <T> void setInputs(List<IRecipeSlotBuilder> slotBuilders, IIngredientType<T> ingredientType, List<@Nullable List<@Nullable T>> inputs, int width, int height) {
        if (width <= 0 || height <= 0) {
            width = height = JEICraftingGridHelper.getShapelessSize(inputs.size());
        }
        if (slotBuilders.size() < width * height) {
            throw new IllegalArgumentException(String.format("There are not enough slots (%s) to hold a recipe of this size. (%sx%s)", slotBuilders.size(), width, height));
        }
        for (int i = 0; i < inputs.size(); ++i) {
            int index = JEICraftingGridHelper.getCraftingIndex(i, width, height);
            IRecipeSlotBuilder slot = slotBuilders.get(index);
            @Nullable List<@Nullable T> ingredients = inputs.get(i);
            if (ingredients == null) continue;
            slot.addIngredients(ingredientType, ingredients);
        }
    }

    @Override
    public <T> IRecipeSlotBuilder createAndSetOutputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, @Nullable @Nullable List<@Nullable T> outputs) {
        return (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 21).addIngredients(ingredientType, outputs);
    }

    @Override
    public <T> void setOutputs(IRecipeLayoutBuilder builder, IIngredientType<T> ingredientType, @Nullable @Nullable List<@Nullable T> outputs) {
        this.createAndSetOutputs(builder, ingredientType, outputs);
    }

    @Override
    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs) {
        int width = inputs.size() > 4 ? 3 : 2;
        for (int i = 0; i < inputs.size(); ++i) {
            List<T> stacks = inputs.get(i);
            int slot = DefaultCraftingDisplay.getSlotWithSize((int)width, (int)i, (int)3);
            ingredientGroup.set(slot + 1, stacks);
            int x = slot % 3;
            int y = slot / 3;
            ingredientGroup.init(slot + 1, true, 14 + x * 18, 2 + y * 18);
        }
    }

    @Override
    public <T> void setInputs(IGuiIngredientGroup<T> ingredientGroup, List<List<T>> inputs, int width, int height) {
        for (int i = 0; i < inputs.size(); ++i) {
            List<T> stacks = inputs.get(i);
            int slot = DefaultCraftingDisplay.getSlotWithSize((int)width, (int)i, (int)3);
            ingredientGroup.set(slot + 1, stacks);
            int x = slot % 3;
            int y = slot / 3;
            ingredientGroup.init(slot + 1, true, 13 + x * 18, 2 + y * 18);
        }
    }

    private static int getShapelessSize(int total) {
        if (total > 4) {
            return 3;
        }
        if (total > 1) {
            return 2;
        }
        return 1;
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 3 ? i * 3 + 1 : (height == 2 ? i * 3 + 1 : 4);
        } else if (height == 1) {
            index = i + 3;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                ++index;
                if (i > 3) {
                    ++index;
                }
            }
        } else {
            index = height == 2 ? i + 3 : i;
        }
        return index;
    }
}

