/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes.integration.epicfight;

import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.data.DCClass;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPAddLearnedSkill;
import yesman.epicfight.network.server.SPChangeSkill;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

public class EpicFightIntegration {
    public static List<String> getVerifiedSkills(DCClass clazz) {
        ArrayList list = Lists.newArrayList();
        for (String name : clazz.getSkills()) {
            Skill skill = SkillManager.getSkill((String)name);
            if (skill == null) {
                ClassesLogger.logError("Skill " + name + " is null ", new NullPointerException());
                continue;
            }
            list.add(name);
        }
        return list;
    }

    public static void applySkills(DCClass clazz, ServerPlayer player) {
        ServerPlayerPatch patch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, ServerPlayerPatch.class);
        if (patch != null) {
            CapabilitySkill skills = patch.getSkillCapability();
            for (String name : clazz.getSkills()) {
                ClassesLogger.logInfo("Applying skill " + name + " to player " + player.m_5446_().getString());
                Skill skill = SkillManager.getSkill((String)name);
                if (skill == null) {
                    ClassesLogger.logError("Skill " + name + " is null", new NullPointerException());
                    continue;
                }
                SkillSlot slot = ((SkillContainer)skills.getSkillContainersFor(skill.getCategory()).iterator().next()).getSlot();
                if (skill.getCategory().learnable()) {
                    skills.addLearnedSkill(skill);
                }
                SkillContainer container = patch.getSkill(slot.universalOrdinal());
                container.setSkill(skill);
                EpicFightNetworkManager.sendToPlayer((Object)new SPAddLearnedSkill(new String[]{skill.toString()}), (ServerPlayer)player);
                EpicFightNetworkManager.sendToPlayer((Object)new SPChangeSkill(slot, skill.toString(), SPChangeSkill.State.ENABLE), (ServerPlayer)player);
            }
        } else {
            ClassesLogger.logInfo("Patch is null");
        }
    }
}

