/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes.data;

import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.integration.CuriosIntegration;
import com.google.gson.JsonObject;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.smileycorp.atlas.api.util.TextUtils;

public class ItemEntry {
    private final ItemStack stack;
    private final String slot;

    public ItemEntry(JsonObject obj) throws Exception {
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        this.stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(obj.get("id").getAsString())), count);
        if (obj.has("nbt")) {
            this.stack.m_41751_(TagParser.m_129359_((String)obj.get("nbt").getAsString()));
        }
        this.slot = obj.has("slot") ? obj.get("slot").getAsString() : "mainhand";
    }

    public void apply(Player player) {
        ClassesLogger.logInfo("set " + this.stack + " to slot " + this.slot);
        if (this.slot.contains("curios:") && ModList.get().isLoaded("curios")) {
            CuriosIntegration.addItem(player, this.slot.replace("curios:", ""), this.stack.m_41777_());
        } else {
            EquipmentSlot slot;
            try {
                slot = EquipmentSlot.m_20747_((String)this.slot);
            }
            catch (Exception e) {
                slot = EquipmentSlot.MAINHAND;
            }
            if (slot == EquipmentSlot.MAINHAND) {
                player.m_150109_().m_36054_(this.stack.m_41777_());
            } else {
                player.m_8061_(slot, this.stack.m_41777_());
            }
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public String getSlot() {
        String[] split = this.slot.split(":");
        return split.length < 1 ? "" : TextUtils.toProperCase((String)split[split.length - 1]);
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.stack.m_41720_()).toString());
        obj.addProperty("count", (Number)this.stack.m_41613_());
        if (this.stack.m_41782_()) {
            obj.addProperty("nbt", this.stack.m_41783_().toString());
        }
        if (this.slot != null) {
            obj.addProperty("slot", this.slot);
        }
        return obj;
    }
}

