/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes.data;

import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.data.AttributeEntry;
import com.afunproject.dawncraft.classes.data.CommandApplyStage;
import com.afunproject.dawncraft.classes.data.CommandEntry;
import com.afunproject.dawncraft.classes.data.ItemEntry;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DCClass {
    private final ResourceLocation name;
    private final int index;
    private final List<String> skills = Lists.newArrayList();
    private final List<ItemEntry> items = Lists.newArrayList();
    private final List<AttributeEntry> attributes = Lists.newArrayList();
    private final List<CommandEntry> commands = Lists.newArrayList();
    private final boolean hidden;
    private final String animation;
    private final float xOffset;
    private final float yOffset;

    public DCClass(ResourceLocation name, JsonObject obj) throws Exception {
        JsonArray offset;
        this.name = name;
        int n = this.index = obj.has("index") ? obj.get("index").getAsInt() : 99;
        if (obj.has("starting_skills")) {
            for (Object element : obj.getAsJsonArray("starting_skills")) {
                this.skills.add(element.getAsString());
            }
        }
        if (obj.has("items")) {
            for (Object element : obj.getAsJsonArray("items")) {
                try {
                    this.items.add(new ItemEntry(element.getAsJsonObject()));
                }
                catch (Exception e) {
                    ClassesLogger.logError("Error adding item " + element.toString(), e);
                }
            }
        }
        JsonObject aobj = obj.getAsJsonObject("attributes");
        if (obj.has("attributes")) {
            for (String element : aobj.keySet()) {
                try {
                    this.attributes.add(new AttributeEntry(new ResourceLocation(element), aobj.get(element).getAsDouble()));
                }
                catch (Exception e) {
                    ClassesLogger.logInfo("Error adding attribute " + element + ", " + e.getMessage());
                }
            }
        }
        if (obj.has("commands")) {
            for (String element : obj.getAsJsonArray("commands")) {
                this.commands.add(CommandEntry.fromJson((JsonElement)element, name.toString()));
            }
        }
        this.hidden = obj.has("hidden") ? obj.get("hidden").getAsBoolean() : false;
        String string = this.animation = obj.has("animation") ? obj.get("animation").getAsString() : "epicfight:biped/combat/sword_auto1";
        if (obj.has("offset") && (offset = obj.getAsJsonArray("offset")).size() >= 2) {
            this.xOffset = offset.get(0).getAsFloat();
            this.yOffset = offset.get(1).getAsFloat();
            return;
        }
        this.yOffset = 0.0f;
        this.xOffset = 0.0f;
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    public String getTranslationKey() {
        return "class." + this.name.toString().replace(":", ".");
    }

    public void applyStatModifiers(Player player) {
        ClassesLogger.logInfo("Applying " + this + " modifiers to player " + player.m_5446_().getString());
        for (AttributeEntry entry : this.attributes) {
            entry.apply(player);
        }
        player.m_21153_(player.m_21233_());
    }

    public void addItems(Player player) {
        for (ItemEntry item : this.items) {
            item.apply(player);
        }
    }

    public void runCommands(ServerPlayer player, CommandApplyStage ... stages) {
        ClassesLogger.logInfo("Running " + this + " commands for player " + player.m_5446_().getString());
        for (CommandEntry command : this.commands) {
            for (CommandApplyStage stage : stages) {
                if (command.getStage() != stage) continue;
                command.apply(player);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public List<ItemEntry> getItems() {
        return this.items;
    }

    public List<AttributeEntry> getAttributes() {
        return this.attributes;
    }

    public List<String> getSkills() {
        return this.skills;
    }

    public List<CommandEntry> getCommands() {
        return this.commands;
    }

    public void setVisualEquipment(Player player) {
        for (ItemEntry item : this.items) {
            item.apply(player);
        }
    }

    public String getAnimation() {
        return this.animation;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("index", (Number)this.index);
        JsonArray skills = new JsonArray();
        for (String string : this.skills) {
            skills.add((JsonElement)new JsonPrimitive(string));
        }
        obj.add("starting_skills", (JsonElement)skills);
        JsonArray items = new JsonArray();
        for (ItemEntry itemEntry : this.items) {
            items.add((JsonElement)itemEntry.serialize());
        }
        obj.add("items", (JsonElement)items);
        JsonObject jsonObject = new JsonObject();
        for (AttributeEntry entry : this.attributes) {
            jsonObject.addProperty(entry.getName().toString(), (Number)entry.getValue());
        }
        obj.add("attributes", (JsonElement)jsonObject);
        JsonArray jsonArray = new JsonArray();
        obj.add("commands", (JsonElement)jsonArray);
        obj.addProperty("animation", this.animation);
        JsonArray offset = new JsonArray();
        offset.add((Number)Float.valueOf(this.xOffset));
        offset.add((Number)Float.valueOf(this.yOffset));
        obj.add("offset", (JsonElement)offset);
        ClassesLogger.logInfo("Serialized class " + this.name + " as " + obj);
        return obj;
    }
}

