/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes.data;

import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.data.CommandApplyStage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class CommandEntry {
    private final String command;
    private final CommandApplyStage stage;

    public CommandEntry(String command, CommandApplyStage stage) {
        this.command = command;
        this.stage = stage;
    }

    public void apply(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        ClassesLogger.logInfo("Running command " + this.command + " for player " + player.m_5446_().getString());
        server.m_129892_().m_82117_(server.m_129893_().m_81324_().m_81325_(2).m_81329_((Entity)player).m_81348_(player.m_20182_()).m_81327_(player.m_183503_()), this.command);
    }

    public CommandApplyStage getStage() {
        return this.stage;
    }

    public String toString() {
        return this.command + " " + this.stage;
    }

    public static CommandEntry fromJson(JsonElement json, String name) {
        try {
            if (json.isJsonPrimitive()) {
                return new CommandEntry(json.getAsString(), CommandApplyStage.PICK_CLASS);
            }
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                return new CommandEntry(obj.get("command").getAsString(), obj.has("stage") ? CommandApplyStage.fromJson(obj) : CommandApplyStage.PICK_CLASS);
            }
        }
        catch (Exception e) {
            ClassesLogger.logError("Failed reading command entry " + json + " for class " + name, e);
        }
        return null;
    }
}

