/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes.data;

import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.client.AttributeProperties;
import com.afunproject.dawncraft.classes.integration.ParaglidersIntegration;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeEntry {
    private final Attribute attribute;
    private final double value;
    private MutableComponent text;

    public AttributeEntry(ResourceLocation attribute, double value) throws Exception {
        this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attribute);
        if (this.attribute == null) {
            throw new NullPointerException("Attribute " + attribute + " not registered.");
        }
        this.value = value;
    }

    public void apply(Player player) {
        ClassesLogger.logInfo("Applying attribute " + this.attribute.getRegistryName() + " with value " + this.value + " to player " + player.m_5446_().getString());
        if (ModList.get().isLoaded("paraglider") && ParaglidersIntegration.isStamina(this.attribute)) {
            ParaglidersIntegration.apply(player, this.value);
        } else {
            player.m_21051_(this.attribute).m_22100_(this.value);
        }
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public double getValue() {
        return this.value;
    }

    public ResourceLocation getName() {
        return this.attribute.getRegistryName();
    }

    public MutableComponent getText() {
        if (this.text == null) {
            this.text = AttributeProperties.INSTANCE.getText(this.attribute, this.value);
        }
        return this.text;
    }

    public TextColor getTextColour() {
        return AttributeProperties.INSTANCE.getTextColour(this.attribute);
    }

    public String toString() {
        return this.getName() + " " + this.value;
    }
}

