/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes.client;

import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.Constants;
import com.afunproject.dawncraft.classes.client.AttributeSlot;
import com.afunproject.dawncraft.classes.client.ClassSlot;
import com.afunproject.dawncraft.classes.client.ClassSwitchButton;
import com.afunproject.dawncraft.classes.client.ConfirmButtom;
import com.afunproject.dawncraft.classes.client.ItemSlot;
import com.afunproject.dawncraft.classes.data.AttributeEntry;
import com.afunproject.dawncraft.classes.data.DCClass;
import com.afunproject.dawncraft.classes.data.ItemEntry;
import com.afunproject.dawncraft.classes.integration.CuriosIntegration;
import com.afunproject.dawncraft.classes.integration.epicfight.EpicFightIntegration;
import com.afunproject.dawncraft.classes.integration.epicfight.client.EpicFightPlayerRenderer;
import com.afunproject.dawncraft.classes.integration.epicfight.client.SkillSlot;
import com.afunproject.dawncraft.classes.network.NetworkHandler;
import com.afunproject.dawncraft.classes.network.PickClassMessage;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.GuiUtils;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;

public class ClassSelectionScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Constants.loc("textures/gui/class_selection.png");
    private static final int TEXT_WIDTH = 40;
    protected int guiWidth = 168;
    protected int guiHeight = 180;
    private int page = 0;
    private final List<DCClass> classes;
    private final RemotePlayer player;
    private final EpicFightPlayerRenderer playerRenderer;
    private final List<AbstractButton> buttons = Lists.newArrayList();
    protected int leftPos;
    protected int topPos;
    protected final List<Component> description = Lists.newArrayList();
    private final List<ClassSlot> slots = Lists.newArrayList();
    private int itemX;
    private int itemWidth;
    private int itemHeight;
    private int skillX;
    private int skillWidth;
    private int skillHeight;

    public ClassSelectionScreen(List<DCClass> cache) {
        super((Component)new TranslatableComponent("title.dcclasses.screen"));
        Minecraft minecraft = Minecraft.m_91087_();
        this.player = new RemotePlayer(minecraft.f_91073_, minecraft.f_91074_.m_36316_());
        EpicFightPlayerRenderer epicFightPlayerRenderer = this.playerRenderer = ModList.get().isLoaded("epicfight") ? new EpicFightPlayerRenderer(this.player) : null;
        if (cache.isEmpty()) {
            ClassesLogger.logError("no enabled classes ", new Exception());
            this.classes = null;
            return;
        }
        this.classes = cache.stream().sorted(Comparator.comparingInt(DCClass::getIndex)).collect(Collectors.toList());
        this.reloadEquipment();
        this.reloadText();
    }

    public void m_7856_() {
        this.buttons.clear();
        this.leftPos = (this.f_96543_ - this.guiWidth) / 2;
        this.topPos = (this.f_96544_ - this.guiHeight) / 2;
        this.buttons.add(new ClassSwitchButton(this, this.leftPos + 4, this.topPos - 10, true));
        this.buttons.add(new ClassSwitchButton(this, this.leftPos + this.guiWidth - 16, this.topPos - 10, false));
        this.buttons.add((AbstractButton)new ConfirmButtom(this, this.leftPos + this.guiWidth / 2 - 30, this.topPos + this.guiHeight));
        this.reloadSlots();
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        GuiUtils.drawContinuousTexturedBox((PoseStack)poseStack, (ResourceLocation)TEXTURE, (int)(this.leftPos + 10), (int)(this.topPos + 10), (int)0, (int)0, (int)148, (int)106, (int)32, (int)42, (int)19, (int)9, (int)9, (int)9, (float)1.0f);
        for (Widget widget : this.buttons) {
            widget.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        DCClass clazz = this.getSelectedClass();
        if (clazz == null) {
            return;
        }
        this.drawBox(poseStack, this.leftPos + 18, this.topPos - 10, 131, 17);
        ClassSelectionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)new TranslatableComponent(clazz.getTranslationKey()), (int)(this.leftPos + this.guiWidth / 2), (int)(this.topPos - 6), (int)10357970);
        int n = (int)((float)(this.description.size() * 9) / 2.0f);
        this.drawBox(poseStack, this.leftPos - 6, this.topPos + this.guiHeight / 2 + 48 - n, 179, this.description.size() * 9 + 8);
        for (int i = 0; i < this.description.size(); ++i) {
            Component component = this.description.get(i);
            ClassSelectionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)component, (int)(this.leftPos + this.guiWidth / 2), (int)(this.topPos + this.guiHeight / 2 + 52 + i * 9 - n), (int)0xFFFFFF);
        }
        int entityX = this.leftPos + this.guiWidth / 2;
        int entityY = this.topPos + this.guiHeight / 2 + 13;
        if (this.playerRenderer != null) {
            this.playerRenderer.render(poseStack, (float)entityX + clazz.getXOffset(), (float)entityY + clazz.getYOffset(), partialTicks, clazz.getAnimation());
        } else {
            InventoryScreen.m_98850_((int)entityX, (int)entityY, (int)38, (float)(entityX - mouseX), (float)((float)entityY + this.player.m_20192_() - (float)mouseY), (LivingEntity)this.player);
        }
        if (this.itemHeight > 0) {
            this.drawBox(poseStack, this.itemX, this.topPos + 17, this.itemWidth, this.itemHeight);
            ClassSelectionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)new TranslatableComponent("text.dcclasses.items"), (int)(this.leftPos - 12), (int)(this.topPos + 21), (int)0xFFFFFF);
        }
        if (this.skillHeight > 0) {
            this.drawBox(poseStack, this.skillX, this.topPos + 17, this.skillWidth, this.skillHeight);
            ClassSelectionScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96541_.f_91062_, (Component)new TranslatableComponent("text.dcclasses.skills"), (int)(this.leftPos + this.guiWidth + 12), (int)(this.topPos + 21), (int)0xFFFFFF);
        }
        ClassSlot hoveredSlot = null;
        for (ClassSlot slot : this.slots) {
            slot.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            if (hoveredSlot != null || !slot.isMouseOver(mouseX, mouseY)) continue;
            hoveredSlot = slot;
        }
        if (hoveredSlot != null) {
            this.m_169388_(poseStack, hoveredSlot.getTooltip(), Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_95587_) {
        for (AbstractButton button : this.buttons) {
            if (!button.m_5953_(mouseX, mouseY)) continue;
            return button.m_6375_(mouseX, mouseY, p_95587_);
        }
        return false;
    }

    public void m_7379_() {
        if (this.classes != null) {
            this.classes.clear();
        }
        super.m_7379_();
    }

    public void switchPage(int page) {
        this.page = Math.floorMod(page + this.page, this.classes.size());
        this.reloadEquipment();
        this.reloadText();
        this.reloadSlots();
    }

    public void confirm() {
        NetworkHandler.NETWORK_INSTANCE.sendTo((Object)new PickClassMessage(this.getSelectedClass().getRegistryName()), this.f_96541_.f_91074_.f_108617_.m_6198_(), NetworkDirection.PLAY_TO_SERVER);
        this.m_7379_();
    }

    public DCClass getSelectedClass() {
        if (this.classes == null) {
            this.m_7379_();
            return null;
        }
        if (this.classes.size() == 0) {
            return null;
        }
        return this.classes.get(this.page);
    }

    private void reloadEquipment() {
        DCClass clazz = this.getSelectedClass();
        if (clazz == null) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.player.m_8061_(slot, ItemStack.f_41583_);
        }
        this.player.m_150109_().m_6211_();
        if (ModList.get().isLoaded("curios")) {
            CuriosIntegration.clear((Player)this.player);
        }
        clazz.setVisualEquipment((Player)this.player);
    }

    private void reloadText() {
        this.description.clear();
        DCClass clazz = this.getSelectedClass();
        if (clazz == null) {
            return;
        }
        String str = new TranslatableComponent(clazz.getTranslationKey() + ".desc").getString();
        int position = 0;
        block0: while (position < str.length() && this.description.size() < 7) {
            int i;
            int size = Math.min(40, str.length() - position);
            while (Minecraft.m_91087_().f_91062_.m_92895_(str.substring(position, position + size)) > 169) {
                --size;
            }
            int newPos = position + size;
            if (str.substring(position, newPos).contains("\n")) {
                i = str.substring(position, newPos).indexOf("\n");
                this.description.add((Component)new TextComponent(str.substring(position, position + i)));
                position = position + i + 1;
                continue;
            }
            if (newPos >= str.length()) {
                this.description.add((Component)new TextComponent(str.substring(position)));
                break;
            }
            for (i = 0; i <= size; ++i) {
                if (i == size) {
                    this.description.add((Component)new TextComponent(str.substring(position, newPos + 1)));
                    position = newPos;
                    continue block0;
                }
                if (str.charAt(newPos - i) != ' ') continue;
                this.description.add((Component)new TextComponent(str.substring(position, newPos - i + 1)));
                position = newPos - i + 1;
                continue block0;
            }
        }
    }

    private void reloadSlots() {
        this.slots.clear();
        DCClass clazz = this.getSelectedClass();
        if (clazz == null) {
            return;
        }
        List<AttributeEntry> attributes = clazz.getAttributes();
        for (int i = 0; i < attributes.size(); ++i) {
            AttributeEntry attribute = attributes.get(i);
            int width = this.f_96541_.f_91062_.m_92852_((FormattedText)attribute.getText()) + 11;
            this.slots.add(new AttributeSlot(attribute, width, this.leftPos + 11 + (int)(((float)this.guiWidth - 22.0f) * (float)(i + 1) / ((float)attributes.size() + 1.0f)) - (int)((float)width * 0.5f), this.topPos + 13));
        }
        List<ItemEntry> items = clazz.getItems();
        int itemRows = (int)(((float)items.size() - 1.0f) / 3.0f) + 1;
        this.itemWidth = Math.max(itemRows * 18, this.f_96541_.f_91062_.m_92852_((FormattedText)new TranslatableComponent("text.dcclasses.items"))) + 8;
        this.itemHeight = items.isEmpty() ? 0 : 20 + (int)Math.ceil((float)items.size() / (float)itemRows) * 18;
        this.itemX = this.leftPos - 12 - (int)((float)this.itemWidth / 2.0f);
        for (int i = 0; i < items.size(); ++i) {
            this.slots.add(new ItemSlot(items.get(i), this.leftPos - 28 + itemRows * 8 - i % itemRows * 18, this.topPos + 32 + i / itemRows * 18));
        }
        if (!ModList.get().isLoaded("epicfight")) {
            return;
        }
        List<String> skills = EpicFightIntegration.getVerifiedSkills(clazz);
        int skillRows = (int)((float)(skills.size() - 1) / 3.0f) + 1;
        this.skillWidth = Math.max(skillRows * 18, this.f_96541_.f_91062_.m_92852_((FormattedText)new TranslatableComponent("text.dcclasses.skills"))) + 8;
        this.skillHeight = skills.isEmpty() ? 0 : 20 + (int)Math.ceil((float)skills.size() / (float)skillRows) * 18;
        this.skillX = this.leftPos + this.guiWidth + 12 - (int)((float)this.skillWidth / 2.0f);
        for (int i = 0; i < skills.size(); ++i) {
            this.slots.add(new SkillSlot(skills.get(i), this.leftPos + this.guiWidth + 12 - skillRows * 8 + i % skillRows * 18, this.topPos + 32 + i / skillRows * 18));
        }
    }

    private void drawBox(PoseStack poseStack, int x, int y, int width, int height) {
        GuiUtils.drawContinuousTexturedBox((PoseStack)poseStack, (ResourceLocation)TEXTURE, (int)x, (int)y, (int)0, (int)42, (int)width, (int)height, (int)32, (int)32, (int)4, (int)4, (int)4, (int)4, (float)1.0f);
    }

    public boolean m_7043_() {
        return true;
    }

    public boolean m_6913_() {
        return false;
    }
}

