/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes.client;

import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.client.AttributeProperty;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.compress.utils.Lists;

public class AttributeProperties
extends SimplePreparableReloadListener<List<JsonObject>> {
    private final Map<Attribute, AttributeProperty> properties = Maps.newHashMap();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static AttributeProperties INSTANCE = new AttributeProperties();

    protected List<JsonObject> prepare(ResourceManager manager, ProfilerFiller profiler) {
        ArrayList properties = Lists.newArrayList();
        try {
            for (String domain : manager.m_7187_()) {
                ResourceLocation loc = new ResourceLocation(domain, "attributes.json");
                if (!manager.m_7165_(loc)) continue;
                for (Resource resource : manager.m_7396_(loc)) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8));
                    JsonElement json = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                    if (!json.isJsonObject()) continue;
                    properties.add(json.getAsJsonObject());
                }
            }
        }
        catch (Exception e) {
            ClassesLogger.logErrorCompletable("Exception Loading properties", e);
        }
        return properties;
    }

    protected void apply(List<JsonObject> objects, ResourceManager manager, ProfilerFiller profiler) {
        this.properties.clear();
        for (JsonObject obj : objects) {
            for (String attribute : obj.keySet()) {
                try {
                    this.properties.put((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attribute)), new AttributeProperty(obj.get(attribute).getAsJsonObject()));
                    ClassesLogger.logInfo("added property " + attribute + " as " + obj.get(attribute).getAsJsonObject());
                }
                catch (Exception e) {
                    ClassesLogger.logErrorCompletable("Exception Loading properties", e);
                }
            }
        }
    }

    public MutableComponent getText(Attribute attribute, double value) {
        if (this.properties.containsKey(attribute)) {
            AttributeProperty property = this.properties.get(attribute);
            double scaledValue = value / property.getBase();
            return new TextComponent((String)(property.getMode() == AttributeProperty.DisplayMode.PERCENTAGE ? this.format("%.2f", scaledValue * 100.0) + "%" : this.format("%.2f", scaledValue)));
        }
        return new TextComponent(this.format("%.2f", value));
    }

    private String format(String format, double value) {
        int i;
        String string = String.format(format, value);
        for (i = string.length(); i >= 0 && string.charAt(i - 1) == '0'; --i) {
        }
        if (i < string.length()) {
            string = string.substring(0, i);
        }
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public TextColor getTextColour(Attribute attribute) {
        return this.properties.containsKey(attribute) ? this.properties.get(attribute).getTextColour() : TextColor.m_131266_((int)0xFFFFFF);
    }
}

