/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes;

import com.afunproject.dawncraft.classes.ClassHandler;
import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.DCClasses;
import com.afunproject.dawncraft.classes.data.CommandApplyStage;
import com.afunproject.dawncraft.classes.data.DCClass;
import com.afunproject.dawncraft.classes.integration.epicfight.EpicFightIntegration;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;

public interface PickedClass {
    public Optional<DCClass> getDCClass();

    @Nullable
    public void setDCClass(DCClass var1);

    public boolean hasPicked();

    public boolean hasEffect();

    public void applyEffect(ServerPlayer var1, boolean var2);

    public void applyStatModifiers(ServerPlayer var1);

    public void setGUIOpen(boolean var1);

    public boolean isGUIOpen();

    public boolean hasStatModifiers();

    public CompoundTag save();

    public void load(CompoundTag var1);

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final PickedClass impl = new Implementation();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == DCClasses.PICKED_CLASS ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.impl.save();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.impl.load(nbt);
        }
    }

    public static class Implementation
    implements PickedClass {
        private Optional<DCClass> clazz = Optional.empty();
        private boolean hasEffect;
        private boolean GUIOpen;
        private boolean hasStatModifiers;

        @Override
        public Optional<DCClass> getDCClass() {
            return this.clazz;
        }

        @Override
        public void setDCClass(DCClass clazz) {
            this.clazz = clazz == null ? Optional.empty() : Optional.of(clazz);
        }

        @Override
        public boolean hasPicked() {
            return this.clazz.isPresent();
        }

        @Override
        public boolean hasEffect() {
            return this.hasEffect;
        }

        @Override
        public void applyEffect(ServerPlayer player, boolean addItems) {
            if (this.clazz.isEmpty()) {
                return;
            }
            DCClass clazz = this.clazz.get();
            if (ModList.get().isLoaded("epicfight")) {
                EpicFightIntegration.applySkills(clazz, player);
            }
            this.applyStatModifiers(player);
            if (addItems) {
                clazz.addItems((Player)player);
            }
            clazz.runCommands(player, CommandApplyStage.PICK_CLASS, CommandApplyStage.RESPAWN);
            ClassesLogger.logInfo("Set player " + player.m_5446_().getString() + " to class " + clazz);
            this.hasEffect = true;
        }

        @Override
        public void applyStatModifiers(ServerPlayer player) {
            if (this.clazz.isEmpty()) {
                return;
            }
            this.clazz.get().applyStatModifiers((Player)player);
            this.hasEffect = true;
            this.hasStatModifiers = true;
        }

        @Override
        public void setGUIOpen(boolean GUIOpen) {
            this.GUIOpen = GUIOpen;
        }

        @Override
        public boolean isGUIOpen() {
            return this.GUIOpen;
        }

        @Override
        public boolean hasStatModifiers() {
            return this.hasStatModifiers;
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            if (this.clazz.isPresent()) {
                tag.m_128359_("class", this.clazz.get().toString());
            }
            if (this.hasEffect) {
                tag.m_128379_("hasEffect", this.hasEffect);
            }
            return tag;
        }

        @Override
        public void load(CompoundTag tag) {
            if (tag.m_128441_("class")) {
                this.clazz = Optional.of(ClassHandler.getClass(new ResourceLocation(tag.m_128461_("class"))));
            }
            if (tag.m_128441_("hasEffect")) {
                this.hasEffect = tag.m_128471_("hasEffect");
            }
        }
    }
}

