/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes;

import com.afunproject.dawncraft.classes.ClassHandler;
import com.afunproject.dawncraft.classes.ClassesLogger;
import com.afunproject.dawncraft.classes.DCClasses;
import com.afunproject.dawncraft.classes.PickedClass;
import com.afunproject.dawncraft.classes.event.PickClassEvent;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;

public class PickClassCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pickClass").requires(commandSource -> commandSource.m_6761_(1))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"class", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(ClassHandler::getSuggestions).executes(PickClassCommand::execute)));
        dispatcher.register(command);
    }

    public static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        for (ServerPlayer player : EntityArgument.m_91477_(ctx, (String)"player")) {
            LazyOptional optional = player.getCapability(DCClasses.PICKED_CLASS, null);
            try {
                if (!optional.isPresent()) continue;
                PickedClass cap = (PickedClass)optional.resolve().get();
                ResourceLocation clazz = ResourceLocationArgument.m_107011_(ctx, (String)"class");
                PickClassEvent.Pre event = new PickClassEvent.Pre((Player)player, ClassHandler.getClass(clazz), true);
                MinecraftForge.EVENT_BUS.post((Event)event);
                cap.setDCClass(event.getDCClass());
                if (cap.hasEffect()) {
                    cap.applyEffect(player, false);
                } else {
                    cap.applyEffect(player, true);
                }
                MinecraftForge.EVENT_BUS.post((Event)new PickClassEvent.Post((Player)player, event.getDCClass(), true));
                ClassesLogger.logInfo("Successfully ran command to add " + player + " to class " + clazz);
            }
            catch (Exception e) {
                ClassesLogger.logError("Failed to run pick class command", e);
            }
        }
        return 1;
    }
}

