/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes;

import com.afunproject.dawncraft.classes.ClassHandler;
import com.afunproject.dawncraft.classes.Constants;
import com.afunproject.dawncraft.classes.DCClasses;
import com.afunproject.dawncraft.classes.PickClassCommand;
import com.afunproject.dawncraft.classes.PickedClass;
import com.afunproject.dawncraft.classes.data.CommandApplyStage;
import com.afunproject.dawncraft.classes.data.CommandEntry;
import com.afunproject.dawncraft.classes.data.DCClass;
import com.afunproject.dawncraft.classes.data.DCClassLoader;
import com.afunproject.dawncraft.classes.network.NetworkHandler;
import com.afunproject.dawncraft.classes.network.OpenClassGUIMessage;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;

public class EventHandler {
    @SubscribeEvent
    public void addResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)DCClassLoader.INSTANCE);
    }

    @SubscribeEvent
    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PickedClass.class);
    }

    @SubscribeEvent
    public void attachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player & !(entity instanceof FakePlayer)) {
            event.addCapability(Constants.loc("picked_class"), (ICapabilityProvider)new PickedClass.Provider());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void loggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        LazyOptional optional = player.getCapability(DCClasses.PICKED_CLASS);
        if (!optional.isPresent()) {
            return;
        }
        PickedClass cap = (PickedClass)optional.orElseGet(null);
        if (!cap.hasPicked() & !ClassHandler.getClasses().isEmpty()) {
            NetworkHandler.NETWORK_INSTANCE.sendTo((Object)new OpenClassGUIMessage(), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            cap.setGUIOpen(true);
        }
    }

    @SubscribeEvent
    public void tick(LivingEvent.LivingUpdateEvent event) {
        Optional<DCClass> clazz;
        if (event.getEntity() == null) {
            return;
        }
        Entity player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        LazyOptional optional = player.getCapability(DCClasses.PICKED_CLASS);
        if (!optional.isPresent()) {
            return;
        }
        PickedClass cap = (PickedClass)optional.orElseGet(null);
        if (!cap.hasPicked() & !ClassHandler.getClasses().isEmpty() & !cap.isGUIOpen()) {
            NetworkHandler.NETWORK_INSTANCE.sendTo((Object)new OpenClassGUIMessage(), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            cap.setGUIOpen(true);
        }
        if (cap.hasPicked() & !cap.hasStatModifiers()) {
            cap.applyStatModifiers((ServerPlayer)player);
        }
        if ((clazz = cap.getDCClass()).isEmpty()) {
            return;
        }
        for (CommandEntry entry : clazz.get().getCommands()) {
            CommandApplyStage stage = entry.getStage();
            if (!(stage instanceof CommandApplyStage.Ticking) || player.f_19797_ % ((CommandApplyStage.Ticking)stage).getInterval() != 0) continue;
            entry.apply((ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public void damage(LivingAttackEvent event) {
        Optional<DCClass> clazz;
        if (event.getEntity() == null) {
            return;
        }
        Entity entity = event.getEntity();
        LazyOptional optional = entity.getCapability(DCClasses.PICKED_CLASS);
        if (!optional.isPresent()) {
            return;
        }
        PickedClass cap = (PickedClass)optional.orElseGet(null);
        if (cap.isGUIOpen()) {
            event.setCanceled(true);
        }
        if ((clazz = cap.getDCClass()).isEmpty()) {
            return;
        }
        clazz.get().runCommands((ServerPlayer)entity, CommandApplyStage.HURT);
    }

    @SubscribeEvent
    public void livingHurtEvent(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7640_();
        if (!(attacker instanceof ServerPlayer)) {
            return;
        }
        LazyOptional optional = attacker.getCapability(DCClasses.PICKED_CLASS);
        if (!optional.isPresent()) {
            return;
        }
        Optional<DCClass> clazz = ((PickedClass)optional.orElseGet(null)).getDCClass();
        if (clazz.isEmpty()) {
            return;
        }
        clazz.get().runCommands((ServerPlayer)attacker, CommandApplyStage.ATTACK);
    }

    @SubscribeEvent
    public void dieEvent(LivingDeathEvent event) {
        Optional<DCClass> clazz;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        LazyOptional optional = entity.getCapability(DCClasses.PICKED_CLASS);
        if (!optional.isPresent()) {
            return;
        }
        PickedClass cap = (PickedClass)optional.orElseGet(null);
        if (cap.isGUIOpen()) {
            event.setCanceled(true);
        }
        if ((clazz = cap.getDCClass()).isEmpty()) {
            return;
        }
        clazz.get().runCommands((ServerPlayer)entity, CommandApplyStage.DIE);
    }

    @SubscribeEvent
    public void killEvent(LivingDeathEvent event) {
        Optional<DCClass> clazz;
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        LazyOptional optional = entity.getCapability(DCClasses.PICKED_CLASS);
        if (!optional.isPresent()) {
            return;
        }
        PickedClass cap = (PickedClass)optional.orElseGet(null);
        if (cap.isGUIOpen()) {
            event.setCanceled(true);
        }
        if ((clazz = cap.getDCClass()).isEmpty()) {
            return;
        }
        clazz.get().runCommands((ServerPlayer)entity, CommandApplyStage.KILL);
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        if (!(event.getPlayer() instanceof ServerPlayer)) {
            return;
        }
        Player original = event.getOriginal();
        Player player = event.getPlayer();
        original.reviveCaps();
        if (!original.m_36316_().equals((Object)player.m_36316_())) {
            return;
        }
        LazyOptional optionalOld = original.getCapability(DCClasses.PICKED_CLASS);
        LazyOptional optional = player.getCapability(DCClasses.PICKED_CLASS);
        if (optionalOld.isPresent() && optional.isPresent()) {
            PickedClass cap = (PickedClass)optional.orElseGet(null);
            cap.load(((PickedClass)optionalOld.orElseGet(null)).save());
            Optional<DCClass> clazz = cap.getDCClass();
            if (clazz.isEmpty()) {
                return;
            }
            clazz.get().runCommands((ServerPlayer)player, CommandApplyStage.RESPAWN);
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        PickClassCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }
}

