/*
 * Decompiled with CFR 0.152.
 */
package com.afunproject.dawncraft.classes;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;

public class ClassesLogger {
    private static Path log_file = Paths.get("logs/dcclasses.log", new String[0]);

    public static void clearLog() {
        try {
            Files.write(log_file, (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void logInfo(Object message) {
        ClassesLogger.writeToFile(message);
    }

    public static void logError(Object message, Exception e) {
        ClassesLogger.writeToFile(e);
        ClassesLogger.writeToFile(message);
        for (StackTraceElement traceElement : e.getStackTrace()) {
            ClassesLogger.writeToFile(traceElement);
        }
        e.printStackTrace();
    }

    public static void logErrorCompletable(Object message, Exception e) {
        ClassesLogger.writeToFile(message);
        for (StackTraceElement traceElement : e.getStackTrace()) {
            ClassesLogger.writeToFile(traceElement);
        }
    }

    private static boolean writeToFile(Object message) {
        return ClassesLogger.writeToFile(Lists.newArrayList((Object[])new String[]{String.valueOf(message)}));
    }

    private static boolean writeToFile(List<String> out) {
        if (out.size() > 0) {
            out.set(0, Timestamp.valueOf(LocalDateTime.now()) + "[" + (Thread.currentThread().equals(SidedThreadGroups.SERVER) ? "SERVER" : "CLIENT") + "]" + out.get(0));
        }
        try {
            Files.write(log_file, out, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

